/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.sqlgenerator;

import java.util.Arrays;
import java.util.List;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.ValidationErrors;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AddDefaultValueGenerator;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.core.AddDefaultValueStatement;
import liquibase.structure.DatabaseObject;

public class AddDefaultValueGeneratorDatabricks
extends AddDefaultValueGenerator {
    private static final List<String> NUMERIC_TYPES = Arrays.asList("TINYINT", "SMALLINT", "INT", "BIGINT", "FLOAT", "DOUBLE", "DECIMAL");

    public int getPriority() {
        return 5;
    }

    public boolean supports(AddDefaultValueStatement statement, Database database) {
        return database instanceof DatabricksDatabase;
    }

    public ValidationErrors validate(AddDefaultValueStatement addDefaultValueStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors errors = super.validate(addDefaultValueStatement, database, sqlGeneratorChain);
        try {
            if (addDefaultValueStatement.getDefaultValue() instanceof DatabaseFunction && database.getDatabaseMajorVersion() < 3) {
                errors.addError("This version of Databricks does not support non-literal default values");
            }
        }
        catch (DatabaseException e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("Can't get default value");
        }
        return errors;
    }

    public Sql[] generateSql(AddDefaultValueStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        Object defaultValue = statement.getDefaultValue();
        String columnDataType = statement.getColumnDataType();
        String finalDefaultValue = defaultValue instanceof DatabaseFunction ? defaultValue.toString() : (NUMERIC_TYPES.contains(columnDataType) && defaultValue instanceof String ? defaultValue.toString().replace("'", "").trim() : DataTypeFactory.getInstance().fromObject(defaultValue, database).objectToSql(defaultValue, database));
        return new Sql[]{new UnparsedSql("ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " ALTER COLUMN " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName()) + " SET DEFAULT " + finalDefaultValue, new DatabaseObject[]{this.getAffectedColumn(statement)})};
    }
}

