/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.database;

import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import liquibase.Scope;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.ext.databricks.database.DatabricksConnection;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawCallStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import lombok.Generated;

public class DatabricksDatabase
extends AbstractJdbcDatabase {
    public static final String PRODUCT_NAME = "databricks";
    private String systemSchema = "information_schema";
    private Set<String> systemTablesAndViews = new HashSet<String>();
    public static final List<String> VALID_AUTO_INCREMENT_COLUMN_TYPE_NAMES = Collections.singletonList("BIGINT");

    public DatabricksDatabase() {
        super.setCurrentDateTimeFunction("current_timestamp()");
        super.addReservedWords(this.getDatabricksReservedWords());
        this.defaultAutoIncrementStartWith = BigInteger.ONE;
        this.defaultAutoIncrementBy = BigInteger.ONE;
    }

    protected String getQuotingStartCharacter() {
        return "`";
    }

    protected String getQuotingEndCharacter() {
        return "`";
    }

    protected String getQuotingEndReplacement() {
        return "``";
    }

    public String getDatabaseChangeLogTableName() {
        return super.getDatabaseChangeLogTableName().toLowerCase(Locale.US);
    }

    public String getDatabaseChangeLogLockTableName() {
        return super.getDatabaseChangeLogLockTableName().toLowerCase(Locale.US);
    }

    public String getShortName() {
        return PRODUCT_NAME;
    }

    public String getDefaultDatabaseProductName() {
        return PRODUCT_NAME;
    }

    public Set<String> getSystemViews() {
        return this.systemTablesAndViews;
    }

    public String getSystemSchema() {
        return this.systemSchema;
    }

    public Integer getDefaultPort() {
        return 443;
    }

    public int getPriority() {
        return 5;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName()) || conn.getDatabaseProductName().equalsIgnoreCase("SparkSQL") || conn.getDatabaseProductName().equalsIgnoreCase("spark");
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:databricks") || url.startsWith("jdbc:spark")) {
            return "com.databricks.client.jdbc.Driver";
        }
        return null;
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return true;
    }

    public boolean supportsDropTableCascadeConstraints() {
        return false;
    }

    public boolean supportsCatalogInObjectName(Class<? extends DatabaseObject> type) {
        return true;
    }

    public boolean supportsTablespaces() {
        return false;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsDatabaseChangeLogHistory() {
        return true;
    }

    public String getAutoIncrementClause(BigInteger startWith, BigInteger incrementBy, String generationType, Boolean defaultOnNull) {
        if (!this.supportsAutoIncrement()) {
            return "";
        }
        String autoIncrementClause = this.getAutoIncrementClause(generationType, defaultOnNull);
        boolean generateStartWith = this.generateAutoIncrementStartWith(startWith);
        boolean generateIncrementBy = this.generateAutoIncrementBy(incrementBy);
        if (generateStartWith || generateIncrementBy) {
            autoIncrementClause = autoIncrementClause + this.buildAutoIncrementClause(startWith, incrementBy, generateStartWith, generateIncrementBy);
        }
        return autoIncrementClause;
    }

    private String buildAutoIncrementClause(BigInteger startWith, BigInteger incrementBy, boolean generateStartWith, boolean generateIncrementBy) {
        StringBuilder clauseBuilder = new StringBuilder(this.getAutoIncrementOpening());
        if (generateStartWith) {
            clauseBuilder.append(String.format(this.getAutoIncrementStartWithClause(), startWith == null ? this.defaultAutoIncrementStartWith : startWith));
        }
        if (generateIncrementBy) {
            if (generateStartWith) {
                clauseBuilder.append(" ");
            }
            clauseBuilder.append(String.format(this.getAutoIncrementByClause(), incrementBy == null ? this.defaultAutoIncrementBy : incrementBy));
        }
        clauseBuilder.append(this.getAutoIncrementClosing());
        return clauseBuilder.toString();
    }

    public boolean generateAutoIncrementStartWith(BigInteger startWith) {
        return true;
    }

    public boolean generateAutoIncrementBy(BigInteger incrementBy) {
        return true;
    }

    protected SqlStatement getConnectionSchemaNameCallStatement() {
        return new RawCallStatement("select current_schema()");
    }

    protected String getConnectionSchemaName() {
        String string;
        block11: {
            DatabaseConnection connection = this.getConnection();
            if (connection == null) {
                return null;
            }
            ResultSet resultSet = ((DatabricksConnection)connection).createStatement().executeQuery("SELECT CURRENT_SCHEMA()");
            try {
                resultSet.next();
                string = resultSet.getString(1);
                if (resultSet == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Error getting default schema via existing context, going to pull from URL", (Throwable)e);
                    try {
                        String foundSchema = this.parseUrlForSchema(connection.getURL());
                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("SCHEMA IDENTIFIED: " + foundSchema);
                        return foundSchema;
                    }
                    catch (Exception e2) {
                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Cannot get default / defined schema from URL or current session.");
                        return null;
                    }
                }
            }
            resultSet.close();
        }
        return string;
    }

    protected String getConnectionCatalogName() {
        DatabaseConnection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        try {
            return connection.getCatalog();
        }
        catch (Exception e) {
            String string;
            block13: {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Cannot get default / defined CATALOG from current session.");
                ResultSet resultSet = ((DatabricksConnection)connection).createStatement().executeQuery("SELECT CURRENT_CATALOG()");
                try {
                    resultSet.next();
                    string = resultSet.getString(1);
                    if (resultSet == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e2) {
                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Error getting default catalog via existing context, going to pull from URL", (Throwable)e2);
                        try {
                            String foundCatalog = this.parseUrlForCatalog(connection.getURL());
                            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("CATALOG IDENTIFIED: " + foundCatalog);
                            return foundCatalog;
                        }
                        catch (Exception e3) {
                            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Cannot get default / defined CATALOG from URL");
                            return null;
                        }
                    }
                }
                resultSet.close();
            }
            return string;
        }
    }

    private String parseUrlForSchema(String url) {
        String schemaToken = "ConnSchema";
        return DatabricksConnection.getUrlParamValue(url, schemaToken, this.defaultSchemaName);
    }

    private String parseUrlForCatalog(String url) {
        String schemaToken = "ConnCatalog";
        return DatabricksConnection.getUrlParamValue(url, schemaToken, this.defaultCatalogName);
    }

    public void setDefaultSchemaName(String schemaName) {
        this.defaultSchemaName = this.correctObjectName(schemaName, Schema.class);
    }

    public void setDefaultCatalogName(String catalogName) {
        this.defaultCatalogName = this.correctObjectName(catalogName, Catalog.class);
    }

    private Set<String> getDatabricksReservedWords() {
        return new HashSet<String>(Arrays.asList("ANTI", "CROSS", "EXCEPT", "FULL", "INNER", "INTERSECT", "JOIN", "LATERAL", "LEFT", "MINUS", "NATURAL", "ON", "RIGHT", "SEMI", "USING", "UNION", "NULL", "DEFAULT", "TRUE", "FALSE", "LATERAL", "BUILTIN", "SESSION", "INFORMATION_SCHEMA", "SYS", "ALL", "ALTER", "AND", "ANY", "ARRAY", "AS", "AT", "AUTHORIZATION", "BETWEEN", "BOTH", "BY", "CASE", "CAST", "CHECK", "COLLATE", "COLUMN", "COMMIT", "CONSTRAINT", "CREATE", "CROSS", "CUBE", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DELETE", "DESCRIBE", "DISTINCT", "DROP", "ELSE", "END", "ESCAPE", "EXCEPT", "EXISTS", "EXTERNAL", "EXTRACT", "FETCH", "FILTER", "FOR", "FOREIGN", "FROM", "FULL", "FUNCTION", "GLOBAL", "GRANT", "GROUP", "GROUPING", "HAVING", "IN", "INNER", "INSERT", "INTERSECT", "INTERVAL", "INTO", "IS", "JOIN", "LEADING", "LEFT", "LIKE", "LOCAL", "NATURAL", "NO", "NOT", "NULL", "OF", "ON", "ONLY", "OR", "ORDER", "OUT", "OUTER", "OVERLAPS", "PARTITION", "POSITION", "PRIMARY", "RANGE", "REFERENCES", "REVOKE", "RIGHT", "ROLLBACK", "ROLLUP", "ROW", "ROWS", "SELECT", "SESSION_USER", "SET", "SOME", "START", "TABLE", "TABLESAMPLE", "THEN", "TIME", "TO", "TRAILING", "TRUE", "TRUNCATE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "USER", "USING", "VALUES", "WHEN", "WHERE", "WINDOW", "WITH"));
    }

    public void setConnection(DatabaseConnection conn) {
        Object dbConn = conn instanceof JdbcConnection ? new DatabricksConnection(((JdbcConnection)conn).getWrappedConnection()) : conn;
        super.setConnection(dbConn);
    }

    public void checkDatabaseConnection() throws DatabaseException {
        DatabricksConnection connection = (DatabricksConnection)this.getConnection();
        try {
            String catalogName = this.getConnectionCatalogName();
            String schemaName = this.getConnectionSchemaName();
            ResultSet schemasAlikeUsed = connection.getMetaData().getSchemas(catalogName, schemaName);
            while (schemasAlikeUsed.next()) {
                if (!schemasAlikeUsed.getString(1).equals(schemaName)) continue;
                return;
            }
            throw new DatabaseException(String.format("Please specify existing schema and catalog in connection url. Current connection points to '%s.%s'", catalogName, schemaName));
        }
        catch (SQLException e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Error checking database connection", (Throwable)e);
            return;
        }
    }

    @Generated
    public void setSystemSchema(String systemSchema) {
        this.systemSchema = systemSchema;
    }
}

