/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.change.optimizeTable;

import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext.databricks.change.optimizeTable.OptimizeTableStatement;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class OptimizeTableGenerator
extends AbstractSqlGenerator<OptimizeTableStatement> {
    public boolean supports(OptimizeTableStatement statement, Database database) {
        return database instanceof DatabricksDatabase;
    }

    public ValidationErrors validate(OptimizeTableStatement statement, Database database, SqlGeneratorChain chain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)statement.getTableName());
        return validationErrors;
    }

    public Sql[] generateSql(OptimizeTableStatement statement, Database database, SqlGeneratorChain chain) {
        StringBuilder sql = new StringBuilder("OPTIMIZE ");
        sql.append(database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()));
        if (!statement.getZorderColumns().isEmpty()) {
            sql.append(" ZORDER BY (").append(String.join((CharSequence)", ", statement.getZorderColumns())).append(")");
        }
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
    }
}

