/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.change.dropCheckConstraint;

import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext.databricks.change.dropCheckConstraint.DropCheckConstraintStatementDatabricks;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class DropCheckConstraintGeneratorDatabricks
extends AbstractSqlGenerator<DropCheckConstraintStatementDatabricks> {
    public boolean supports(DropCheckConstraintStatementDatabricks statement, Database database) {
        return database instanceof DatabricksDatabase;
    }

    public ValidationErrors validate(DropCheckConstraintStatementDatabricks statement, Database database, SqlGeneratorChain chain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)statement.getTableName());
        validationErrors.checkRequiredField("constraintName", (Object)statement.getConstraintName());
        return validationErrors;
    }

    public Sql[] generateSql(DropCheckConstraintStatementDatabricks statement, Database database, SqlGeneratorChain chain) {
        StringBuilder sql = new StringBuilder("ALTER TABLE ");
        sql.append(database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()));
        sql.append(" DROP CONSTRAINT ");
        sql.append(statement.getConstraintName());
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
    }
}

