/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.change.addCheckConstraint;

import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext.databricks.change.addCheckConstraint.AddCheckConstraintStatementDatabricks;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class AddCheckConstraintGeneratorDatabricks
extends AbstractSqlGenerator<AddCheckConstraintStatementDatabricks> {
    public boolean supports(AddCheckConstraintStatementDatabricks statement, Database database) {
        return database instanceof DatabricksDatabase;
    }

    public ValidationErrors validate(AddCheckConstraintStatementDatabricks statement, Database database, SqlGeneratorChain chain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)statement.getTableName());
        validationErrors.checkRequiredField("constraintName", (Object)statement.getConstraintName());
        validationErrors.checkRequiredField("constraintBody", (Object)statement.getConstraintBody());
        return validationErrors;
    }

    public Sql[] generateSql(AddCheckConstraintStatementDatabricks statement, Database database, SqlGeneratorChain chain) {
        StringBuilder sql = new StringBuilder("ALTER TABLE ");
        sql.append(database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()));
        sql.append(" ADD CONSTRAINT ");
        sql.append(statement.getConstraintName());
        sql.append(" CHECK (").append(statement.getConstraintBody()).append(")");
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
    }
}

