/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.stream;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;
import org.jkiss.dbeaver.tools.transfer.stream.StreamProducerSettings;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferProducer;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.pages.DataTransferPageNodeSettings;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;

public class StreamProducerPageSettings
extends DataTransferPageNodeSettings {
    private static final Log log = Log.getLog(StreamProducerPageSettings.class);
    private PropertyTreeViewer propsEditor;
    private PropertySourceCustom propertySource;
    private Table filesTable;
    private ToolItem tiOpenLocal;
    private ToolItem tiOpenRemote;

    public StreamProducerPageSettings() {
        super(DTMessages.data_transfer_wizard_page_input_files_name);
        this.setTitle(DTMessages.data_transfer_wizard_page_input_files_title);
        this.setDescription(DTMessages.data_transfer_wizard_page_input_files_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        boolean skipTargetColumn;
        boolean showRemoteFS;
        this.initializeDialogUnits((Control)parent);
        SashForm settingsDivider = new SashForm(parent, 512);
        settingsDivider.setLayoutData((Object)new GridData(1808));
        Composite inputFilesGroup = UIUtils.createComposite((Composite)settingsDivider, (int)1);
        inputFilesGroup.setLayoutData((Object)new GridData(1808));
        UIUtils.createControlLabel((Composite)inputFilesGroup, (String)DTMessages.data_transfer_wizard_settings_group_input_files);
        Composite inputFilesTableGroup = new Composite(inputFilesGroup, 2048);
        inputFilesTableGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        inputFilesTableGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        DBPProject project = ((DataTransferWizard)this.getWizard()).getProject();
        final boolean showLocalFS = true;
        boolean bl = showRemoteFS = project != null && DBFUtils.supportsMultiFileSystems((DBPProject)project);
        if (showLocalFS || showRemoteFS) {
            ToolBar toolbar = new ToolBar(inputFilesTableGroup, 8519936);
            if (showLocalFS) {
                this.tiOpenLocal = UIUtils.createToolItem((ToolBar)toolbar, (String)UIMessages.text_with_open_dialog_browse, (String)UIMessages.text_with_open_dialog_browse, (DBPImage)DBIcon.TREE_FOLDER, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> new SelectInputFileAction(false).run()));
            }
            if (showRemoteFS) {
                this.tiOpenRemote = UIUtils.createToolItem((ToolBar)toolbar, (String)UIMessages.text_with_open_dialog_browse_remote, (String)UIMessages.text_with_open_dialog_browse_remote, (DBPImage)UIIcon.OPEN_EXTERNAL, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> new SelectInputFileAction(true).run()));
            }
            UIUtils.createLabelSeparator((Composite)inputFilesTableGroup, (int)256);
        }
        this.filesTable = new Table(inputFilesTableGroup, 65540);
        this.filesTable.setLayoutData((Object)new GridData(1808));
        this.filesTable.setHeaderVisible(true);
        this.filesTable.setLinesVisible(true);
        if (showLocalFS || showRemoteFS) {
            UIUtils.setControlContextMenu((Control)this.filesTable, manager -> {
                if (showLocalFS) {
                    manager.add((IAction)new SelectInputFileAction(false));
                }
                if (showRemoteFS) {
                    manager.add((IAction)new SelectInputFileAction(true));
                }
            });
        }
        if (DBWorkbench.getPlatform().getApplication().isDistributed()) {
            UIUtils.createInfoLink((Composite)inputFilesGroup, (String)"You cannot use files stored on this PC in scheduled tasks.\nIf you want to use the files for export/import, please transfer them to <a href=\"#\">Cloud Storage</a>.", () -> {
                boolean bl = ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Cloud-Storage"));
            }).setToolTipText("Scheduled tasks don't have access to files stored on this PC because they're executed on a remote server.");
        }
        UIUtils.createTableColumn((Table)this.filesTable, (int)16384, (String)DTUIMessages.data_transfer_wizard_final_column_source);
        List sourceObjects = ((DataTransferWizard)this.getWizard()).getSettings().getSourceObjects();
        if (CommonUtils.isEmpty((Collection)sourceObjects)) {
            skipTargetColumn = true;
        } else {
            boolean allSourceObjectsNotTables = true;
            for (DBSObject sourceObject : sourceObjects) {
                if (!(sourceObject instanceof DBSDataManipulator)) continue;
                allSourceObjectsNotTables = false;
                break;
            }
            skipTargetColumn = allSourceObjectsNotTables;
        }
        if (!skipTargetColumn) {
            UIUtils.createTableColumn((Table)this.filesTable, (int)16384, (String)DTUIMessages.data_transfer_wizard_final_column_target);
        }
        this.filesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StreamProducerPageSettings.this.updateBrowseButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                new SelectInputFileAction(!showLocalFS).run();
            }
        });
        Composite exporterSettings = UIUtils.createComposite((Composite)settingsDivider, (int)1);
        UIUtils.createControlLabel((Composite)exporterSettings, (String)DTMessages.data_transfer_wizard_settings_group_importer);
        this.propsEditor = new PropertyTreeViewer(exporterSettings, 2048);
        settingsDivider.setWeights(new int[]{400, 600});
        this.setControl((Control)settingsDivider);
        this.updatePageCompletion();
    }

    private void chooseSourceFile(DataTransferPipe pipe, boolean remoteFS) {
        String[] extensions = new String[]{"*." + CommonUtils.toString((Object)this.propertySource.getPropertyValue(null, "extension")).replace(",", ";*."), "*.*"};
        DBRRunnableWithProgress initializer = null;
        DBPProject project = pipe.getConsumer().getProject();
        if (remoteFS && project != null) {
            DBNPathBase selected = DBWorkbench.getPlatformUI().openFileSystemSelector(DTUIMessages.stream_producer_select_input_file, false, 4096, false, extensions, pipe.getConsumer().getObjectName());
            if (selected != null) {
                initializer = monitor -> this.updateSingleConsumer(monitor, pipe, selected.getPath());
            }
        } else if (pipe.getConsumer() != null && pipe.getConsumer().getTargetObjectContainer() != null) {
            File[] files = DialogUtils.openFileList((Shell)this.getShell(), (String)DTUIMessages.stream_producer_select_input_file, (String[])extensions);
            if (files != null && files.length > 0) {
                initializer = monitor -> this.updateMultiConsumers(monitor, pipe, (Path[])Arrays.stream(files).map(File::toPath).toArray(Path[]::new));
            }
        } else {
            File file = DialogUtils.openFile((Shell)this.getShell(), (String[])extensions);
            if (file != null) {
                initializer = monitor -> this.updateSingleConsumer(monitor, pipe, file.toPath());
            }
        }
        if (initializer != null) {
            try {
                ((DataTransferWizard)this.getWizard()).getRunnableContext().run(true, true, initializer);
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError(DTUIMessages.stream_producer_column_mapping_error_title, DTUIMessages.stream_producer_column_mapping_error_message, e.getTargetException());
                return;
            }
            catch (InterruptedException interruptedException) {}
        }
        this.reloadPipes();
        this.updatePageCompletion();
    }

    /*
     * WARNING - void declaration
     */
    private void updateSingleConsumer(DBRProgressMonitor monitor, DataTransferPipe pipe, Path path) {
        IDataTransferSettings consumerSettings;
        Object v0;
        StreamProducerSettings producerSettings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamProducerSettings.class);
        IDataTransferProducer iDataTransferProducer = pipe.getProducer();
        if (iDataTransferProducer instanceof StreamTransferProducer) {
            void stp;
            StreamTransferProducer streamTransferProducer = (StreamTransferProducer)iDataTransferProducer;
            StreamTransferProducer cfr_ignored_0 = (StreamTransferProducer)iDataTransferProducer;
            v0 = stp;
        } else {
            v0 = null;
        }
        Object oldProducer = v0;
        StreamTransferProducer newProducer = new StreamTransferProducer(new StreamEntityMapping(path));
        pipe.setProducer((IDataTransferProducer)newProducer);
        producerSettings.updateProducerSettingsFromStream(monitor, newProducer, ((DataTransferWizard)this.getWizard()).getSettings());
        IDataTransferSettings iDataTransferSettings = consumerSettings = ((DataTransferWizard)this.getWizard()).getSettings().getNodeSettings(((DataTransferWizard)this.getWizard()).getSettings().getConsumer());
        if (iDataTransferSettings instanceof DatabaseConsumerSettings) {
            DBSDataContainer dBSDataContainer;
            DatabaseMappingContainer oldMappingContainer;
            DBSObject dBSObject;
            void settings;
            DatabaseConsumerSettings databaseConsumerSettings = (DatabaseConsumerSettings)iDataTransferSettings;
            DatabaseConsumerSettings cfr_ignored_1 = (DatabaseConsumerSettings)iDataTransferSettings;
            DatabaseMappingContainer mapping = new DatabaseMappingContainer((DatabaseConsumerSettings)settings, (DBSDataContainer)newProducer.getDatabaseObject());
            if (pipe.getConsumer() != null && (dBSObject = pipe.getConsumer().getDatabaseObject()) instanceof DBSDataManipulator) {
                void databaseObject;
                DBSDataManipulator dBSDataManipulator = (DBSDataManipulator)dBSObject;
                DBSDataManipulator cfr_ignored_2 = (DBSDataManipulator)dBSObject;
                DBSObject container = databaseObject.getParentObject();
                if (container instanceof DBSObjectContainer) {
                    settings.setContainer((DBSObjectContainer)container);
                }
                mapping.setTarget((DBSDataManipulator)databaseObject);
            } else {
                mapping.setTarget(null);
                mapping.setTargetName(this.generateTableName(newProducer.getObjectName()));
            }
            if (oldProducer != null && (oldMappingContainer = (DatabaseMappingContainer)settings.getDataMappings().remove(oldProducer.getDatabaseObject())) != null && (dBSDataContainer = oldMappingContainer.getSource()) instanceof StreamEntityMapping) {
                void oldEntityMapping;
                StreamEntityMapping streamEntityMapping = (StreamEntityMapping)dBSDataContainer;
                StreamEntityMapping cfr_ignored_3 = (StreamEntityMapping)dBSDataContainer;
                if (oldEntityMapping.isSameColumns(newProducer.getEntityMapping())) {
                    StreamEntityMapping entityMapping = new StreamEntityMapping(path);
                    settings.addDataMappings(((DataTransferWizard)this.getWizard()).getRunnableContext(), (DBSDataContainer)entityMapping, new DatabaseMappingContainer(oldMappingContainer, (DBSDataContainer)entityMapping));
                    StreamTransferProducer producer = new StreamTransferProducer(entityMapping);
                    pipe.setProducer((IDataTransferProducer)producer);
                    producerSettings.updateProducerSettingsFromStream(monitor, producer, ((DataTransferWizard)this.getWizard()).getSettings());
                    return;
                }
            }
            settings.addDataMappings(((DataTransferWizard)this.getWizard()).getRunnableContext(), (DBSDataContainer)newProducer.getDatabaseObject(), mapping);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateMultiConsumers(DBRProgressMonitor monitor, DataTransferPipe pipe, Path[] files) {
        StreamProducerSettings producerSettings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamProducerSettings.class);
        IDataTransferConsumer originalConsumer = pipe.getConsumer();
        DataTransferSettings dtSettings = ((DataTransferWizard)this.getWizard()).getSettings();
        ArrayList<DataTransferPipe> newPipes = new ArrayList<DataTransferPipe>(dtSettings.getDataPipes());
        newPipes.remove(pipe);
        Deque pendingEntityMappings = Arrays.stream(files).map(StreamEntityMapping::new).collect(Collectors.toCollection(ArrayDeque::new));
        while (!pendingEntityMappings.isEmpty()) {
            void dcs;
            Object object;
            IDataTransferSettings consumerSettings;
            StreamEntityMapping entityMapping = (StreamEntityMapping)pendingEntityMappings.remove();
            if (producerSettings.extractExtraEntities(monitor, entityMapping, dtSettings, (Collection)pendingEntityMappings)) continue;
            StreamTransferProducer producer = new StreamTransferProducer(entityMapping);
            DatabaseTransferConsumer consumer = new DatabaseTransferConsumer();
            DataTransferPipe singlePipe = new DataTransferPipe((IDataTransferProducer)producer, (IDataTransferConsumer)consumer);
            try {
                singlePipe.initPipe(dtSettings, newPipes.size(), newPipes.size());
            }
            catch (DBException e) {
                log.error((Object)e);
                continue;
            }
            newPipes.add(singlePipe);
            producerSettings.updateProducerSettingsFromStream(monitor, producer, dtSettings);
            IDataTransferSettings iDataTransferSettings = consumerSettings = dtSettings.getNodeSettings(dtSettings.getConsumer());
            if (!(iDataTransferSettings instanceof DatabaseConsumerSettings)) continue;
            DatabaseConsumerSettings cfr_ignored_0 = (DatabaseConsumerSettings)iDataTransferSettings;
            DatabaseConsumerSettings cfr_ignored_1 = (DatabaseConsumerSettings)iDataTransferSettings;
            if (originalConsumer != null && (object = originalConsumer.getTargetObjectContainer()) instanceof DBSObjectContainer) {
                void oc;
                DBSObjectContainer cfr_ignored_2 = (DBSObjectContainer)object;
                DBSObjectContainer cfr_ignored_3 = (DBSObjectContainer)object;
                dcs.setContainer((DBSObjectContainer)oc);
            }
            DatabaseMappingContainer mapping = new DatabaseMappingContainer((DatabaseConsumerSettings)dcs, (DBSDataContainer)producer.getDatabaseObject());
            mapping.setTargetName(this.generateTableName(producer.getObjectName()));
            dcs.addDataMappings(((DataTransferWizard)this.getWizard()).getRunnableContext(), (DBSDataContainer)producer.getDatabaseObject(), mapping);
        }
        dtSettings.setDataPipes(newPipes, false);
        dtSettings.setPipeChangeRestricted(true);
    }

    /*
     * WARNING - void declaration
     */
    private void updateItemData(TableItem item, DataTransferPipe pipe) {
        IDataTransferProducer producer = pipe.getProducer();
        if (this.isInvalidDataTransferNode((IDataTransferNode<?>)producer)) {
            item.setImage(0, null);
            item.setText(0, DTUIMessages.stream_consumer_page_settings_item_text_none);
        } else {
            String string;
            item.setImage(0, DBeaverIcons.getImage((DBPImage)this.getProducerProcessor().getIcon()));
            IDataTransferProducer iDataTransferProducer = producer;
            if (iDataTransferProducer instanceof StreamTransferProducer) {
                void stp;
                StreamTransferProducer streamTransferProducer = (StreamTransferProducer)iDataTransferProducer;
                StreamTransferProducer cfr_ignored_0 = (StreamTransferProducer)iDataTransferProducer;
                string = stp.getInputFile().toString();
            } else {
                string = String.valueOf(producer.getObjectName());
            }
            item.setText(0, string);
        }
        IDataTransferConsumer consumer = pipe.getConsumer();
        if (this.isInvalidDataTransferNode((IDataTransferNode<?>)consumer)) {
            item.setImage(1, null);
            item.setText(1, DTUIMessages.stream_consumer_page_settings_item_text_none);
        } else {
            item.setImage(1, DBeaverIcons.getImage((DBPImage)((DataTransferWizard)this.getWizard()).getSettings().getConsumer().getIcon()));
            item.setText(1, String.valueOf(consumer.getObjectName()));
        }
    }

    private boolean isInvalidDataTransferNode(IDataTransferNode<?> node) {
        return node == null || node.getObjectName() == null;
    }

    public void activatePage() {
        ((DataTransferWizard)this.getWizard()).loadNodeSettings();
        DataTransferProcessorDescriptor processor = this.getProducerProcessor();
        DBPPropertyDescriptor[] properties = processor == null ? new DBPPropertyDescriptor[]{} : processor.getProperties();
        this.propertySource = new PropertySourceCustom(properties, ((DataTransferWizard)this.getWizard()).getSettings().getProcessorProperties());
        this.propsEditor.loadProperties((DBPPropertySource)this.propertySource);
        this.reloadPipes();
        this.updatePageCompletion();
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.filesTable, (boolean)true));
    }

    public void deactivatePage() {
        this.propsEditor.saveEditorValues();
        Map processorProperties = this.propertySource.getPropertiesWithDefaults();
        DataTransferSettings dtSettings = ((DataTransferWizard)this.getWizard()).getSettings();
        dtSettings.setProcessorProperties(processorProperties);
        StreamProducerSettings producerSettings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamProducerSettings.class);
        if (producerSettings != null) {
            producerSettings.setProcessorProperties(processorProperties);
        }
        IDataTransferSettings consumerSettings = ((DataTransferWizard)this.getWizard()).getSettings().getNodeSettings(((DataTransferWizard)this.getWizard()).getSettings().getConsumer());
        try {
            ((DataTransferWizard)this.getWizard()).getRunnableContext().run(true, true, monitor -> {
                for (DataTransferPipe pipe : dtSettings.getDataPipes()) {
                    DatabaseMappingContainer mapping;
                    void producer;
                    IDataTransferProducer iDataTransferProducer = pipe.getProducer();
                    if (!(iDataTransferProducer instanceof StreamTransferProducer)) continue;
                    StreamTransferProducer cfr_ignored_0 = (StreamTransferProducer)iDataTransferProducer;
                    StreamTransferProducer cfr_ignored_1 = (StreamTransferProducer)iDataTransferProducer;
                    if (producerSettings != null) {
                        producerSettings.updateProducerSettingsFromStream(monitor, (StreamTransferProducer)producer, dtSettings);
                    }
                    if (!(consumerSettings instanceof DatabaseConsumerSettings) || (mapping = ((DatabaseConsumerSettings)consumerSettings).getDataMapping((DBSDataContainer)producer.getDatabaseObject())) == null) continue;
                    mapping.getAttributeMappings(monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Error updating stream settings", "Error updating settings", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        super.deactivatePage();
    }

    protected boolean determinePageCompletion() {
        int i = 0;
        while (i < this.filesTable.getItemCount()) {
            DataTransferPipe pipe = (DataTransferPipe)this.filesTable.getItem(i).getData();
            if (this.isInvalidDataTransferNode((IDataTransferNode<?>)pipe.getConsumer()) || this.isInvalidDataTransferNode((IDataTransferNode<?>)pipe.getProducer())) {
                this.setMessage(DTUIMessages.stream_consumer_page_warning_not_enough_sources_chosen, 2);
                return false;
            }
            ++i;
        }
        this.setMessage(null);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void reloadPipes() {
        boolean firstTime = this.filesTable.getItemCount() == 0;
        DataTransferSettings settings = ((DataTransferWizard)this.getWizard()).getSettings();
        int selectionIndex = this.filesTable.getSelectionIndex();
        this.filesTable.removeAll();
        List dataPipes = settings.getDataPipes();
        for (DataTransferPipe pipe : dataPipes) {
            TableItem item = new TableItem(this.filesTable, 0);
            item.setData((Object)pipe);
            this.updateItemData(item, pipe);
        }
        if (!dataPipes.isEmpty()) {
            IDataTransferProducer iDataTransferProducer;
            DataTransferPipe pipe;
            if (selectionIndex < 0) {
                selectionIndex = 0;
            } else if (selectionIndex >= dataPipes.size()) {
                selectionIndex = dataPipes.size() - 1;
            }
            pipe = (DataTransferPipe)dataPipes.get(selectionIndex);
            this.filesTable.select(selectionIndex);
            if (firstTime && (iDataTransferProducer = pipe.getProducer()) instanceof StreamTransferProducer) {
                void stp;
                StreamTransferProducer streamTransferProducer = (StreamTransferProducer)iDataTransferProducer;
                StreamTransferProducer cfr_ignored_0 = (StreamTransferProducer)iDataTransferProducer;
                if (stp.getInputFile() == null) {
                    UIUtils.asyncExec(() -> this.chooseSourceFile(pipe, DBWorkbench.isDistributed() && ((DataTransferWizard)this.getWizard()).getCurrentTask() != null));
                }
            }
        }
        this.updateBrowseButtons();
    }

    private void updateBrowseButtons() {
        boolean hasSelection;
        boolean bl = hasSelection = this.filesTable.getSelection().length > 0;
        if (this.tiOpenLocal != null) {
            this.tiOpenLocal.setEnabled(hasSelection);
        }
        if (this.tiOpenRemote != null) {
            this.tiOpenRemote.setEnabled(hasSelection);
        }
    }

    private DataTransferProcessorDescriptor getProducerProcessor() {
        return ((DataTransferWizard)this.getWizard()).getSettings().getProcessor();
    }

    @NotNull
    private String generateTableName(String fileName) {
        StringBuilder name = new StringBuilder();
        int divPos = fileName.lastIndexOf(".");
        if (divPos != -1) {
            fileName = fileName.substring(0, divPos);
        }
        boolean lastCharSpecial = false;
        char lastChar = '\u0000';
        int i = 0;
        while (i < fileName.length()) {
            block8: {
                char c;
                block7: {
                    c = fileName.charAt(i);
                    if (!Character.isLetter(c) && lastCharSpecial) break;
                    boolean bl = lastCharSpecial = !Character.isLetterOrDigit(c);
                    if (!lastCharSpecial) break block7;
                    if (c != '_') {
                        c = '_';
                    }
                    if (lastChar == '_') break block8;
                }
                lastChar = c;
                name.append(c);
            }
            ++i;
        }
        if (name.length() > 0 && name.charAt(name.length() - 1) == '_') {
            name.deleteCharAt(name.length() - 1);
        }
        return name.toString();
    }

    public boolean isPageApplicable() {
        return this.isProducerOfType(StreamTransferProducer.class);
    }

    private class SelectInputFileAction
    extends Action {
        private boolean remote;

        public SelectInputFileAction(boolean remote) {
            super(remote ? UIMessages.text_with_open_dialog_browse_remote : UIMessages.text_with_open_dialog_browse);
            this.remote = remote;
        }

        public void run() {
            if (StreamProducerPageSettings.this.filesTable.getSelectionIndex() < 0) {
                return;
            }
            TableItem item = StreamProducerPageSettings.this.filesTable.getItem(StreamProducerPageSettings.this.filesTable.getSelectionIndex());
            DataTransferPipe pipe = (DataTransferPipe)item.getData();
            StreamProducerPageSettings.this.chooseSourceFile(pipe, this.remote);
        }
    }
}

