/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.views;

import com.dbeaver.ee.influxdb.InfluxDBMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.influxdb.InfluxDB;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class InfluxAdvancedSettingsPage
extends ConnectionPageAbstract {
    private static final Log log = Log.getLog(InfluxAdvancedSettingsPage.class);
    private Spinner connectTimeoutSpinner;
    private Spinner readTimeoutSpinner;
    private Spinner writeTimeoutSpinner;
    private Combo defConsistencyLevel;

    public InfluxAdvancedSettingsPage() {
        this.setTitle("Influx configuration");
        this.setDescription("Influx connection advanced settings");
    }

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite cfgGroup = new Composite(parent, 0);
        cfgGroup.setLayout((Layout)new GridLayout(1, true));
        cfgGroup.setLayoutData((Object)new GridData(1808));
        Group timeoutsGroup = UIUtils.createControlGroup((Composite)cfgGroup, (String)InfluxDBMessages.connection_page_control_group_timeouts, (int)2, (int)768, (int)0);
        this.connectTimeoutSpinner = UIUtils.createLabelSpinner((Composite)timeoutsGroup, (String)InfluxDBMessages.settings_page_label_spinner_connect_timeout, (String)InfluxDBMessages.settings_page_label_spinner_tip_connect_timeout, (int)0, (int)0, (int)Integer.MAX_VALUE);
        this.readTimeoutSpinner = UIUtils.createLabelSpinner((Composite)timeoutsGroup, (String)InfluxDBMessages.settings_page_label_spinner_read_timeout, (String)InfluxDBMessages.settings_page_label_spinner_tip_read_timeout, (int)0, (int)0, (int)Integer.MAX_VALUE);
        this.writeTimeoutSpinner = UIUtils.createLabelSpinner((Composite)timeoutsGroup, (String)InfluxDBMessages.settings_page_label_spinner_write_timeout, (String)InfluxDBMessages.settings_page_label_spinner_tip_write_timeout, (int)0, (int)0, (int)Integer.MAX_VALUE);
        Group miscGroup = UIUtils.createControlGroup((Composite)cfgGroup, (String)InfluxDBMessages.connection_page_control_group_misc, (int)2, (int)768, (int)0);
        this.defConsistencyLevel = UIUtils.createLabelCombo((Composite)miscGroup, (String)InfluxDBMessages.connection_page_label_combo_default_consistency_level, (String)InfluxDBMessages.connection_page_label_combo_tip_consistency_level, (int)12);
        InfluxDB.ConsistencyLevel[] consistencyLevelArray = InfluxDB.ConsistencyLevel.values();
        int n = consistencyLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            InfluxDB.ConsistencyLevel cl = consistencyLevelArray[n2];
            this.defConsistencyLevel.add(cl.name());
            ++n2;
        }
        this.setControl((Control)cfgGroup);
        this.loadSettings();
    }

    public boolean isComplete() {
        return true;
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        this.connectTimeoutSpinner.setSelection(CommonUtils.toInt((Object)connectionInfo.getProviderProperty("influxdb.timeout.connect"), (int)10000));
        this.readTimeoutSpinner.setSelection(CommonUtils.toInt((Object)connectionInfo.getProviderProperty("influxdb.timeout.read"), (int)60000));
        this.writeTimeoutSpinner.setSelection(CommonUtils.toInt((Object)connectionInfo.getProviderProperty("influxdb.timeout.write"), (int)10000));
        String clName = CommonUtils.toString((Object)connectionInfo.getProviderProperty("@dbeaver-default.consistency.level@"));
        if (CommonUtils.isEmpty((String)clName)) {
            this.defConsistencyLevel.setText(InfluxDB.ConsistencyLevel.ONE.name());
        } else {
            this.defConsistencyLevel.setText(clName);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        if (this.connectTimeoutSpinner.getSelection() > 0) {
            configuration.setProviderProperty("influxdb.timeout.connect", String.valueOf(this.connectTimeoutSpinner.getSelection()));
        } else {
            configuration.removeProviderProperty("influxdb.timeout.connect");
        }
        if (this.readTimeoutSpinner.getSelection() > 0) {
            configuration.setProviderProperty("influxdb.timeout.read", String.valueOf(this.readTimeoutSpinner.getSelection()));
        } else {
            configuration.removeProviderProperty("influxdb.timeout.read");
        }
        if (this.writeTimeoutSpinner.getSelection() > 0) {
            configuration.setProviderProperty("influxdb.timeout.write", String.valueOf(this.writeTimeoutSpinner.getSelection()));
        } else {
            configuration.removeProviderProperty("influxdb.timeout.write");
        }
        configuration.setProviderProperty("@dbeaver-default.consistency.level@", String.valueOf(this.defConsistencyLevel.getText()));
    }
}

