/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.app;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.app.ExasolServerSession;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManagerSQL;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;

public class ExasolServerSessionManager
implements DBAServerSessionManager<ExasolServerSession>,
DBAServerSessionManagerSQL {
    public static final String PROP_KILL_QUERY = "killQuery";
    private static final String KILL_APP_CMD = "kill session %s";
    private static final String KILL_STMT_CMD = "kill statement in session %s";
    private static final Log log = Log.getLog(ExasolServerSessionManager.class);
    private static final String SESS_DBA_QUERY = "/*snapshot execution*/ select * from exa_dba_sessions";
    private static final String SESS_ALL_QUERY = "/*snapshot execution*/ select * from exa_ALL_sessions";
    private final ExasolDataSource dataSource;

    public ExasolServerSessionManager(ExasolDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public Collection<ExasolServerSession> getSessions(@NotNull DBCSession session, @NotNull Map<String, Object> options) throws DBException {
        try {
            return ExasolServerSessionManager.readSessions((JDBCSession)session);
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, session.getDataSource());
        }
    }

    public void alterSession(@NotNull DBCSession session, @NotNull ExasolServerSession sessionType, @NotNull Map<String, Object> options) throws DBException {
        try {
            String cmd = String.format(Boolean.TRUE.equals(options.get(PROP_KILL_QUERY)) ? KILL_STMT_CMD : KILL_APP_CMD, sessionType.getSessionID().toString());
            JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(cmd);
            dbStat.execute();
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, session.getDataSource());
        }
    }

    public static Collection<ExasolServerSession> readSessions(JDBCSession session) throws SQLException {
        log.debug((Object)"read sessions");
        ArrayList<ExasolServerSession> listSessions = new ArrayList<ExasolServerSession>();
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (JDBCStatement dbStat = session.createStatement();){
                Throwable throwable2 = null;
                Object var6_16 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery(SESS_DBA_QUERY);){
                    while (dbResult.next()) {
                        listSessions.add(new ExasolServerSession((ResultSet)dbResult));
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            Throwable throwable = null;
            Object var3_8 = null;
            try (JDBCStatement dbStat = session.createStatement();){
                Throwable throwable5 = null;
                Object var6_18 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery(SESS_ALL_QUERY);){
                    while (dbResult.next()) {
                        listSessions.add(new ExasolServerSession((ResultSet)dbResult));
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable5 == null) {
                        throwable5 = throwable6;
                    } else if (throwable5 != throwable6) {
                        throwable5.addSuppressed(throwable6);
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        return listSessions;
    }

    public boolean canGenerateSessionReadQuery() {
        return true;
    }

    @NotNull
    public String generateSessionReadQuery(@NotNull Map<String, Object> options) {
        return SESS_ALL_QUERY;
    }
}

