/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.subscription.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.subscription.SubscriptionManager;
import com.azure.resourcemanager.subscription.fluent.SubscriptionsClient;
import com.azure.resourcemanager.subscription.fluent.models.LocationInner;
import com.azure.resourcemanager.subscription.fluent.models.SubscriptionInner;
import com.azure.resourcemanager.subscription.implementation.LocationImpl;
import com.azure.resourcemanager.subscription.implementation.SubscriptionImpl;
import com.azure.resourcemanager.subscription.implementation.Utils;
import com.azure.resourcemanager.subscription.models.Location;
import com.azure.resourcemanager.subscription.models.Subscription;
import com.azure.resourcemanager.subscription.models.Subscriptions;

public final class SubscriptionsImpl
implements Subscriptions {
    private static final ClientLogger LOGGER = new ClientLogger(SubscriptionsImpl.class);
    private final SubscriptionsClient innerClient;
    private final SubscriptionManager serviceManager;

    public SubscriptionsImpl(SubscriptionsClient innerClient, SubscriptionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Location> listLocations(String subscriptionId) {
        PagedIterable<LocationInner> inner = this.serviceClient().listLocations(subscriptionId);
        return Utils.mapPage(inner, inner1 -> new LocationImpl((LocationInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<Location> listLocations(String subscriptionId, Context context) {
        PagedIterable<LocationInner> inner = this.serviceClient().listLocations(subscriptionId, context);
        return Utils.mapPage(inner, inner1 -> new LocationImpl((LocationInner)inner1, this.manager()));
    }

    @Override
    public Response<Subscription> getWithResponse(String subscriptionId, Context context) {
        Response<SubscriptionInner> inner = this.serviceClient().getWithResponse(subscriptionId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SubscriptionImpl((SubscriptionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public Subscription get(String subscriptionId) {
        SubscriptionInner inner = this.serviceClient().get(subscriptionId);
        if (inner != null) {
            return new SubscriptionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Subscription> list() {
        PagedIterable<SubscriptionInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new SubscriptionImpl((SubscriptionInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<Subscription> list(Context context) {
        PagedIterable<SubscriptionInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new SubscriptionImpl((SubscriptionInner)inner1, this.manager()));
    }

    private SubscriptionsClient serviceClient() {
        return this.innerClient;
    }

    private SubscriptionManager manager() {
        return this.serviceManager;
    }
}

