/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.bigquery.ui.views;

import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.bigquery.ui.BigQueryActivator;
import org.jkiss.dbeaver.ext.bigquery.ui.internal.BigQueryMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class BigQueryConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private static final Log log = Log.getLog(BigQueryConnectionPage.class);
    private Text projectText;
    private Text extraProjectsText;
    private Text hostText;
    private Text portText;
    private static ImageDescriptor logoImage = BigQueryActivator.getImageDescriptor("icons/bigquery_logo.png");
    private DriverPropertiesDialogPage driverPropsPage = new DriverPropertiesDialogPage((ConnectionPageAbstract)this);

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        Composite settingsGroup = new Composite(composite, 0);
        settingsGroup.setLayout((Layout)new GridLayout(1, false));
        settingsGroup.setLayoutData((Object)new GridData(1808));
        ModifyListener textListener = e -> this.site.updateButtons();
        Group addrGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)BigQueryMessages.label_connection, (int)2, (int)0, (int)0);
        addrGroup.setLayoutData((Object)new GridData(768));
        this.projectText = UIUtils.createLabelText((Composite)addrGroup, (String)BigQueryMessages.label_project, (String)"");
        this.projectText.addModifyListener(textListener);
        this.extraProjectsText = UIUtils.createLabelText((Composite)addrGroup, (String)BigQueryMessages.label_additional_project, (String)"");
        this.extraProjectsText.setToolTipText(BigQueryMessages.label_additional_project_tip);
        this.extraProjectsText.addModifyListener(textListener);
        addrGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)BigQueryMessages.label_server_info, (int)4, (int)0, (int)0);
        addrGroup.setLayoutData((Object)new GridData(768));
        this.hostText = UIUtils.createLabelText((Composite)addrGroup, (String)BigQueryMessages.label_host, (String)"https://www.googleapis.com/bigquery/v2");
        this.hostText.addModifyListener(textListener);
        this.portText = UIUtils.createLabelText((Composite)addrGroup, (String)BigQueryMessages.label_port, (String)String.valueOf(433));
        GridData gd = (GridData)this.portText.getLayoutData();
        gd.widthHint = UIUtils.getFontHeight((Control)this.portText) * 7;
        this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.portText.addModifyListener(textListener);
        this.createAuthPanel(settingsGroup, 1);
        this.createDriverPanel(settingsGroup);
        this.setControl((Control)settingsGroup);
    }

    public boolean isComplete() {
        return this.projectText != null && !CommonUtils.isEmpty((String)this.projectText.getText());
    }

    public void loadSettings() {
        String additionalProjects;
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.projectText != null) {
            String databaseName = connectionInfo.getDatabaseName();
            if (CommonUtils.isEmpty((String)databaseName)) {
                databaseName = "";
            }
            this.projectText.setText(databaseName);
        }
        if ((additionalProjects = CommonUtils.toString((Object)connectionInfo.getProviderProperty("AdditionalProjects"), (String)connectionInfo.getProperty("AdditionalProjects"))) != null) {
            this.extraProjectsText.setText(additionalProjects);
        }
        if (this.hostText != null) {
            if (CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText("https://www.googleapis.com/bigquery/v2");
            } else {
                this.hostText.setText(connectionInfo.getHostName());
            }
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(connectionInfo.getHostPort());
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.projectText != null) {
            connectionInfo.setDatabaseName(this.projectText.getText().trim());
        }
        if (this.extraProjectsText != null) {
            connectionInfo.setProviderProperty("AdditionalProjects", this.extraProjectsText.getText().trim());
        }
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        super.saveSettings(dataSource);
    }

    @NotNull
    protected String getDefaultAuthModelId(DBPDataSourceContainer dataSource) {
        return "google_bigquery";
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{this.driverPropsPage};
    }
}

