/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.keyspaces.model;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Authenticator;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.dbeaver.net.auth.aws.AWSIAMUtils;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.signer.internal.Aws4SignerUtils;

public class SigV4AuthProvider
implements AuthProvider {
    private static final byte[] SIGV4_INITIAL_RESPONSE_BYTES = "SigV4\u0000\u0000".getBytes(StandardCharsets.UTF_8);
    private static final ByteBuffer SIGV4_INITIAL_RESPONSE;
    private static final int AWS_FRACTIONAL_TIMESTAMP_DIGITS = 3;
    private static final DateTimeFormatter timestampFormatter;
    private static final byte[] NONCE_KEY;
    private static final int EXPECTED_NONCE_LENGTH = 32;
    private static final String CANONICAL_SERVICE = "cassandra";
    private final AuthModelAWSCredentials authCredentials;
    private final AwsCredentialsProvider credentialsProvider;
    private final String signingRegion;
    private static final String AMZ_ALGO_HEADER = "X-Amz-Algorithm=AWS4-HMAC-SHA256";
    private static final String AMZ_EXPIRES_HEADER = "X-Amz-Expires=900";
    private static final String HMAC_ALGORITHM = "hmacSHA256";

    static {
        ByteBuffer initialResponse = ByteBuffer.allocate(SIGV4_INITIAL_RESPONSE_BYTES.length);
        initialResponse.put(SIGV4_INITIAL_RESPONSE_BYTES);
        initialResponse.flip();
        SIGV4_INITIAL_RESPONSE = initialResponse;
        timestampFormatter = new DateTimeFormatterBuilder().appendInstant(3).toFormatter();
        NONCE_KEY = "nonce=".getBytes(StandardCharsets.UTF_8);
    }

    public SigV4AuthProvider(AuthModelAWSCredentials authCredentials, @NotNull AwsCredentialsProvider credentialsProvider, String region) {
        this.authCredentials = authCredentials;
        this.credentialsProvider = credentialsProvider;
        this.signingRegion = region;
        if (this.signingRegion == null) {
            throw new IllegalStateException("A region must be specified by constructor, AWS_REGION env variable, or aws.region system property");
        }
    }

    public Authenticator newAuthenticator(InetSocketAddress inetSocketAddress, String s) throws AuthenticationException {
        return new SigV4Authenticator();
    }

    static byte[] extractNonce(ByteBuffer challengeBuffer) {
        byte[] challenge = new byte[challengeBuffer.remaining()];
        challengeBuffer.get(challenge);
        int nonceStart = SigV4AuthProvider.indexOf(challenge, NONCE_KEY);
        if (nonceStart == -1) {
            throw new IllegalArgumentException("Did not find nonce in SigV4 challenge: " + new String(challenge, StandardCharsets.UTF_8));
        }
        int nonceEnd = nonceStart += NONCE_KEY.length;
        while (nonceEnd < challenge.length && challenge[nonceEnd] != 44) {
            ++nonceEnd;
        }
        int nonceLength = nonceEnd - nonceStart;
        if (nonceLength != 32) {
            throw new IllegalArgumentException("Expected a nonce of 32 bytes but received " + nonceLength);
        }
        return Arrays.copyOfRange(challenge, nonceStart, nonceEnd);
    }

    private String generateSignature(byte[] nonce, Instant requestTimestamp, AwsCredentials credentials) throws UnsupportedEncodingException {
        String credentialScopeDate = Aws4SignerUtils.formatDateStamp((long)requestTimestamp.toEpochMilli());
        String signingScope = String.format("%s/%s/%s/aws4_request", credentialScopeDate, this.signingRegion, CANONICAL_SERVICE);
        String nonceHash = SigV4AuthProvider.sha256Digest(nonce);
        String canonicalRequest = SigV4AuthProvider.canonicalizeRequest(credentials.accessKeyId(), signingScope, requestTimestamp, nonceHash);
        String stringToSign = String.format("%s\n%s\n%s\n%s", "AWS4-HMAC-SHA256", timestampFormatter.format(requestTimestamp), signingScope, SigV4AuthProvider.sha256Digest(canonicalRequest));
        byte[] signingKey = SigV4AuthProvider.getSignatureKey(credentials.secretAccessKey(), credentialScopeDate, this.signingRegion, CANONICAL_SERVICE);
        byte[] signature = SigV4AuthProvider.hmacSHA256(stringToSign, signingKey);
        return CommonUtils.toHexString((byte[])signature).toLowerCase(Locale.ENGLISH);
    }

    private static String canonicalizeRequest(String accessKey, String signingScope, Instant requestTimestamp, String payloadHash) throws UnsupportedEncodingException {
        List<String> queryStringHeaders = Arrays.asList(AMZ_ALGO_HEADER, String.format("X-Amz-Credential=%s%%2F%s", accessKey, URLEncoder.encode(signingScope, StandardCharsets.UTF_8.name())), "X-Amz-Date=" + URLEncoder.encode(timestampFormatter.format(requestTimestamp), StandardCharsets.UTF_8.name()), AMZ_EXPIRES_HEADER);
        Collections.sort(queryStringHeaders);
        String queryString = String.join((CharSequence)"&", queryStringHeaders);
        return String.format("PUT\n/authenticate\n%s\nhost:%s\n\nhost\n%s", queryString, CANONICAL_SERVICE, payloadHash);
    }

    static String sha256Digest(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return CommonUtils.toHexString((byte[])md.digest(bytes)).toLowerCase(Locale.ENGLISH);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("This platform does not support the SHA-256 digest algorithm", e);
        }
    }

    static String sha256Digest(String input) {
        return SigV4AuthProvider.sha256Digest(input.getBytes(StandardCharsets.UTF_8));
    }

    static byte[] hmacSHA256(String data, byte[] key) {
        try {
            Mac mac = Mac.getInstance(HMAC_ALGORITHM);
            mac.init(new SecretKeySpec(key, HMAC_ALGORITHM));
            return mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RuntimeException("Failure computing HMAC-SHA256", e);
        }
    }

    static byte[] getSignatureKey(String key, String dateStamp, String regionName, String serviceName) {
        byte[] kSecret = ("AWS4" + key).getBytes(StandardCharsets.UTF_8);
        byte[] kDate = SigV4AuthProvider.hmacSHA256(dateStamp, kSecret);
        byte[] kRegion = SigV4AuthProvider.hmacSHA256(regionName, kDate);
        byte[] kService = SigV4AuthProvider.hmacSHA256(serviceName, kRegion);
        byte[] kSigning = SigV4AuthProvider.hmacSHA256("aws4_request", kService);
        return kSigning;
    }

    static int indexOf(byte[] target, byte[] pattern) {
        int lastCheckIndex = target.length - pattern.length;
        int i = 0;
        while (i <= lastCheckIndex) {
            if (pattern[0] == target[i]) {
                int inner = 0;
                int outer = i;
                while (inner < pattern.length && pattern[inner] == target[outer]) {
                    ++inner;
                    ++outer;
                }
                if (inner == pattern.length) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public class SigV4Authenticator
    implements Authenticator {
        public byte[] initialResponse() {
            return SIGV4_INITIAL_RESPONSE.array();
        }

        public byte[] evaluateChallenge(byte[] bytes) {
            try {
                byte[] nonce = SigV4AuthProvider.extractNonce(ByteBuffer.wrap(bytes));
                Instant requestTimestamp = Instant.now();
                AwsCredentials credentials = (AwsCredentials)AWSIAMUtils.tryExecuteRecover((DBRProgressMonitor)new VoidProgressMonitor(), (AuthModelAWSCredentials)SigV4AuthProvider.this.authCredentials, () -> ((AwsCredentialsProvider)SigV4AuthProvider.this.credentialsProvider).resolveCredentials());
                String signature = SigV4AuthProvider.this.generateSignature(nonce, requestTimestamp, credentials);
                Object response = String.format("signature=%s,access_key=%s,amzdate=%s", signature, credentials.accessKeyId(), timestampFormatter.format(requestTimestamp));
                if (credentials instanceof AwsSessionCredentials) {
                    response = (String)response + ",session_token=" + ((AwsSessionCredentials)credentials).sessionToken();
                }
                return ((String)response).getBytes(StandardCharsets.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("This platform does not support the UTF-8encoding", e);
            }
            catch (Exception e) {
                throw new RuntimeException("Error authenticating AWS Keyspaces cluster", e);
            }
        }

        public void onAuthenticationSuccess(byte[] bytes) {
        }
    }
}

