/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.license.validate;

import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicenseManager;
import com.dbeaver.lm.api.LMLicenseStatus;
import com.dbeaver.lm.api.LMProduct;
import com.dbeaver.lm.api.LMSubscription;
import com.dbeaver.lm.api.LMUtils;
import com.dbeaver.model.license.internal.core.LMMessages;
import com.dbeaver.model.license.validate.LicenseCheckResult;
import com.dbeaver.model.license.validate.LicenseRequest;
import com.dbeaver.model.license.validate.PublicServiceClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class LMPublicAPI {
    public static final String BUNDLE_SYMBOLIC_NAME = "com.dbeaver.model.license";
    private static final Log log = Log.getLog(LMPublicAPI.class);
    private static final int LICENSE_CHECK_TIMEOUT = 4000;
    private static final int LICENSE_CHECK_RETRIES = 3;
    private static final int TRIAL_LICENSE_REQUEST_TIMEOUT = 60000;
    private static final int TRIAL_LICENSE_REQUEST_RETRIES = 3;

    public static LicenseCheckResult checkLicenseStatus(String clientId, LMLicenseManager licenseManager, LMLicense license, LMProduct product) {
        PublicServiceClient client = new PublicServiceClient(clientId, 4000, 3);
        try {
            String line;
            LMLicenseStatus licenseStatus;
            String licenseStatusText = client.checkLicenseStatus(license, product);
            if (CommonUtils.isEmpty((String)licenseStatusText)) {
                return new LicenseCheckResult(Status.OK_STATUS, LMLicenseStatus.VALID);
            }
            BufferedReader br = new BufferedReader(new StringReader(licenseStatusText));
            String licenseStatusString = br.readLine();
            int divPos = licenseStatusString.indexOf(58);
            if (divPos == -1) {
                return new LicenseCheckResult(GeneralUtils.makeErrorStatus((String)("Bad check status: " + licenseStatusString)), LMLicenseStatus.INVALID);
            }
            String statusCode = licenseStatusString.substring(0, divPos).trim();
            String statusMessage = licenseStatusString.substring(divPos + 1).trim();
            try {
                licenseStatus = LMLicenseStatus.valueOf((String)statusCode);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.debug((Object)("Bad license status: [" + statusCode + "]"));
                licenseStatus = LMLicenseStatus.VALID;
            }
            LicenseCheckResult checkResult = new LicenseCheckResult(GeneralUtils.makeInfoStatus((String)statusMessage), licenseStatus);
            boolean needsUpdate = false;
            StringBuilder subscriptionInfo = new StringBuilder();
            boolean inSubscription = false;
            while ((line = br.readLine()) != null) {
                if (CommonUtils.isEmpty((String)line)) continue;
                if (line.startsWith("-- LICENSE_UPDATE")) {
                    needsUpdate = true;
                    inSubscription = false;
                    continue;
                }
                if (line.startsWith("-- SUBSCRIPTION")) {
                    inSubscription = true;
                    continue;
                }
                if (!inSubscription) continue;
                subscriptionInfo.append(line).append("\n");
            }
            if (license.isSubscription() && subscriptionInfo.length() > 0) {
                try {
                    byte[] subEncrypted = LMUtils.readEncryptedString((Reader)new StringReader(subscriptionInfo.toString()));
                    LMSubscription subscription = licenseManager.readSubscriptionFromData(product, subEncrypted);
                    checkResult.setSubscription(subscription);
                }
                catch (IOException e) {
                    log.debug((Object)"Error reading subscription info", (Throwable)e);
                }
            }
            LMLicense updatedLicense = null;
            if (needsUpdate) {
                String licenseUpdate = client.getLicenseUpdate(license, product);
                if (!CommonUtils.isEmpty((String)licenseUpdate)) {
                    try {
                        updatedLicense = licenseManager.readStandardLicense(product, licenseUpdate);
                    }
                    catch (LMException e) {
                        log.error((Object)"License update read failed", (Throwable)e);
                    }
                }
            } else {
                LMLicense[] currentLicenses = licenseManager.getProductLicenses(product);
                LMLicense existingLicense = Arrays.stream(currentLicenses).filter(existsLicense -> license.getLicenseId().equals(existsLicense.getLicenseId())).findFirst().orElse(null);
                if (existingLicense != null && !existingLicense.getDataHash().equals(license.getDataHash())) {
                    updatedLicense = license;
                }
            }
            if (updatedLicense != null) {
                try {
                    boolean forceImport = licenseStatus == LMLicenseStatus.EXPIRED || licenseStatus == LMLicenseStatus.CANCELED;
                    licenseManager.importLicense(product, updatedLicense, forceImport);
                    log.debug((Object)"License info was updated from the server");
                }
                catch (LMException e) {
                    log.error((Object)"License updating license", (Throwable)e);
                }
            }
            return checkResult;
        }
        catch (Exception e) {
            return new LicenseCheckResult(GeneralUtils.makeErrorStatus((String)"Error checking license status", (Throwable)e), LMLicenseStatus.VALID);
        }
    }

    @NotNull
    public static IStatus requestTrialLicense(@NotNull DBRProgressMonitor monitor, @NotNull String clientId, @NotNull LMProduct product, @NotNull LicenseRequest request) {
        PublicServiceClient client = new PublicServiceClient(clientId, 60000, 3);
        try {
            monitor.beginTask("Request trial license", 2);
            try {
                monitor.subTask("Check license server");
                log.debug((Object)"Ping license server");
                log.debug((Object)("Ping result: " + client.ping()));
                monitor.worked(1);
            }
            catch (Exception e) {
                IStatus iStatus = GeneralUtils.makeErrorStatus((String)NLS.bind((String)LMMessages.api_trial_license_request_error_ping_failed, (Object)"dbeaver.com", (Object)e.getMessage()));
                monitor.done();
                return iStatus;
            }
            try {
                monitor.subTask("Generate license");
                log.debug((Object)"Request trial license");
                client.requestTrialLicense(product, request);
                monitor.worked(1);
            }
            catch (Exception e) {
                IStatus iStatus = GeneralUtils.makeErrorStatus((String)NLS.bind((String)LMMessages.api_trial_license_request_error_request_failed, (Object)e.getMessage()));
                monitor.done();
                return iStatus;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

