/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.license.embedded;

import com.dbeaver.lm.api.LMEnvironment;
import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMKeyProvider;
import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicenseManager;
import com.dbeaver.lm.api.LMLicenseStatus;
import com.dbeaver.lm.api.LMLicenseType;
import com.dbeaver.lm.api.LMProduct;
import com.dbeaver.lm.api.LMSubscription;
import com.dbeaver.lm.api.LMUtils;
import com.dbeaver.lm.api.LMValidateException;
import com.dbeaver.model.license.DBPLicenseService;
import com.dbeaver.model.license.app.DBPApplicationLicensed;
import com.dbeaver.model.license.app.LMAppUtils;
import com.dbeaver.model.license.embedded.LicenseKeyProviderEmbedded;
import com.dbeaver.model.license.validate.LMPublicAPI;
import com.dbeaver.model.license.validate.LicenseRequest;
import com.dbeaver.model.license.validate.PublicLicenseValidator;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class LicenseServiceEmbedded
implements DBPLicenseService {
    private static final Log log;
    public static final String LICENSE_FILE_NAME = ".lm";
    private static final LMLicenseManager licenseManager;
    private static final LMEnvironment lmEnvironment;

    static {
        String pathToLicenseFile;
        log = Log.getLog(LicenseServiceEmbedded.class);
        lmEnvironment = new LMEnvironment();
        lmEnvironment.setProductPurchaseURL(Platform.getProduct().getProperty("productPurchaseURL"));
        lmEnvironment.setArchiveURL(Platform.getProduct().getProperty("archiveURL"));
        licenseManager = new LMLicenseManager(lmEnvironment, (LMKeyProvider)new LicenseKeyProviderEmbedded(), PublicLicenseValidator.PUBLIC_LICENSE_VALIDATOR, LicenseServiceEmbedded.getLicenceRootFolder());
        IProduct product = Platform.getProduct();
        if (product != null && !CommonUtils.isEmpty((String)(pathToLicenseFile = product.getProperty("productLicense")))) {
            try {
                URL url = FileLocator.toFileURL((URL)new URL(pathToLicenseFile));
                File localFile = new File(url.getFile());
                LMLicenseManager.setLicenseCustomPath((String)localFile.getAbsolutePath());
            }
            catch (Throwable e) {
                log.warn((Object)"Error opening product license", e);
            }
        }
    }

    public LicenseServiceEmbedded() {
        this(false);
    }

    public LicenseServiceEmbedded(boolean workspaceStorage) {
        log.debug((Object)("\tInitialize license manager for " + LMAppUtils.getActiveProduct().getId()));
        if (workspaceStorage) {
            licenseManager.setConfigPath(DBWorkbench.getPlatform().getWorkspace().getMetadataFolder().resolve(LICENSE_FILE_NAME).toFile());
        }
    }

    @Override
    @Nullable
    public LMLicense getActiveProductLicense(boolean validate) {
        try {
            return licenseManager.getValidProductLicense(validate ? this.getClientId() : null, LMAppUtils.getActiveProduct());
        }
        catch (LMValidateException e) {
            log.error((Object)"Internal error while checking active license", (Throwable)e);
            return null;
        }
    }

    @Override
    public LMLicense[] getAllProductLicenses() {
        return licenseManager.getProductLicenses(DBPApplicationLicensed.getLicensedApplication().getLicenseProduct());
    }

    @Override
    public LMLicense importProductLicense(String licenseText) throws LMException {
        try {
            byte[] licenseData = LMUtils.readEncryptedString((Reader)new StringReader(licenseText.trim()));
            return licenseManager.importLicense(DBPApplicationLicensed.getLicensedApplication().getLicenseProduct(), this.getClientId(), licenseData);
        }
        catch (Exception e) {
            throw new LMException("Error importing license", (Throwable)e);
        }
    }

    @Override
    public boolean invalidateActiveLicense(boolean forceRefresh) throws LMException {
        if (forceRefresh) {
            licenseManager.clearLicenseCache();
        }
        try {
            LMLicense license = licenseManager.getValidProductLicense(this.getClientId(), LMAppUtils.getActiveProduct());
            if (license == null) {
                log.error((Object)("No license found for " + LMAppUtils.getActiveProduct().getName()));
                return false;
            }
            return true;
        }
        catch (LMValidateException lmException) {
            log.error((Object)lmException.getMessage(), (Throwable)lmException);
            return lmException.getStatus() == LMLicenseStatus.VALID;
        }
        catch (Exception e) {
            throw new LMException("Error reading valid license info", (Throwable)e);
        }
    }

    @NotNull
    private String getClientId() {
        return DBWorkbench.getPlatform().getWorkspace().getWorkspaceId();
    }

    @Override
    public void validateLicense(LMLicense license) throws LMValidateException {
        licenseManager.validateLicense(this.getClientId(), LMAppUtils.getActiveProduct(), license);
    }

    @Override
    public String getLicenseStatus(LMLicense license) throws LMException {
        return licenseManager.getLicenseValidationStatus(LMAppUtils.getActiveProduct(), license);
    }

    @Override
    public LMProduct getActiveProduct() {
        return DBPApplicationLicensed.getLicensedApplication().getLicenseProduct();
    }

    @Override
    public LMSubscription getSubscriptionInfo(LMLicense license) throws LMException {
        return licenseManager.getSubscriptionInfo(license);
    }

    @Override
    public void deleteLicense(LMLicense license) throws LMException {
        if (license.getLicenseType() == LMLicenseType.TRIAL) {
            throw new LMException("You can't delete trial license.");
        }
        licenseManager.deleteLicense(LMAppUtils.getActiveProduct(), license);
    }

    @Override
    public void deleteLicense(@NotNull String licenseId) throws LMException {
        LMLicense lmLicense = Arrays.stream(this.getAllProductLicenses()).filter(l -> licenseId.equals(l.getLicenseId())).findFirst().orElseThrow(() -> new LMException("Cannot find any license with id '" + licenseId + "'"));
        this.deleteLicense(lmLicense);
    }

    public LMLicense findTrialLicense() throws LMException {
        return licenseManager.findTrialLicense(this.getClientId(), LMAppUtils.getActiveProduct());
    }

    public IStatus requestTrialLicense(@NotNull DBRProgressMonitor monitor, @NotNull LicenseRequest request) {
        return LMPublicAPI.requestTrialLicense(monitor, this.getClientId(), LMAppUtils.getActiveProduct(), request);
    }

    @NotNull
    public static File getLicenceRootFolder() {
        String workingDirectory = RuntimeUtils.getWorkingDirectory((String)".jkiss-lm");
        File directory = Path.of(workingDirectory, new String[0]).toFile();
        if (!directory.exists() && !directory.mkdirs()) {
            File legacyDir = new File(System.getProperty("user.home"), ".jkiss-lm");
            log.warn((Object)("Can't create License folder in " + directory.getAbsolutePath() + "\n Using backup destination: " + legacyDir.getAbsolutePath()));
            if (!legacyDir.exists() && !legacyDir.mkdirs()) {
                log.error((Object)"Can't create LM config directory");
            }
            return legacyDir;
        }
        return directory;
    }
}

