/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.sql.vqb.builder;

import com.dbeaver.model.sql.vqb.builder.VQBQueryInfo;
import com.dbeaver.model.sql.vqb.model.ERDJoin;
import com.dbeaver.model.sql.vqb.model.VQBUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.WithItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDContainer;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.model.ERDUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSearchUtils;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class VQBQueryParser {
    private static final Log log = Log.getLog(VQBQueryParser.class);
    private final VQBQueryInfo queryInfo;
    private final DBPDataSource dataSource;
    private SQLIdentifierDetector identifierDetector;
    private SQLSyntaxManager syntaxManager;
    private DBCExecutionContext executionContext;

    public VQBQueryParser(VQBQueryInfo queryInfo) {
        this.queryInfo = queryInfo;
        this.dataSource = queryInfo.getQuery().getDataSource();
        this.executionContext = queryInfo.getExecutionContext();
        SQLDialect dialect = SQLUtils.getDialectFromDataSource((DBPDataSource)this.dataSource);
        this.identifierDetector = new SQLIdentifierDetector(dialect);
    }

    public VQBQueryParser(VQBQueryInfo queryInfo, SQLSyntaxManager syntaxManager) {
        this(queryInfo);
        this.syntaxManager = syntaxManager;
    }

    public void loadDiagramFromQuery(DBRProgressMonitor monitor, ERDDiagram diagram, DBPPreferenceStore prefStore) throws DBException {
        if (this.queryInfo.getParsedQuery() != null) {
            this.fillDiagramFromSelect(monitor, diagram, prefStore);
        }
    }

    public void updateDiagramFromQuery(DBRProgressMonitor monitor, ERDDiagram diagram) {
        if (this.queryInfo.getParsedQuery() != null) {
            SelectBody selectBody = this.queryInfo.getParsedQuery().getSelectBody();
            boolean cfr_ignored_0 = selectBody instanceof WithItem;
            if (!(selectBody instanceof PlainSelect)) {
                log.debug((Object)("Query is not a plain select: " + String.valueOf(selectBody)));
                return;
            }
            ArrayList<ERDEntity> allEntities = new ArrayList<ERDEntity>(diagram.getEntities());
            ERDEntity mainEntity = null;
            for (ERDEntity entity : allEntities) {
                if (entity.isPrimary()) {
                    mainEntity = entity;
                }
                for (ERDEntityAttribute attr : entity.getAttributes()) {
                    attr.setChecked(false);
                }
            }
            this.updateAttributesState((PlainSelect)selectBody, mainEntity, allEntities);
        }
    }

    private void fillDiagramFromSelect(DBRProgressMonitor monitor, ERDDiagram diagram, DBPPreferenceStore prefStore) throws DBException {
        List joins;
        SelectBody selectBody = this.queryInfo.getParsedQuery().getSelectBody();
        boolean cfr_ignored_0 = selectBody instanceof WithItem;
        if (!(selectBody instanceof PlainSelect)) {
            throw new DBException("Query is not a plain select: " + String.valueOf(selectBody));
        }
        PlainSelect plainSelect = (PlainSelect)selectBody;
        FromItem fromItem = plainSelect.getFromItem();
        ERDEntity mainEntity = this.addQuerySourceItem(monitor, diagram, fromItem);
        ArrayList<ERDEntity> allEntities = new ArrayList<ERDEntity>();
        if (mainEntity != null) {
            mainEntity.setPrimary(true);
            allEntities.add(mainEntity);
        }
        if (!CommonUtils.isEmpty((Collection)(joins = plainSelect.getJoins()))) {
            ERDEntity joinedEntity;
            HashMap<Join, ERDEntity> joinEntitiesMap = new HashMap<Join, ERDEntity>();
            for (Join join : joins) {
                joinedEntity = this.addQuerySourceItem(monitor, diagram, join.getRightItem());
                if (joinedEntity == null) {
                    throw new DBException("Can't find joined table " + String.valueOf(join.getRightItem()));
                }
                allEntities.add(joinedEntity);
                joinEntitiesMap.put(join, joinedEntity);
            }
            for (Join join : joins) {
                joinedEntity = (ERDEntity)joinEntitiesMap.get(join);
                if (joinedEntity == null) continue;
                Expression joinExpression = VQBUtils.getJoinOnExpression(join);
                ERDJoin erdJoin = null;
                if (joinExpression != null) {
                    erdJoin = this.addJoinOnExpression(allEntities, joinedEntity, joinExpression);
                } else if (join.isSimple() && plainSelect.getWhere() != null) {
                    erdJoin = this.addJoinOnCondition(null, allEntities, joinedEntity, mainEntity, plainSelect.getWhere());
                }
                if (erdJoin == null) {
                    if (mainEntity != null) {
                        erdJoin = new ERDJoin(joinedEntity, mainEntity, false);
                    } else {
                        log.debug((Object)("No main entity: skip join with " + joinedEntity.getName()));
                    }
                }
                if (erdJoin == null) continue;
                erdJoin.setUserData(join);
            }
        }
        if (allEntities.size() == 1 && mainEntity != null && fromItem instanceof Table) {
            String entityAlias;
            Table mainTable = (Table)fromItem;
            if (prefStore.getBoolean("vqb.add.aliases.always") && mainTable.getAlias() == null && (entityAlias = VQBUtils.generateEntityAlias(diagram, allEntities, (DBSEntity)mainEntity.getObject(), this.syntaxManager)) != null) {
                mainEntity.setAlias(entityAlias);
                mainTable.setAlias(new Alias(entityAlias, false));
                VQBUtils.updateTableAlias(this.queryInfo, mainTable, mainTable.getAlias());
            }
        }
        this.updateAttributesState(plainSelect, mainEntity, allEntities);
        for (ERDEntity entity : allEntities) {
            entity.addModelRelations(monitor, (ERDContainer)diagram, false, false);
        }
    }

    private void updateAttributesState(PlainSelect plainSelect, ERDEntity mainEntity, List<ERDEntity> allEntities) {
        List selectItems = plainSelect.getSelectItems();
        if (selectItems != null) {
            int i = 0;
            while (i < selectItems.size()) {
                SelectItem item = (SelectItem)selectItems.get(i);
                if (item instanceof SelectExpressionItem) {
                    Expression itemExpression = ((SelectExpressionItem)item).getExpression();
                    if (itemExpression instanceof Column) {
                        Column column = (Column)itemExpression;
                        Pair<ERDEntity, ERDEntityAttribute> src = this.resolveEntityAttribute(column, mainEntity, allEntities);
                        if (src != null && src.getSecond() != null) {
                            ERDEntityAttribute erdAttr = (ERDEntityAttribute)src.getSecond();
                            erdAttr.setChecked(true);
                            erdAttr.setUserData((Object)item);
                            Alias itemAlias = ((SelectExpressionItem)item).getAlias();
                            if (itemAlias != null && !CommonUtils.isEmpty((String)itemAlias.getName())) {
                                erdAttr.setAlias(itemAlias.getName());
                            }
                        } else {
                            log.debug((Object)("Can't resolve source attribute for column : " + String.valueOf(itemExpression)));
                        }
                    }
                } else if (item instanceof AllTableColumns) {
                    Table table = ((AllTableColumns)item).getTable();
                    ERDEntity attrEntity = this.findEntityByTable(allEntities, mainEntity, table);
                    if (attrEntity != null) {
                        for (ERDEntityAttribute attr : attrEntity.getAttributes()) {
                            attr.setChecked(true);
                            attr.setUserData((Object)item);
                        }
                    } else {
                        log.debug((Object)("Can't detect selected table " + String.valueOf(item)));
                    }
                }
                ++i;
            }
        }
    }

    @Nullable
    private Pair<ERDEntity, ERDEntityAttribute> resolveEntityAttribute(@NotNull Column column, @Nullable ERDEntity mainEntity, @NotNull List<ERDEntity> allEntities) {
        String columnName = this.dataSource != null ? DBUtils.getUnQuotedIdentifier((DBPDataSource)this.dataSource, (String)column.getColumnName()) : DBUtils.getUnQuotedIdentifier((String)column.getColumnName(), (String)"\"", (String)"\"");
        Table columnTable = column.getTable();
        Pair result = null;
        if (columnTable != null) {
            ERDEntity attrEntity = this.findEntityByTable(allEntities, mainEntity, columnTable);
            if (attrEntity == null) {
                if (mainEntity != null && allEntities.size() == 1) {
                    attrEntity = mainEntity;
                } else {
                    log.debug((Object)("Can't resolve table reference " + String.valueOf(columnTable)));
                }
            }
            if (attrEntity != null) {
                ERDEntityAttribute erdAttr = (ERDEntityAttribute)DBUtils.findObject((Collection)attrEntity.getAttributes(), (String)columnName, (boolean)true);
                if (erdAttr == null) {
                    log.debug((Object)("Can't resolve table attribute " + columnName));
                }
                result = new Pair((Object)attrEntity, (Object)erdAttr);
            }
        } else {
            for (ERDEntity entity : allEntities) {
                ERDEntityAttribute attr = (ERDEntityAttribute)DBUtils.findObject((Collection)entity.getAttributes(), (String)columnName, (boolean)true);
                if (attr == null) continue;
                if (result == null) {
                    result = new Pair((Object)entity, (Object)attr);
                    continue;
                }
                log.debug((Object)("Can't resolve table by attribute " + columnName));
            }
        }
        return result;
    }

    private ERDJoin addJoinOnCondition(ERDJoin join, List<ERDEntity> allEntities, ERDEntity joinedEntity, ERDEntity mainEntity, Expression expr) {
        Expression leftExpression = this.extractLeftExpression(expr);
        Expression rightExpression = this.extractRightExpression(expr);
        if (expr instanceof AndExpression || expr instanceof OrExpression) {
            join = this.addJoinOnCondition(join, allEntities, joinedEntity, mainEntity, leftExpression);
            join = this.addJoinOnCondition(join, allEntities, joinedEntity, mainEntity, rightExpression);
        } else if (expr instanceof EqualsTo && leftExpression instanceof Column && rightExpression instanceof Column) {
            Pair<ERDEntity, ERDEntityAttribute> leftSrc = this.resolveEntityAttribute((Column)leftExpression, mainEntity, allEntities);
            Pair<ERDEntity, ERDEntityAttribute> rightSrc = this.resolveEntityAttribute((Column)rightExpression, mainEntity, allEntities);
            if (leftSrc != null && rightSrc != null && leftSrc.getFirst() != null && rightSrc.getFirst() != null && (leftSrc.getFirst() == joinedEntity || rightSrc.getFirst() == joinedEntity)) {
                String leftColumnName = ((Column)leftExpression).getColumnName();
                String rightColumnName = ((Column)rightExpression).getColumnName();
                if (!CommonUtils.isEmpty((String)leftColumnName) && !CommonUtils.isEmpty((String)rightColumnName) && leftSrc.getSecond() != null && rightSrc.getSecond() != null) {
                    this.queryInfo.excludeWhereCondition(expr);
                    if (rightSrc.getFirst() == joinedEntity && leftSrc.getFirst() == mainEntity) {
                        Pair<ERDEntity, ERDEntityAttribute> tmp = leftSrc;
                        leftSrc = rightSrc;
                        rightSrc = tmp;
                    }
                    if (join == null) {
                        join = new ERDJoin((ERDEntity)leftSrc.getFirst(), (ERDEntity)rightSrc.getFirst(), false);
                    }
                    join.addCondition((ERDEntityAttribute)leftSrc.getSecond(), (ERDEntityAttribute)rightSrc.getSecond());
                }
            }
        }
        return join;
    }

    private Expression extractLeftExpression(Expression expr) {
        while (expr instanceof Parenthesis) {
            expr = ((Parenthesis)expr).getExpression();
        }
        return expr instanceof BinaryExpression ? ((BinaryExpression)expr).getLeftExpression() : null;
    }

    private Expression extractRightExpression(Expression expr) {
        while (expr instanceof Parenthesis) {
            expr = ((Parenthesis)expr).getExpression();
        }
        return expr instanceof BinaryExpression ? ((BinaryExpression)expr).getRightExpression() : null;
    }

    private ERDJoin addJoinOnExpression(List<ERDEntity> allEntities, ERDEntity joinedEntity, Expression joinExpression) {
        if (joinExpression instanceof BinaryExpression) {
            return this.makeJoinFromCondition(null, allEntities, joinedEntity, (BinaryExpression)joinExpression);
        }
        return null;
    }

    private ERDJoin makeJoinFromCondition(ERDJoin join, List<ERDEntity> allEntities, ERDEntity joinedEntity, BinaryExpression joinExpression) {
        Expression leftExpression = joinExpression.getLeftExpression();
        Expression rightExpression = joinExpression.getRightExpression();
        if (joinExpression instanceof AndExpression) {
            if (joinExpression.getLeftExpression() instanceof BinaryExpression) {
                join = this.makeJoinFromCondition(join, allEntities, joinedEntity, (BinaryExpression)joinExpression.getLeftExpression());
            }
            if (joinExpression.getRightExpression() instanceof BinaryExpression) {
                join = this.makeJoinFromCondition(join, allEntities, joinedEntity, (BinaryExpression)joinExpression.getRightExpression());
            }
        } else if (joinExpression instanceof EqualsTo && leftExpression instanceof Column && rightExpression instanceof Column) {
            Pair<ERDEntity, ERDEntityAttribute> leftSrc = this.resolveEntityAttribute((Column)leftExpression, joinedEntity, allEntities);
            Pair<ERDEntity, ERDEntityAttribute> rightSrc = this.resolveEntityAttribute((Column)rightExpression, joinedEntity, allEntities);
            if (leftSrc != null && rightSrc != null) {
                if (joinedEntity == rightSrc.getFirst()) {
                    Pair<ERDEntity, ERDEntityAttribute> tmp = leftSrc;
                    leftSrc = rightSrc;
                    rightSrc = tmp;
                    Expression tmpExp = leftExpression;
                    leftExpression = rightExpression;
                    rightExpression = tmpExp;
                }
                if (join == null) {
                    join = new ERDJoin((ERDEntity)leftSrc.getFirst(), (ERDEntity)rightSrc.getFirst(), false);
                }
                String leftColumnName = ((Column)leftExpression).getColumnName();
                String rightColumnName = ((Column)rightExpression).getColumnName();
                if (!CommonUtils.isEmpty((String)leftColumnName) && !CommonUtils.isEmpty((String)rightColumnName) && leftSrc.getSecond() != null && rightSrc.getSecond() != null) {
                    join.addCondition((ERDEntityAttribute)leftSrc.getSecond(), (ERDEntityAttribute)rightSrc.getSecond());
                }
            }
        } else {
            log.debug((Object)("Can't use expression [" + String.valueOf(joinExpression) + "] in ERD join. Skip."));
        }
        return join;
    }

    private ERDEntity findEntityByTable(List<ERDEntity> allEntities, ERDEntity joinedEntity, Table table) {
        if (table == null) {
            return null;
        }
        String alias = table.getAlias() != null ? table.getAlias().getName() : null;
        boolean caseSensitive = this.identifierDetector.isQuoted(table.getName());
        String tableName = this.dataSource != null ? DBUtils.getUnQuotedIdentifier((DBPDataSource)this.dataSource, (String)table.getName()) : DBUtils.getUnQuotedIdentifier((String)table.getName(), (String)"\"", (String)"\"");
        String tableSchemaName = table.getSchemaName();
        if (tableSchemaName != null) {
            tableSchemaName = this.dataSource != null ? DBUtils.getUnQuotedIdentifier((DBPDataSource)this.dataSource, (String)tableSchemaName) : DBUtils.getUnQuotedIdentifier((String)tableSchemaName, (String)"\"", (String)"\"");
        }
        if (CommonUtils.isEmpty((String)alias) && CommonUtils.isEmpty((String)tableName)) {
            return joinedEntity;
        }
        if (!CommonUtils.isEmpty((String)alias)) {
            for (ERDEntity erdEntity : allEntities) {
                if (!alias.equals(erdEntity.getAlias())) continue;
                return erdEntity;
            }
        }
        for (ERDEntity erdEntity : allEntities) {
            DBSSchema schema;
            DBSCatalog catalog;
            if (tableName.equals(erdEntity.getAlias())) {
                return erdEntity;
            }
            DBSEntity entity = (DBSEntity)erdEntity.getObject();
            if (table.getDatabase() != null && !CommonUtils.isEmpty((String)table.getDatabase().getDatabaseName()) && ((catalog = (DBSCatalog)DBUtils.getParentOfType(DBSCatalog.class, (DBSObject)entity)) == null || !catalog.getName().equals(table.getDatabase().getDatabaseName())) || !CommonUtils.isEmpty((String)tableSchemaName) && ((schema = (DBSSchema)DBUtils.getParentOfType(DBSSchema.class, (DBSObject)entity)) == null || !schema.getName().equals(tableSchemaName))) continue;
            if (entity.getName().equals(tableName)) {
                return erdEntity;
            }
            if (caseSensitive || !entity.getName().equalsIgnoreCase(tableName)) continue;
            return erdEntity;
        }
        return null;
    }

    private ERDEntity addQuerySourceItem(DBRProgressMonitor monitor, ERDDiagram diagram, FromItem fromItem) throws DBException {
        if (fromItem instanceof Table) {
            DBSObject object;
            Table table = (Table)fromItem;
            DBPDataSource dataSource = this.queryInfo.getQuery().getDataSource();
            if (dataSource == null) {
                log.error((Object)"Can't create query builder without live connection");
                return null;
            }
            DBSObjectContainer container = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)dataSource);
            if (container == null) {
                log.error((Object)("Data source " + dataSource.getName() + " is not an object container"));
                return null;
            }
            ArrayList<String> nameList = new ArrayList<String>();
            if (table.getDatabase() != null && !CommonUtils.isEmpty((String)table.getDatabase().getDatabaseName())) {
                nameList.add(table.getDatabase().getDatabaseName());
            }
            if (!CommonUtils.isEmpty((String)table.getSchemaName())) {
                nameList.add(table.getSchemaName());
            }
            nameList.add(table.getName());
            DBSObject[] selectedObjects = DBUtils.getSelectedObjects((DBCExecutionContext)this.executionContext);
            ArrayList<DBSObjectContainer> selectedContainers = new ArrayList<DBSObjectContainer>();
            selectedContainers.add(container);
            DBSObject[] dBSObjectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                DBSObject selectedObject = dBSObjectArray[n2];
                selectedContainers.add((DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)selectedObject));
                ++n2;
            }
            if (nameList.size() == 1) {
                Collections.reverse(selectedContainers);
            }
            if ((object = this.findObjectForEntity(monitor, nameList, selectedContainers)) instanceof DBSEntity) {
                ERDEntity entity = ERDUtils.makeEntityFromObject((DBRProgressMonitor)monitor, (ERDDiagram)diagram, Collections.emptyList(), (DBSEntity)((DBSEntity)object), (Object)fromItem);
                if (entity == null) {
                    log.error((Object)"Can't create diagram entity from the object.");
                    return null;
                }
                if (fromItem.getAlias() != null) {
                    entity.setAlias(fromItem.getAlias().getName());
                }
                diagram.addEntity(entity, false);
                return entity;
            }
            throw new DBException("Can't find table '" + String.valueOf(table) + "' in the database");
        }
        return null;
    }

    @Nullable
    private DBSObject findObjectForEntity(@NotNull DBRProgressMonitor monitor, @NotNull List<String> nameList, @NotNull List<DBSObjectContainer> selectedContainers) {
        for (DBSObjectContainer oc : selectedContainers) {
            DBSObject object;
            if (oc == null || (object = SQLSearchUtils.findObjectByFQN((DBRProgressMonitor)monitor, (DBSObjectContainer)oc, (DBCExecutionContext)this.queryInfo.getExecutionContext(), nameList, (boolean)false, (SQLIdentifierDetector)this.identifierDetector)) == null) continue;
            return object;
        }
        return null;
    }
}

