/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.Locale;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageTransactions
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.transactions";
    private Button smartCommitCheck;
    private Button smartCommitRecoverCheck;
    private Button autoCloseTransactionsCheck;
    private Text autoCloseTransactionsTtlText;
    private Button showTransactionNotificationsCheck;

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("transaction.smart.commit") || store.contains("transaction.smart.commit.recover") || store.contains("transaction.auto.close.enabled") || store.contains("transaction.auto.close.ttl") || store.contains("transaction.show.notifications");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        String settingsTipString;
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        boolean dataSourcePreferencePage = this.isDataSourcePreferencePage();
        Group txnNameGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.dialog_connection_edit_wizard_transactions, (int)2, (int)768, (int)0);
        if (dataSourcePreferencePage) {
            this.smartCommitCheck = UIUtils.createCheckbox((Composite)txnNameGroup, (String)CoreMessages.action_menu_transaction_smart_auto_commit, (String)CoreMessages.action_menu_transaction_smart_auto_commit_tip, (boolean)false, (int)2);
            this.smartCommitCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PrefPageTransactions.this.updateButtons();
                }
            });
            this.smartCommitRecoverCheck = UIUtils.createCheckbox((Composite)txnNameGroup, (String)CoreMessages.action_menu_transaction_smart_auto_commit_recover, (String)CoreMessages.action_menu_transaction_smart_auto_commit_recover_tip, (boolean)false, (int)2);
            this.autoCloseTransactionsCheck = UIUtils.createCheckbox((Composite)txnNameGroup, (String)CoreMessages.action_menu_transaction_auto_close_enabled, (String)CoreMessages.action_menu_transaction_auto_close_enabled_tip, (boolean)true, (int)1);
            this.autoCloseTransactionsTtlText = new Text((Composite)txnNameGroup, 2048);
            this.autoCloseTransactionsTtlText.setToolTipText(CoreMessages.action_menu_transaction_auto_close_ttl_tip);
            this.autoCloseTransactionsTtlText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.ENGLISH));
            GridData gd = new GridData();
            gd.widthHint = UIUtils.getFontHeight((Control)this.autoCloseTransactionsTtlText) * 6;
            this.autoCloseTransactionsTtlText.setLayoutData((Object)gd);
            settingsTipString = CoreMessages.action_menu_transaction_pref_page_link_extended;
        } else {
            settingsTipString = CoreMessages.action_menu_transaction_pref_page_link;
        }
        UIUtils.createPreferenceLink((Composite)txnNameGroup, (String)settingsTipString, (String)"org.jkiss.dbeaver.preferences.connectionTypes", (IWorkbenchPreferenceContainer)((IWorkbenchPreferenceContainer)this.getContainer()), null);
        Group notifyNameGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_transactions_notify_name_group_label, (int)2, (int)768, (int)0);
        this.showTransactionNotificationsCheck = UIUtils.createCheckbox((Composite)notifyNameGroup, (String)CoreMessages.pref_page_transactions_notifications_show_check_label, (String)CoreMessages.pref_page_transactions_notifications_show_check_description, (boolean)false, (int)2);
        return composite;
    }

    private void updateButtons() {
        if (!this.smartCommitCheck.getSelection()) {
            this.smartCommitRecoverCheck.setEnabled(false);
            this.smartCommitRecoverCheck.setSelection(false);
        } else if (!this.smartCommitRecoverCheck.isEnabled()) {
            this.smartCommitRecoverCheck.setEnabled(true);
        }
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
            DBPConnectionType connectionType = null;
            if (dataSourceContainer != null) {
                connectionType = dataSourceContainer.getConnectionConfiguration().getConnectionType();
            }
            if (this.smartCommitCheck != null) {
                this.smartCommitCheck.setSelection(store.contains("transaction.smart.commit") || connectionType == null ? store.getBoolean("transaction.smart.commit") : connectionType.isSmartCommit());
            }
            if (this.smartCommitRecoverCheck != null) {
                this.smartCommitRecoverCheck.setSelection(store.contains("transaction.smart.commit.recover") || connectionType == null ? store.getBoolean("transaction.smart.commit.recover") : connectionType.isSmartCommitRecover());
                if (this.smartCommitCheck != null) {
                    this.updateButtons();
                }
            }
            if (this.autoCloseTransactionsCheck != null) {
                this.autoCloseTransactionsCheck.setSelection(store.contains("transaction.auto.close.enabled") || connectionType == null ? store.getBoolean("transaction.auto.close.enabled") : connectionType.isAutoCloseTransactions());
                this.autoCloseTransactionsTtlText.setText(store.contains("transaction.auto.close.ttl") || connectionType == null ? store.getString("transaction.auto.close.ttl") : String.valueOf(connectionType.getCloseIdleConnectionPeriod()));
            }
            this.showTransactionNotificationsCheck.setSelection(store.getBoolean("transaction.show.notifications"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(DBPPreferenceStore store) {
        try {
            if (this.smartCommitCheck != null) {
                store.setValue("transaction.smart.commit", this.smartCommitCheck.getSelection());
            }
            if (this.smartCommitRecoverCheck != null) {
                store.setValue("transaction.smart.commit.recover", this.smartCommitRecoverCheck.getSelection());
            }
            if (this.autoCloseTransactionsCheck != null) {
                store.setValue("transaction.auto.close.enabled", this.autoCloseTransactionsCheck.getSelection());
                store.setValue("transaction.auto.close.ttl", this.autoCloseTransactionsTtlText.getText());
            }
            store.setValue("transaction.show.notifications", this.showTransactionNotificationsCheck.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("transaction.smart.commit");
        store.setToDefault("transaction.smart.commit.recover");
        store.setToDefault("transaction.auto.close.enabled");
        store.setToDefault("transaction.auto.close.ttl");
        store.setToDefault("transaction.show.notifications");
    }

    protected void performDefaults() {
        this.showTransactionNotificationsCheck.setSelection(DBWorkbench.getPlatform().getPreferenceStore().getDefaultBoolean("transaction.show.notifications"));
        super.performDefaults();
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

