/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBServiceConnections;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceHandler;
import org.jkiss.dbeaver.ui.dialogs.connection.EditConnectionDialog;

public class UIServiceConnectionsImpl
implements DBServiceConnections,
UIServiceConnections {
    private static final Log log = Log.getLog(UIServiceConnectionsImpl.class);

    public void openConnectionEditor(@NotNull DBPDataSourceContainer dataSourceContainer, String defaultPageName) {
        if (dataSourceContainer.getProject().hasRealmPermission("project-datasource-edit")) {
            if (dataSourceContainer.getProject().isUseSecretStorage()) {
                try {
                    DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)dataSourceContainer.getProject());
                    dataSourceContainer.resolveSecrets(secretController);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Secret resolve", "Error loading connection secrets", (Throwable)e);
                }
            }
            EditConnectionDialog.openEditConnectionDialog(UIUtils.getActiveWorkbenchWindow(), dataSourceContainer, defaultPageName);
        } else {
            DBWorkbench.getPlatformUI().openEntityEditor((DBSObject)dataSourceContainer);
        }
    }

    public void connectDataSource(@NotNull DBPDataSourceContainer dataSourceContainer, DBRProgressListener onFinish) {
        DataSourceHandler.connectToDataSource(null, (DBPDataSourceContainer)dataSourceContainer, (DBRProgressListener)onFinish);
    }

    public void disconnectDataSource(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DataSourceHandler.disconnectDataSource((DBPDataSourceContainer)dataSourceContainer, null);
    }

    public void closeActiveTransaction(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, boolean commitTxn) {
        DataSourceHandler.closeActiveTransaction((DBRProgressMonitor)monitor, (DBCExecutionContext)context, (boolean)commitTxn);
    }

    public boolean confirmTransactionsClose(@NotNull DBCExecutionContext[] contexts) {
        return DataSourceHandler.confirmTransactionsClose((DBCExecutionContext[])contexts);
    }

    public boolean checkAndCloseActiveTransaction(@NotNull DBCExecutionContext[] contexts) {
        return DataSourceHandler.checkAndCloseActiveTransaction((DBCExecutionContext[])contexts, (boolean)false);
    }

    public void initConnection(DBRProgressMonitor monitor, DBPDataSourceContainer dataSourceContainer, DBRProgressListener onFinish) {
        DataSourceHandler.connectToDataSource((DBRProgressMonitor)monitor, (DBPDataSourceContainer)dataSourceContainer, (DBRProgressListener)onFinish);
    }
}

