/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.data.preferences;

import java.util.Locale;
import org.eclipse.core.commands.Command;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.commands.ICommandService;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.editors.data.internal.DataEditorsMessages;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageResultSetMain
extends TargetPrefPage {
    static final Log log = Log.getLog(PrefPageResultSetMain.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.resultset";
    private Button autoFetchNextSegmentCheck;
    private Button automaticRowCountCheck;
    private Button rereadOnScrollingCheck;
    private Text resultSetSize;
    private Button resultSetUseSQLCheck;
    private Combo orderingModeCombo;
    private Button readQueryMetadata;
    private Button readQueryReferences;
    private Text queryCancelTimeout;
    private Button filterForceSubselect;
    private Button keepStatementOpenCheck;
    private Button alwaysUseAllColumns;
    private Button disableEditingOnMissingKey;
    private Button newRowsAfter;
    private Button refreshAfterUpdate;
    private Button useNavigatorFilters;
    private Button confirmDataSave;
    private Button showErrorsInDialog;
    private Button markCellValueOccurrences;
    private Button advUseFetchSize;
    private Button ignoreColumnLabelCheck;
    private Button useDateTimeEditor;
    private Button useBrowserCheckbox;

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("resultset.autofetch.next.segment") || store.contains("resultset.reread.on.scroll") || store.contains("resultset.maxrows") || store.contains("resultset.maxrows.sql") || store.contains("resultset.automatic.row.count") || store.contains("resultset.read.metadata") || store.contains("resultset.cancel.timeout") || store.contains("sql.query.filter.force.subselect") || store.contains("resultset.edit.key.use_all_columns") || store.contains("resultset.edit.disableIfKeyMissing") || store.contains("resultset.edit.new.row.after") || store.contains("resultset.edit.refreshAfterUpdate") || store.contains("keep.statement.open") || store.contains("resultset.order.mode") || store.contains("resultset.fetch.size") || store.contains("resultset.filter.use.navigator") || store.contains("resultset.confirm.beforeSave") || store.contains("resultset.show.errorDialog") || store.contains("resultset.mark.cell.value.occurrences") || store.contains("resultset.column.label.ignore") || store.contains("resultset.image.browser");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Command toggleComand;
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        Composite leftPane = UIUtils.createComposite((Composite)composite, (int)1);
        leftPane.setLayoutData((Object)new GridData(2));
        Composite rightPane = UIUtils.createComposite((Composite)composite, (int)1);
        rightPane.setLayoutData((Object)new GridData(2));
        Group queriesGroup = UIUtils.createControlGroup((Composite)leftPane, (String)ResultSetMessages.pref_page_database_general_group_queries, (int)2, (int)0, (int)0);
        queriesGroup.setLayoutData((Object)new GridData(2));
        this.resultSetSize = UIUtils.createLabelText((Composite)queriesGroup, (String)ResultSetMessages.pref_page_database_general_label_result_set_max_size, (String)"0", (int)2048);
        this.resultSetSize.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.resultSetSize.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                int newValue = CommonUtils.toInt((Object)PrefPageResultSetMain.this.resultSetSize.getText());
                if (newValue > 0 && newValue < 1) {
                    PrefPageResultSetMain.this.resultSetSize.setText(String.valueOf(1));
                }
            }
        });
        this.autoFetchNextSegmentCheck = UIUtils.createCheckbox((Composite)queriesGroup, (String)ResultSetMessages.pref_page_database_resultsets_label_auto_fetch_segment, (String)ResultSetMessages.pref_page_database_resultsets_label_auto_fetch_segment_tip, (boolean)true, (int)2);
        this.rereadOnScrollingCheck = UIUtils.createCheckbox((Composite)queriesGroup, (String)ResultSetMessages.pref_page_database_resultsets_label_reread_on_scrolling, (String)ResultSetMessages.pref_page_database_resultsets_label_reread_on_scrolling_tip, (boolean)true, (int)2);
        this.resultSetUseSQLCheck = UIUtils.createCheckbox((Composite)queriesGroup, (String)ResultSetMessages.pref_page_database_resultsets_label_use_sql, (String)ResultSetMessages.pref_page_database_resultsets_label_use_sql_tip, (boolean)false, (int)2);
        this.automaticRowCountCheck = UIUtils.createCheckbox((Composite)queriesGroup, (String)ResultSetMessages.pref_page_database_resultsets_label_automatic_row_count, (String)ResultSetMessages.pref_page_database_resultsets_label_automatic_row_count_tip, (boolean)false, (int)2);
        this.orderingModeCombo = UIUtils.createLabelCombo((Composite)queriesGroup, (String)ResultSetMessages.pref_page_database_resultsets_label_order_mode, (String)ResultSetMessages.pref_page_database_resultsets_label_order_mode_tip, (int)12);
        ResultSetUtils.OrderingMode[] orderingModeArray = ResultSetUtils.OrderingMode.values();
        int n = orderingModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResultSetUtils.OrderingMode mode = orderingModeArray[n2];
            this.orderingModeCombo.add(mode.getText());
            ++n2;
        }
        this.readQueryMetadata = UIUtils.createCheckbox((Composite)queriesGroup, (String)ResultSetMessages.pref_page_database_resultsets_label_read_metadata, (String)ResultSetMessages.pref_page_database_resultsets_label_read_metadata_tip, (boolean)false, (int)2);
        this.readQueryReferences = UIUtils.createCheckbox((Composite)queriesGroup, (String)ResultSetMessages.pref_page_database_resultsets_label_read_references, (String)ResultSetMessages.pref_page_database_resultsets_label_read_references_tip, (boolean)false, (int)2);
        this.queryCancelTimeout = UIUtils.createLabelText((Composite)queriesGroup, (String)(ResultSetMessages.pref_page_database_general_label_result_set_cancel_timeout + UIMessages.label_ms), (String)"0");
        this.queryCancelTimeout.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.queryCancelTimeout.setToolTipText(ResultSetMessages.pref_page_database_general_label_result_set_cancel_timeout_tip);
        this.queryCancelTimeout.setEnabled(false);
        this.filterForceSubselect = UIUtils.createCheckbox((Composite)queriesGroup, (String)ResultSetMessages.pref_page_database_resultsets_label_filter_force_subselect, (String)ResultSetMessages.pref_page_database_resultsets_label_filter_force_subselect_tip, (boolean)false, (int)2);
        this.readQueryMetadata.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageResultSetMain.this.updateOptionsEnablement();
            }
        });
        Group advGroup = UIUtils.createControlGroup((Composite)leftPane, (String)ResultSetMessages.pref_page_results_group_advanced, (int)1, (int)2, (int)0);
        this.ignoreColumnLabelCheck = UIUtils.createCheckbox((Composite)advGroup, (String)ResultSetMessages.pref_page_database_general_use_column_names, (String)ResultSetMessages.pref_page_database_general_use_column_names_tip, (boolean)false, (int)1);
        this.advUseFetchSize = UIUtils.createCheckbox((Composite)advGroup, (String)ResultSetMessages.pref_page_database_resultsets_label_fetch_size, (String)ResultSetMessages.pref_page_database_resultsets_label_fetch_size_tip, (boolean)false, (int)1);
        Group miscGroup = UIUtils.createControlGroup((Composite)rightPane, (String)ResultSetMessages.pref_page_sql_editor_group_misc, (int)1, (int)2, (int)0);
        miscGroup.setLayoutData((Object)new GridData(2));
        this.keepStatementOpenCheck = UIUtils.createCheckbox((Composite)miscGroup, (String)ResultSetMessages.pref_page_database_general_checkbox_keep_cursor, (boolean)false);
        this.newRowsAfter = UIUtils.createCheckbox((Composite)miscGroup, (String)ResultSetMessages.pref_page_content_editor_checkbox_new_rows_after, (boolean)false);
        this.refreshAfterUpdate = UIUtils.createCheckbox((Composite)miscGroup, (String)ResultSetMessages.pref_page_content_editor_checkbox_refresh_after_update, (boolean)false);
        this.useNavigatorFilters = UIUtils.createCheckbox((Composite)miscGroup, (String)ResultSetMessages.pref_page_content_editor_checkbox_use_navigator_filters, (String)ResultSetMessages.pref_page_content_editor_checkbox_use_navigator_filters_tip, (boolean)false, (int)1);
        this.useDateTimeEditor = UIUtils.createCheckbox((Composite)miscGroup, (String)ResultSetMessages.pref_page_content_editor_checkbox_string_editor_for_datetime, (String)ResultSetMessages.pref_page_content_editor_checkbox_string_editor_for_datetime_tip, (boolean)false, (int)1);
        Group uiGroup = UIUtils.createControlGroup((Composite)rightPane, (String)"UI", (int)1, (int)2, (int)0);
        uiGroup.setLayoutData((Object)new GridData(2));
        ICommandService commandService = (ICommandService)UIUtils.getActiveWorkbenchWindow().getService(ICommandService.class);
        if (commandService != null && (toggleComand = commandService.getCommand("org.jkiss.dbeaver.core.resultset.toggleConfirmSave")) != null) {
            try {
                this.confirmDataSave = UIUtils.createCheckbox((Composite)uiGroup, (String)toggleComand.getName(), (String)toggleComand.getDescription(), (boolean)false, (int)1);
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        this.showErrorsInDialog = UIUtils.createCheckbox((Composite)uiGroup, (String)ResultSetMessages.pref_page_content_editor_ui_show_errors_in_dialog, (String)ResultSetMessages.pref_page_content_editor_ui_show_errors_in_dialog_tip, (boolean)false, (int)1);
        this.markCellValueOccurrences = UIUtils.createCheckbox((Composite)uiGroup, (String)ResultSetMessages.pref_page_content_editor_ui_mark_cell_value_occurrences, (String)ResultSetMessages.pref_page_content_editor_ui_mark_cell_value_occurrences_tip, (boolean)false, (int)1);
        this.useBrowserCheckbox = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_image_browser, (boolean)false);
        this.useBrowserCheckbox.setToolTipText(DataEditorsMessages.pref_page_database_resultsets_label_image_browser_tip);
        Group group = UIUtils.createControlGroup((Composite)leftPane, (String)ResultSetMessages.pref_page_content_editor_group_editing, (int)1, (int)2, (int)0);
        this.alwaysUseAllColumns = UIUtils.createCheckbox((Composite)group, (String)ResultSetMessages.pref_page_content_editor_checkbox_keys_always_use_all_columns, (boolean)false);
        this.disableEditingOnMissingKey = UIUtils.createCheckbox((Composite)group, (String)ResultSetMessages.pref_page_content_editor_checkbox_disable_editing_if_key_missing, (boolean)false);
        this.alwaysUseAllColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageResultSetMain.this.updateOptionsEnablement();
            }
        });
        return composite;
    }

    private void updateOptionsEnablement() {
        this.readQueryReferences.setEnabled(this.readQueryMetadata.isEnabled() && this.readQueryMetadata.getSelection());
        if (this.alwaysUseAllColumns.getSelection()) {
            this.disableEditingOnMissingKey.setEnabled(false);
            this.disableEditingOnMissingKey.setSelection(false);
        } else {
            this.disableEditingOnMissingKey.setEnabled(true);
        }
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.autoFetchNextSegmentCheck.setSelection(store.getBoolean("resultset.autofetch.next.segment"));
            this.rereadOnScrollingCheck.setSelection(store.getBoolean("resultset.reread.on.scroll"));
            this.useDateTimeEditor.setSelection(store.getBoolean("resultset.datetime.editor"));
            int rsSegmentSize = store.getInt("resultset.maxrows");
            if (rsSegmentSize > 0 && rsSegmentSize < 1) {
                rsSegmentSize = 1;
            }
            this.resultSetSize.setText(String.valueOf(rsSegmentSize));
            this.resultSetUseSQLCheck.setSelection(store.getBoolean("resultset.maxrows.sql"));
            this.automaticRowCountCheck.setSelection(store.getBoolean("resultset.automatic.row.count"));
            this.orderingModeCombo.select(((ResultSetUtils.OrderingMode)CommonUtils.valueOf(ResultSetUtils.OrderingMode.class, (String)store.getString("resultset.order.mode"), (Enum)ResultSetUtils.OrderingMode.SMART)).ordinal());
            this.readQueryMetadata.setSelection(store.getBoolean("resultset.read.metadata"));
            this.readQueryReferences.setSelection(store.getBoolean("resultset.read.references"));
            this.queryCancelTimeout.setText(store.getString("resultset.cancel.timeout"));
            this.filterForceSubselect.setSelection(store.getBoolean("sql.query.filter.force.subselect"));
            this.useBrowserCheckbox.setSelection(store.getBoolean("resultset.image.browser"));
            this.keepStatementOpenCheck.setSelection(store.getBoolean("keep.statement.open"));
            this.alwaysUseAllColumns.setSelection(store.getBoolean("resultset.edit.key.use_all_columns"));
            this.disableEditingOnMissingKey.setSelection(store.getBoolean("resultset.edit.disableIfKeyMissing"));
            this.newRowsAfter.setSelection(store.getBoolean("resultset.edit.new.row.after"));
            this.refreshAfterUpdate.setSelection(store.getBoolean("resultset.edit.refreshAfterUpdate"));
            this.useNavigatorFilters.setSelection(store.getBoolean("resultset.filter.use.navigator"));
            this.advUseFetchSize.setSelection(store.getBoolean("resultset.fetch.size"));
            this.ignoreColumnLabelCheck.setSelection(store.getBoolean("resultset.column.label.ignore"));
            if (this.confirmDataSave != null) {
                this.confirmDataSave.setSelection(store.getBoolean("resultset.confirm.beforeSave"));
            }
            this.showErrorsInDialog.setSelection(store.getBoolean("resultset.show.errorDialog"));
            this.markCellValueOccurrences.setSelection(store.getBoolean("resultset.mark.cell.value.occurrences"));
            this.updateOptionsEnablement();
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("resultset.datetime.editor", this.useDateTimeEditor.getSelection());
            store.setValue("resultset.autofetch.next.segment", this.autoFetchNextSegmentCheck.getSelection());
            store.setValue("resultset.reread.on.scroll", this.rereadOnScrollingCheck.getSelection());
            store.setValue("resultset.maxrows", this.resultSetSize.getText());
            store.setValue("resultset.maxrows.sql", this.resultSetUseSQLCheck.getSelection());
            store.setValue("resultset.automatic.row.count", this.automaticRowCountCheck.getSelection());
            store.setValue("resultset.order.mode", ResultSetUtils.OrderingMode.values()[this.orderingModeCombo.getSelectionIndex()].toString());
            store.setValue("resultset.read.metadata", this.readQueryMetadata.getSelection());
            store.setValue("resultset.read.references", this.readQueryReferences.getSelection());
            store.setValue("resultset.cancel.timeout", this.queryCancelTimeout.getText());
            store.setValue("sql.query.filter.force.subselect", this.filterForceSubselect.getSelection());
            store.setValue("resultset.image.browser", this.useBrowserCheckbox.getSelection());
            store.setValue("keep.statement.open", this.keepStatementOpenCheck.getSelection());
            store.setValue("resultset.edit.key.use_all_columns", this.alwaysUseAllColumns.getSelection());
            store.setValue("resultset.edit.disableIfKeyMissing", this.disableEditingOnMissingKey.getSelection());
            store.setValue("resultset.edit.new.row.after", this.newRowsAfter.getSelection());
            store.setValue("resultset.edit.refreshAfterUpdate", this.refreshAfterUpdate.getSelection());
            store.setValue("resultset.filter.use.navigator", this.useNavigatorFilters.getSelection());
            store.setValue("resultset.fetch.size", this.advUseFetchSize.getSelection());
            store.setValue("resultset.column.label.ignore", this.ignoreColumnLabelCheck.getSelection());
            if (this.confirmDataSave != null) {
                store.setValue("resultset.confirm.beforeSave", this.confirmDataSave.getSelection());
            }
            store.setValue("resultset.show.errorDialog", this.showErrorsInDialog.getSelection());
            store.setValue("resultset.mark.cell.value.occurrences", this.markCellValueOccurrences.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("resultset.image.browser");
        store.setToDefault("resultset.datetime.editor");
        store.setToDefault("resultset.autofetch.next.segment");
        store.setToDefault("resultset.reread.on.scroll");
        store.setToDefault("resultset.maxrows");
        store.setToDefault("resultset.maxrows.sql");
        store.setToDefault("resultset.automatic.row.count");
        store.setToDefault("resultset.order.mode");
        store.setToDefault("resultset.read.metadata");
        store.setToDefault("resultset.read.references");
        store.setToDefault("resultset.cancel.timeout");
        store.setToDefault("sql.query.filter.force.subselect");
        store.setToDefault("keep.statement.open");
        store.setToDefault("resultset.edit.key.use_all_columns");
        store.setToDefault("resultset.edit.disableIfKeyMissing");
        store.setToDefault("resultset.edit.new.row.after");
        store.setToDefault("resultset.edit.refreshAfterUpdate");
        store.setToDefault("resultset.filter.use.navigator");
        store.setToDefault("resultset.fetch.size");
        store.setToDefault("resultset.column.label.ignore");
        store.setToDefault("resultset.confirm.beforeSave");
        store.setToDefault("resultset.show.errorDialog");
        store.setToDefault("resultset.mark.cell.value.occurrences");
        this.updateOptionsEnablement();
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.autoFetchNextSegmentCheck.setSelection(store.getDefaultBoolean("resultset.autofetch.next.segment"));
        this.rereadOnScrollingCheck.setSelection(store.getDefaultBoolean("resultset.reread.on.scroll"));
        this.resultSetSize.setText(String.valueOf(store.getDefaultInt("resultset.maxrows")));
        this.resultSetUseSQLCheck.setSelection(store.getDefaultBoolean("resultset.maxrows.sql"));
        this.automaticRowCountCheck.setSelection(store.getDefaultBoolean("resultset.automatic.row.count"));
        this.orderingModeCombo.select(ResultSetUtils.OrderingMode.SMART.ordinal());
        this.readQueryMetadata.setSelection(store.getDefaultBoolean("resultset.read.metadata"));
        this.readQueryReferences.setSelection(store.getDefaultBoolean("resultset.read.references"));
        this.queryCancelTimeout.setText(String.valueOf(store.getDefaultInt("resultset.cancel.timeout")));
        this.filterForceSubselect.setSelection(store.getDefaultBoolean("sql.query.filter.force.subselect"));
        this.keepStatementOpenCheck.setSelection(store.getDefaultBoolean("keep.statement.open"));
        this.alwaysUseAllColumns.setSelection(store.getDefaultBoolean("resultset.edit.key.use_all_columns"));
        this.disableEditingOnMissingKey.setSelection(store.getDefaultBoolean("resultset.edit.disableIfKeyMissing"));
        this.newRowsAfter.setSelection(store.getDefaultBoolean("resultset.edit.new.row.after"));
        this.refreshAfterUpdate.setSelection(store.getDefaultBoolean("resultset.edit.refreshAfterUpdate"));
        this.useNavigatorFilters.setSelection(store.getDefaultBoolean("resultset.filter.use.navigator"));
        if (this.confirmDataSave != null) {
            this.confirmDataSave.setSelection(store.getDefaultBoolean("resultset.confirm.beforeSave"));
        }
        this.showErrorsInDialog.setSelection(store.getDefaultBoolean("resultset.show.errorDialog"));
        this.markCellValueOccurrences.setSelection(store.getDefaultBoolean("resultset.mark.cell.value.occurrences"));
        this.advUseFetchSize.setSelection(store.getDefaultBoolean("resultset.fetch.size"));
        this.ignoreColumnLabelCheck.setSelection(store.getDefaultBoolean("resultset.column.label.ignore"));
        this.useDateTimeEditor.setSelection(store.getDefaultBoolean("resultset.datetime.editor"));
        this.useBrowserCheckbox.setSelection(store.getDefaultBoolean("resultset.image.browser"));
        super.performDefaults();
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

