/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.themes.ITheme;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDReference;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.SimpleTypedObject;
import org.jkiss.dbeaver.model.impl.data.DefaultValueHandler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.data.IDataController;
import org.jkiss.dbeaver.ui.data.IMultiController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.IValueEditorStandalone;
import org.jkiss.dbeaver.ui.data.IValueManager;
import org.jkiss.dbeaver.ui.data.managers.BaseValueManager;
import org.jkiss.dbeaver.ui.data.managers.DefaultValueManager;
import org.jkiss.dbeaver.ui.data.registry.ValueManagerRegistry;
import org.jkiss.dbeaver.ui.editors.data.internal.DataEditorsMessages;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class ComplexObjectEditor
extends TreeViewer {
    private static final Log log = Log.getLog(ComplexObjectEditor.class);
    private final IValueController parentController;
    private final IValueEditor editor;
    private DBCExecutionContext executionContext;
    private final TreeEditor treeEditor;
    private IValueEditor curCellEditor;
    private final Color backgroundAdded;
    private final Color backgroundDeleted;
    private final Color backgroundModified;
    private final CopyAction copyNameAction;
    private final CopyAction copyValueAction;
    private final SetToNullAction setToNullAction;
    private final Action addElementAction;
    private final Action removeElementAction;
    private final Action moveElementUpAction;
    private final Action moveElementDownAction;
    private final Map<Object, Object> cache = new IdentityHashMap<Object, Object>();

    public ComplexObjectEditor(IValueController parentController, IValueEditor editor, int style) {
        super(parentController.getEditPlaceholder(), style | 4 | 0x10000);
        this.parentController = parentController;
        this.editor = editor;
        ITheme currentTheme = parentController.getValueSite().getWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme();
        this.backgroundAdded = currentTheme.getColorRegistry().get("org.jkiss.dbeaver.sql.resultset.color.cell.new.background");
        this.backgroundDeleted = currentTheme.getColorRegistry().get("org.jkiss.dbeaver.sql.resultset.color.cell.deleted.background");
        this.backgroundModified = currentTheme.getColorRegistry().get("org.jkiss.dbeaver.sql.resultset.color.cell.modified.background");
        final Tree treeControl = super.getTree();
        treeControl.setHeaderVisible(true);
        treeControl.setLinesVisible(true);
        treeControl.addControlListener((ControlListener)new ControlAdapter(){
            private boolean packing = false;

            public void controlResized(ControlEvent e) {
                if (!this.packing) {
                    this.packing = true;
                    treeControl.removeControlListener((ControlListener)this);
                    UIUtils.packColumns((Tree)treeControl, (boolean)true, (float[])new float[]{0.2f, 0.8f});
                    if (treeControl.getColumn(0).getWidth() < 100) {
                        treeControl.getColumn(0).setWidth(100);
                    }
                }
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this, (int)2);
        TreeViewerColumn column = new TreeViewerColumn((TreeViewer)this, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setMoveable(true);
        column.getColumn().setText(UIMessages.ui_properties_name);
        column.setLabelProvider((CellLabelProvider)new PropsLabelProvider());
        column = new TreeViewerColumn((TreeViewer)this, 0);
        column.getColumn().setWidth(120);
        column.getColumn().setMoveable(true);
        column.getColumn().setText(UIMessages.ui_properties_value);
        column.setLabelProvider((CellLabelProvider)new PropsLabelProvider());
        this.treeEditor = new TreeEditor(treeControl);
        this.treeEditor.horizontalAlignment = 131072;
        this.treeEditor.verticalAlignment = 0x1000000;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.minimumWidth = 50;
        treeControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TreeItem item = treeControl.getItem(new Point(e.x, e.y));
                if (item != null && UIUtils.getColumnAtPos((TreeItem)item, (int)e.x, (int)e.y) == 1) {
                    ComplexObjectEditor.this.showEditor(item, false);
                }
            }
        });
        treeControl.addTraverseListener(e -> {
            if (e.detail == 4) {
                TreeItem[] selection = treeControl.getSelection();
                if (selection.length == 0) {
                    return;
                }
                if (this.treeEditor.getEditor() != null && !this.treeEditor.getEditor().isDisposed()) {
                    e.doit = true;
                    return;
                }
                this.showEditor(selection[0], (e.stateMask & 0x20000) == 131072);
                e.doit = false;
                e.detail = 0;
            } else if (e.detail == 2) {
                e.doit = false;
                this.disposeOldEditor();
            }
        });
        super.setContentProvider((IContentProvider)new StructContentProvider());
        this.copyNameAction = new CopyAction(true);
        this.copyValueAction = new CopyAction(false);
        this.setToNullAction = new SetToNullAction();
        this.addElementAction = new AddElementAction();
        this.removeElementAction = new RemoveElementAction();
        this.moveElementUpAction = new MoveElementAction(128);
        this.moveElementDownAction = new MoveElementAction(1024);
        this.addSelectionChangedListener(event -> this.updateActions());
        this.createContextMenu();
        this.updateActions();
    }

    private void createContextMenu() {
        Control control = this.getControl();
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(control);
        menuMgr.addMenuListener(manager -> {
            if (!this.getSelection().isEmpty()) {
                manager.add((IAction)this.copyNameAction);
                manager.add((IAction)this.copyValueAction);
                manager.add((IAction)this.setToNullAction);
                manager.add((IContributionItem)new Separator());
            }
            try {
                this.parentController.getValueManager().contributeActions((IContributionManager)manager, this.parentController, this.editor);
            }
            catch (DBCException e) {
                log.error((Object)e);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        control.setMenu(menu);
        control.addDisposeListener(e -> menuMgr.dispose());
    }

    public void setModel(DBCExecutionContext executionContext, Object value) {
        this.getTree().setRedraw(false);
        try {
            this.executionContext = executionContext;
            this.cache.clear();
            this.setInput(this.wrap(null, value));
            this.expandToLevel(2);
            this.updateActions();
        }
        finally {
            this.getTree().setRedraw(true);
        }
    }

    private void showEditor(TreeItem item, boolean advanced) {
        this.disposeOldEditor();
        if (item == null) {
            return;
        }
        if (ComplexObjectEditor.isComplexType(item.getData())) {
            return;
        }
        try {
            ComplexValueController valueController = new ComplexValueController((ComplexElementItem)item.getData(), advanced ? IValueController.EditType.EDITOR : IValueController.EditType.INLINE);
            IValueEditor newCellEditor = valueController.getValueManager().createEditor(valueController);
            if (newCellEditor != null) {
                newCellEditor.createControl();
                if (newCellEditor instanceof IValueEditorStandalone) {
                    ((IValueEditorStandalone)newCellEditor).showValueEditor();
                } else {
                    Control editorControl = newCellEditor.getControl();
                    if (editorControl != null) {
                        Point editorSize = editorControl.computeSize(-1, -1);
                        this.treeEditor.minimumHeight = editorSize.y;
                        this.treeEditor.setEditor(editorControl, item, 1);
                        editorControl.setFocus();
                    }
                }
                if (!advanced) {
                    newCellEditor.primeEditorValue(valueController.getValue());
                }
                this.curCellEditor = newCellEditor;
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Cell editor", "Can't open cell editor", (Throwable)e);
        }
    }

    private void disposeOldEditor() {
        this.curCellEditor = null;
        Control oldEditor = this.treeEditor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
    }

    public Object extractValue() {
        return ComplexObjectEditor.unwrap(this.getInput());
    }

    @NotNull
    private String getColumnText(ComplexElementItem item, int columnIndex, DBDDisplayFormat format) {
        if (columnIndex == 0) {
            return item.getName();
        }
        return this.getValueText(item.getValueHandler(), item.getDataType(), item.value, format);
    }

    @Nullable
    private Image getColumnImage(@NotNull ComplexElementItem item, int columnIndex) {
        if (columnIndex == 0) {
            return DBeaverIcons.getImage((DBPImage)DBValueFormatting.getTypeImage((DBSTypedObject)item.getDataType()));
        }
        return null;
    }

    private String getValueText(@NotNull DBDValueHandler valueHandler, @NotNull DBSTypedObject type, @Nullable Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof CollectionElement) {
            CollectionElement element = (CollectionElement)value;
            if (element.source instanceof DBDCollection) {
                return "[" + ((DBDCollection)element.source).getComponentType().getName() + " - " + element.items.size() + "]";
            }
            return "[" + element.items.size() + "]";
        }
        if (value instanceof CompositeElement) {
            return "[" + ((CompositeElement)value).type.getName() + "]";
        }
        if (value instanceof ReferenceElement) {
            return "--> [" + ((ReferenceElement)value).reference.getReferencedType().getName() + "]";
        }
        return valueHandler.getValueDisplayString(type, value, format);
    }

    private void autoUpdateComplexValue() {
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("resultset.edit.value.autoupdate")) {
            this.parentController.updateValue(this.extractValue(), false);
        }
    }

    @Nullable
    private Object wrap(@Nullable Object parent, @Nullable Object object) {
        if (this.cache.containsKey(object)) {
            return this.cache.get(object);
        }
        if (object instanceof Collection) {
            CollectionElement element;
            Collection collection = (Collection)object;
            if (parent == null) {
                element = new CollectionRootElement(collection);
                element.items.add(new CollectionRootElement.Item(element, this.wrap(element, object)));
            } else {
                element = new CollectionElement(parent, collection);
                for (Object item : collection) {
                    element.items.add(new CollectionElement.Item(element, this.wrap(element, item)));
                }
            }
            this.cache.put(object, element);
            return element;
        }
        if (object instanceof DBDComposite) {
            DBDComposite composite = (DBDComposite)object;
            CompositeElement element = new CompositeElement(parent, composite);
            try {
                DBSAttributeBase[] dBSAttributeBaseArray = composite.getAttributes();
                int n = dBSAttributeBaseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DBSAttributeBase attribute = dBSAttributeBaseArray[n2];
                    element.items.add(new CompositeElement.Item(element, attribute, this.wrap(element, composite.getAttributeValue(attribute))));
                    ++n2;
                }
            }
            catch (DBCException e) {
                log.error((Object)"Error getting structure meta data", (Throwable)e);
            }
            this.cache.put(object, element);
            return element;
        }
        if (object instanceof DBDReference) {
            DBDReference reference = (DBDReference)object;
            ReferenceElement element = new ReferenceElement(parent, reference);
            this.cache.put(object, element);
            return element;
        }
        return object;
    }

    @NotNull
    public static Object unwrap(@NotNull Object object) {
        if (object instanceof ComplexElement) {
            return ((ComplexElement)object).extract((DBRProgressMonitor)new VoidProgressMonitor());
        }
        if (object instanceof ComplexElementItem) {
            return ComplexObjectEditor.unwrap(((ComplexElementItem)object).value);
        }
        return object;
    }

    private static boolean isComplexType(@NotNull Object object) {
        return object instanceof CollectionElement || object instanceof CollectionElement.Item && ComplexObjectEditor.isComplexType(((CollectionElement.Item)object).value) || object instanceof CompositeElement || object instanceof CompositeElement.Item && ComplexObjectEditor.isComplexType(((CompositeElement.Item)object).value) || object instanceof ReferenceElement;
    }

    private static boolean isReadOnlyType(@Nullable Object object) {
        if (object instanceof ReferenceElement) {
            return true;
        }
        if (object instanceof ComplexElementItem) {
            return ComplexObjectEditor.isReadOnlyType(((ComplexElementItem)object).getParent());
        }
        if (object instanceof ComplexElement) {
            return ComplexObjectEditor.isReadOnlyType(((ComplexElement)object).getParent());
        }
        return false;
    }

    public void contributeActions(IContributionManager manager) {
        manager.add((IAction)this.addElementAction);
        manager.add((IAction)this.removeElementAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.moveElementUpAction);
        manager.add((IAction)this.moveElementDownAction);
    }

    private void updateActions() {
        Object object = this.getStructuredSelection().getFirstElement();
        boolean editable = !this.parentController.isReadOnly() && !ComplexObjectEditor.isReadOnlyType(object);
        boolean extendable = GeneralUtils.adapt((Object)object, CollectionElement.class) != null;
        this.copyNameAction.setEnabled(object != null);
        this.copyValueAction.setEnabled(object != null);
        this.setToNullAction.setEnabled(editable);
        if (editable && object instanceof CollectionElement.Item) {
            CollectionElement.Item item = (CollectionElement.Item)object;
            CollectionElement collection = item.collection;
            boolean child = !(collection instanceof CollectionRootElement);
            int index = collection.items.indexOf(item);
            this.addElementAction.setEnabled(extendable);
            this.removeElementAction.setEnabled(child);
            this.moveElementUpAction.setEnabled(child && index > 0);
            this.moveElementDownAction.setEnabled(child && index < collection.items.size() - 1);
        } else {
            this.addElementAction.setEnabled(editable && extendable);
            this.removeElementAction.setEnabled(false);
            this.moveElementUpAction.setEnabled(false);
            this.moveElementDownAction.setEnabled(false);
        }
    }

    private class AddElementAction
    extends Action {
        AddElementAction() {
            super(DataEditorsMessages.complex_object_editor_dialog_menu_add_element, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_ADD));
        }

        public void run() {
            ComplexObjectEditor.this.disposeOldEditor();
            ComplexElementItem element = (ComplexElementItem)ComplexObjectEditor.this.getStructuredSelection().getFirstElement();
            CollectionElement collection = (CollectionElement)GeneralUtils.adapt((Object)element, CollectionElement.class);
            CollectionElement.Item item = new CollectionElement.Item(collection, null);
            collection.items.add(item);
            item.created = true;
            ComplexObjectEditor.this.refresh();
            TreeItem treeItem = (TreeItem)ComplexObjectEditor.this.findItem(item);
            if (treeItem != null) {
                ComplexObjectEditor.this.showEditor(treeItem, false);
            }
            ComplexObjectEditor.this.autoUpdateComplexValue();
        }
    }

    private static class CollectionElement
    implements ComplexElement {
        private final Object parent;
        private final Collection<?> source;
        protected final List<Item> items;

        public CollectionElement(@Nullable Object parent, @NotNull Collection<?> source) {
            this.parent = parent;
            this.source = source;
            this.items = new ArrayList<Item>();
        }

        @Override
        @NotNull
        public Object extract(@NotNull DBRProgressMonitor monitor) {
            DBDCollection collection = this.source;
            if (collection instanceof DBDValueCloneable) {
                try {
                    collection = (DBDCollection)((DBDValueCloneable)collection).cloneValue(monitor);
                }
                catch (DBException e) {
                    log.error((Object)"Error cloning collection value", (Throwable)e);
                }
            }
            Stream<Object> values = this.items.stream().map(ComplexObjectEditor::unwrap);
            if (!(collection instanceof DBDCollection)) {
                if (collection instanceof Set) {
                    return values.collect(Collectors.toSet());
                }
                return values.collect(Collectors.toList());
            }
            collection.setContents(values.toArray());
            return collection;
        }

        @Override
        @NotNull
        public ComplexElementItem[] getChildren() {
            return (ComplexElementItem[])this.items.toArray(ComplexElementItem[]::new);
        }

        @Override
        @Nullable
        public Object getParent() {
            return this.parent;
        }

        private static class Item
        extends ComplexElementItem {
            private final CollectionElement collection;

            public Item(@NotNull CollectionElement collection, @Nullable Object value) {
                this.collection = collection;
                this.value = value;
            }

            @Override
            @NotNull
            public String getName() {
                return String.valueOf(this.collection.items.indexOf(this) + 1);
            }

            @Override
            @NotNull
            public DBSTypedObject getDataType() {
                if (this.collection.source instanceof DBDCollection) {
                    return ((DBDCollection)this.collection.source).getComponentType();
                }
                return SimpleTypedObject.DEFAULT_TYPE;
            }

            @Override
            @NotNull
            public DBDValueHandler getValueHandler() {
                if (this.collection.source instanceof DBDCollection) {
                    return ((DBDCollection)this.collection.source).getComponentValueHandler();
                }
                return DefaultValueHandler.INSTANCE;
            }

            @Override
            @NotNull
            public ComplexElement getParent() {
                return this.collection;
            }
        }
    }

    private static class CollectionRootElement
    extends CollectionElement {
        public CollectionRootElement(@NotNull Collection<?> source) {
            super(null, source);
        }

        @Override
        @NotNull
        public Object extract(@NotNull DBRProgressMonitor monitor) {
            return ((ComplexElement)((CollectionElement.Item)this.items.get((int)0)).value).extract(monitor);
        }

        private static class Item
        extends CollectionElement.Item {
            public Item(@NotNull CollectionElement collection, @Nullable Object value) {
                super(collection, value);
            }

            @Override
            @NotNull
            public String getName() {
                return DataEditorsMessages.complex_object_editor_root_element_name;
            }
        }
    }

    private static interface ComplexElement {
        @NotNull
        public Object extract(@NotNull DBRProgressMonitor var1);

        @NotNull
        public ComplexElementItem[] getChildren();

        @Nullable
        public Object getParent();
    }

    private static abstract class ComplexElementItem
    implements IAdaptable {
        protected boolean created;
        protected boolean modified;
        protected Object value;

        private ComplexElementItem() {
        }

        @NotNull
        public abstract String getName();

        @NotNull
        public abstract DBSTypedObject getDataType();

        @NotNull
        public abstract DBDValueHandler getValueHandler();

        @NotNull
        public abstract ComplexElement getParent();

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter.isInstance(this.value)) {
                return adapter.cast(this.value);
            }
            return null;
        }
    }

    private static interface ComplexElementReferrer {
        @Nullable
        public Object getReferencedValue();
    }

    private class ComplexValueController
    implements IValueController,
    IMultiController {
        private final ComplexElementItem item;
        private final DBDValueHandler valueHandler;
        private final DBSTypedObject type;
        private final String name;
        private final Object value;
        private final IValueController.EditType editType;

        ComplexValueController(ComplexElementItem obj, IValueController.EditType editType) throws DBCException {
            this.item = obj;
            this.editType = editType;
            if (obj instanceof CollectionElement.Item) {
                CollectionElement.Item item = (CollectionElement.Item)obj;
                this.valueHandler = item.getValueHandler();
                this.type = item.getDataType();
                this.name = this.type.getTypeName() + "[" + item.getName() + "]";
                this.value = item.value;
            } else if (obj instanceof CompositeElement.Item) {
                CompositeElement.Item item = (CompositeElement.Item)obj;
                this.valueHandler = item.getValueHandler();
                this.type = item.getDataType();
                this.name = item.attribute.getName();
                this.value = item.value;
            } else {
                throw new DBCException("Unsupported complex object element: " + String.valueOf(this.item));
            }
        }

        @Override
        @NotNull
        public DBCExecutionContext getExecutionContext() {
            return ComplexObjectEditor.this.executionContext;
        }

        @Override
        @NotNull
        public IDataController getDataController() {
            return ComplexObjectEditor.this.parentController.getDataController();
        }

        @Override
        public String getValueName() {
            return this.name;
        }

        @Override
        public DBSTypedObject getValueType() {
            return this.type;
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.value;
        }

        @Override
        public void updateValue(Object value, boolean updatePresentation) {
            if (CommonUtils.equalObjects((Object)this.item.value, (Object)value)) {
                return;
            }
            this.item.value = value;
            this.item.modified = true;
            ComplexObjectEditor.this.autoUpdateComplexValue();
            ComplexObjectEditor.this.refresh(this.item);
        }

        @Override
        public void updateSelectionValue(Object value) {
            this.updateValue(value, true);
        }

        @Override
        public DBDValueHandler getValueHandler() {
            return this.valueHandler;
        }

        @Override
        public IValueManager getValueManager() {
            DBSTypedObject valueType = this.getValueType();
            if (valueType == null) {
                return DefaultValueManager.INSTANCE;
            }
            return ValueManagerRegistry.findValueManager(this.getExecutionContext().getDataSource(), valueType, this.getValueHandler().getValueObjectType(valueType));
        }

        @Override
        public IValueController.EditType getEditType() {
            return this.editType;
        }

        @Override
        public boolean isReadOnly() {
            return ComplexObjectEditor.this.parentController.isReadOnly() || ComplexObjectEditor.isReadOnlyType(this.item.getParent());
        }

        @Override
        public IWorkbenchPartSite getValueSite() {
            return ComplexObjectEditor.this.parentController.getValueSite();
        }

        @Override
        public Composite getEditPlaceholder() {
            return ComplexObjectEditor.this.getTree();
        }

        @Override
        public void refreshEditor() {
            ComplexObjectEditor.this.parentController.refreshEditor();
        }

        @Override
        public void showMessage(String message, DBPMessageType messageType) {
        }

        @Override
        public void closeInlineEditor() {
            ComplexObjectEditor.this.disposeOldEditor();
        }

        @Override
        public void nextInlineEditor(boolean next) {
            ComplexObjectEditor.this.disposeOldEditor();
        }
    }

    private static class CompositeElement
    implements ComplexElement {
        private final Object parent;
        private final DBDComposite source;
        private final List<Item> items;
        private final DBSDataType type;

        public CompositeElement(@Nullable Object parent, @NotNull DBDComposite source) {
            this.parent = parent;
            this.source = source;
            this.items = new ArrayList<Item>();
            this.type = source.getDataType();
        }

        @Override
        @NotNull
        public Object extract(@NotNull DBRProgressMonitor monitor) {
            DBDComposite composite = this.source;
            if (composite instanceof DBDValueCloneable) {
                try {
                    composite = (DBDComposite)((DBDValueCloneable)composite).cloneValue(monitor);
                }
                catch (DBException e) {
                    log.error((Object)"Error cloning composite value", (Throwable)e);
                }
            }
            for (Item item : this.items) {
                try {
                    composite.setAttributeValue(item.attribute, ComplexObjectEditor.unwrap(item.value));
                }
                catch (DBCException e) {
                    log.error((Object)"Error setting composite attribute value", (Throwable)e);
                }
            }
            return composite;
        }

        @Override
        @NotNull
        public ComplexElementItem[] getChildren() {
            return (ComplexElementItem[])this.items.toArray(ComplexElementItem[]::new);
        }

        @Override
        @Nullable
        public Object getParent() {
            return this.parent;
        }

        private static class Item
        extends ComplexElementItem {
            private final CompositeElement composite;
            private final DBSAttributeBase attribute;

            public Item(@NotNull CompositeElement composite, @NotNull DBSAttributeBase attribute, @Nullable Object value) {
                this.composite = composite;
                this.attribute = attribute;
                this.value = value;
            }

            @Override
            @NotNull
            public String getName() {
                return this.attribute.getName();
            }

            @Override
            @NotNull
            public DBSTypedObject getDataType() {
                return this.attribute;
            }

            @Override
            @NotNull
            public DBDValueHandler getValueHandler() {
                return DBUtils.findValueHandler((DBPDataSource)this.composite.type.getDataSource(), (DBSTypedObject)this.attribute);
            }

            @Override
            @NotNull
            public ComplexElement getParent() {
                return this.composite;
            }
        }
    }

    private class CopyAction
    extends Action {
        private final boolean isName;

        CopyAction(boolean isName) {
            super(NLS.bind((String)DataEditorsMessages.complex_object_editor_dialog_menu_copy_element, (Object)ComplexObjectEditor.this.getTree().getColumn(isName ? 0 : 1).getText()));
            this.isName = isName;
        }

        public void run() {
            String text;
            ITreeSelection selection = ComplexObjectEditor.this.getStructuredSelection();
            if (!selection.isEmpty() && (text = ComplexObjectEditor.this.getColumnText((ComplexElementItem)selection.getFirstElement(), this.isName ? 0 : 1, DBDDisplayFormat.NATIVE)) != null) {
                UIUtils.setClipboardContents((Display)ComplexObjectEditor.this.getTree().getDisplay(), (Transfer)TextTransfer.getInstance(), (Object)text);
            }
        }
    }

    private class MoveElementAction
    extends Action {
        private final int direction;

        MoveElementAction(int dir) {
            super(dir == 128 ? DataEditorsMessages.complex_object_editor_dialog_menu_move_up_element : DataEditorsMessages.complex_object_editor_dialog_menu_move_down_element, DBeaverIcons.getImageDescriptor((DBPImage)(dir == 128 ? UIIcon.ARROW_UP : UIIcon.ARROW_DOWN)));
            this.direction = dir;
        }

        public void run() {
            ComplexObjectEditor.this.disposeOldEditor();
            CollectionElement.Item item = (CollectionElement.Item)ComplexObjectEditor.this.getStructuredSelection().getFirstElement();
            CollectionElement collection = item.collection;
            int index = collection.items.indexOf(item);
            if (this.direction == 128) {
                if (index == 0) {
                    return;
                }
                this.swap(collection, index, index - 1);
                ComplexObjectEditor.this.setSelection((ISelection)new StructuredSelection((Object)collection.items.get(index - 1)));
            } else if (this.direction == 1024) {
                if (index == collection.items.size() - 1) {
                    return;
                }
                this.swap(collection, index, index + 1);
                ComplexObjectEditor.this.setSelection((ISelection)new StructuredSelection((Object)collection.items.get(index + 1)));
            }
            ComplexObjectEditor.this.refresh();
            ComplexObjectEditor.this.autoUpdateComplexValue();
        }

        private void swap(@NotNull CollectionElement collection, int firstIndex, int secondIndex) {
            CollectionElement.Item temp = collection.items.get(firstIndex);
            collection.items.set(firstIndex, collection.items.get(secondIndex));
            collection.items.set(secondIndex, temp);
        }
    }

    private class PropsLabelProvider
    extends CellLabelProvider {
        private PropsLabelProvider() {
        }

        public String getToolTipText(Object obj) {
            if (obj instanceof CompositeElement.Item) {
                return ((CompositeElement.Item)obj).attribute.getName() + " " + ((CompositeElement.Item)obj).attribute.getTypeName();
            }
            return null;
        }

        public void update(ViewerCell cell) {
            ComplexElementItem element = (ComplexElementItem)cell.getElement();
            cell.setText(ComplexObjectEditor.this.getColumnText(element, cell.getColumnIndex(), DBDDisplayFormat.UI));
            cell.setImage(ComplexObjectEditor.this.getColumnImage(element, cell.getColumnIndex()));
            if (element.created) {
                cell.setBackground(ComplexObjectEditor.this.backgroundAdded);
            } else if (element.modified) {
                cell.setBackground(ComplexObjectEditor.this.backgroundModified);
            } else {
                cell.setBackground(null);
            }
        }
    }

    private class ReferenceElement
    implements ComplexElement,
    ComplexElementReferrer {
        private final Object parent;
        private final DBDReference reference;
        private final Object value;

        public ReferenceElement(@NotNull Object parent, final DBDReference reference) {
            DBRRunnableWithResult<Object> runnable = new DBRRunnableWithResult<Object>(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException {
                    monitor.beginTask("Read object reference", 1);
                    try {
                        try {
                            Throwable throwable = null;
                            Object var3_5 = null;
                            try (DBCSession session = ((ReferenceElement)ReferenceElement.this).ComplexObjectEditor.this.executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Read reference value");){
                                this.result = reference.getReferencedObject(session);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (DBCException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            UIUtils.runInUI((DBRRunnableWithProgress)runnable);
            this.parent = parent;
            this.reference = reference;
            this.value = runnable.getResult();
        }

        @Override
        @NotNull
        public Object extract(@NotNull DBRProgressMonitor monitor) {
            return this.reference;
        }

        @Override
        @NotNull
        public ComplexElementItem[] getChildren() {
            return new ComplexElementItem[0];
        }

        @Override
        @Nullable
        public Object getParent() {
            return this.parent;
        }

        @Override
        @Nullable
        public Object getReferencedValue() {
            return this.value;
        }
    }

    private class RemoveElementAction
    extends Action {
        RemoveElementAction() {
            super(DataEditorsMessages.complex_object_editor_dialog_menu_remove_element, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_DELETE));
        }

        public void run() {
            ComplexObjectEditor.this.disposeOldEditor();
            CollectionElement.Item item = (CollectionElement.Item)ComplexObjectEditor.this.getStructuredSelection().getFirstElement();
            CollectionElement collection = item.collection;
            int index = collection.items.indexOf(item);
            collection.items.remove(index);
            if (!collection.items.isEmpty()) {
                ComplexObjectEditor.this.setSelection((ISelection)new StructuredSelection((Object)collection.items.get(CommonUtils.clamp((int)index, (int)0, (int)(collection.items.size() - 1)))));
            }
            ComplexObjectEditor.this.refresh();
            ComplexObjectEditor.this.autoUpdateComplexValue();
        }
    }

    private class SetToNullAction
    extends Action {
        public SetToNullAction() {
            super(DataEditorsMessages.complex_object_editor_dialog_menu_set_element_to_null);
        }

        public void run() {
            ITreeSelection selection = ComplexObjectEditor.this.getStructuredSelection();
            if (selection.isEmpty()) {
                return;
            }
            try {
                ComplexValueController valueController = new ComplexValueController((ComplexElementItem)selection.getFirstElement(), IValueController.EditType.NONE);
                valueController.updateValue(BaseValueManager.makeNullValue(valueController), true);
            }
            catch (DBCException e) {
                log.error((Object)"Error setting value attribute to NULL", (Throwable)e);
            }
        }
    }

    private class StructContentProvider
    extends TreeContentProvider {
        private StructContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public ComplexElementItem[] getChildren(Object parent) {
            if (parent instanceof ComplexElementReferrer) {
                return this.getChildren(ComplexObjectEditor.this.wrap(parent, ((ComplexElementReferrer)parent).getReferencedValue()));
            }
            if (parent instanceof ComplexElementItem) {
                return this.getChildren(((ComplexElementItem)parent).value);
            }
            if (parent instanceof ComplexElement) {
                return ((ComplexElement)parent).getChildren();
            }
            return new ComplexElementItem[0];
        }

        public boolean hasChildren(Object parent) {
            return ComplexObjectEditor.isComplexType(parent);
        }
    }
}

