/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeContentTypeProvider;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.trace.DBCTrace;
import org.jkiss.dbeaver.model.exec.trace.DBCTraceDynamic;
import org.jkiss.dbeaver.model.impl.sql.RelationalSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContext;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

class ResultSetContextImpl
implements IResultSetContext {
    private final ResultSetViewer viewer;
    private final DBCResultSet resultSet;

    ResultSetContextImpl(ResultSetViewer viewer, DBCResultSet resultSet) {
        this.viewer = viewer;
        this.resultSet = resultSet;
    }

    @Override
    public boolean supportsAttributes() {
        DBDAttributeBinding[] attrs = this.viewer.getModel().getAttributes();
        return attrs.length > 0;
    }

    @Override
    public boolean supportsDocument() {
        return this.viewer.getModel().getDocumentAttribute() != null;
    }

    @Override
    public boolean supportsGrouping() {
        DBPDataSource dataSource = this.viewer.getDataSource();
        if (dataSource != null) {
            SQLDialect sqlDialect = dataSource.getSQLDialect();
            return sqlDialect instanceof RelationalSQLDialect && ((RelationalSQLDialect)sqlDialect).supportsGroupBy();
        }
        return false;
    }

    @Override
    public boolean supportsReferences() {
        DBPDataSource dataSource = this.viewer.getDataSource();
        if (dataSource != null) {
            return dataSource.getInfo().supportsReferentialIntegrity();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean supportsTrace() {
        DBCTrace trace = this.viewer.getModel().getTrace();
        DBCTrace dBCTrace = trace;
        if (dBCTrace instanceof DBCTraceDynamic) {
            void td;
            DBCTraceDynamic dBCTraceDynamic = (DBCTraceDynamic)dBCTrace;
            DBCTraceDynamic cfr_ignored_0 = (DBCTraceDynamic)dBCTrace;
            if (td.hasDynamicProperties()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDocumentContentType() {
        DBDAttributeBinding docAttr = this.viewer.getModel().getDocumentAttribute();
        if (docAttr != null) {
            return docAttr.getValueHandler().getValueContentType((DBSTypedObject)docAttr);
        }
        Pair<DBDAttributeBinding, String> contentAttribute = this.getUniqueContentAttribute();
        if (contentAttribute != null) {
            return (String)contentAttribute.getSecond();
        }
        return null;
    }

    @Override
    @Nullable
    public DBDAttributeBinding getDocumentAttribute() {
        DBDAttributeBinding documentAttribute = this.viewer.getModel().getDocumentAttribute();
        if (documentAttribute != null) {
            return documentAttribute;
        }
        Pair<DBDAttributeBinding, String> contentAttribute = this.getUniqueContentAttribute();
        if (contentAttribute != null) {
            return (DBDAttributeBinding)contentAttribute.getFirst();
        }
        return null;
    }

    @Override
    public DBCResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public boolean hasAttributeOfType(String typeName) {
        DBDAttributeBinding[] dBDAttributeBindingArray = this.viewer.getModel().getAttributes();
        int n = dBDAttributeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class objectType;
            DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
            DBDValueHandler valueHandler = attr.getValueHandler();
            if (valueHandler != null && (objectType = valueHandler.getValueObjectType((DBSTypedObject)attr.getAttribute())) != null && objectType.getName().equals(typeName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Nullable
    private Pair<DBDAttributeBinding, String> getUniqueContentAttribute() {
        DBDAttributeContentTypeProvider provider;
        DBPDataSource dataSource = this.viewer.getDataSource();
        if (dataSource != null && (provider = (DBDAttributeContentTypeProvider)GeneralUtils.adapt((Object)dataSource, DBDAttributeContentTypeProvider.class)) != null) {
            Pair result = null;
            DBDAttributeBinding[] dBDAttributeBindingArray = this.viewer.getModel().getAttributes();
            int n = dBDAttributeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
                String contentType = provider.getContentType(attr);
                if (CommonUtils.isNotEmpty((String)contentType)) {
                    if (result != null) break;
                    result = new Pair((Object)attr, (Object)contentType);
                }
                ++n2;
            }
            return result;
        }
        return null;
    }
}

