/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.lightgrid;

import java.lang.invoke.StringConcatFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UITextUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.lightgrid.AbstractRenderer;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridColumn;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridColumn;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridContentProvider;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridRow;
import org.jkiss.dbeaver.ui.controls.lightgrid.LightGrid;
import org.jkiss.utils.CommonUtils;

class GridCellRenderer
extends AbstractRenderer {
    private static final int LEFT_MARGIN = 6;
    private static final int RIGHT_MARGIN = 6;
    private static final int TOP_MARGIN = 0;
    private static final int TEXT_TOP_MARGIN = 1;
    private static final int INSIDE_MARGIN = 3;
    static final Image LINK_IMAGE = DBeaverIcons.getImage((DBPImage)UIIcon.LINK);
    static final Image LINK2_IMAGE = DBeaverIcons.getImage((DBPImage)UIIcon.LINK2);
    static final Rectangle LINK_IMAGE_BOUNDS = new Rectangle(0, 0, 13, 13);
    private static final boolean USE_CLIPPING = false;
    private static final String[][] SPECIAL_CHARACTERS_MAP = new String[][]{{" ", "\u00b7"}, {"\r\n", "\u00b6"}, {"\r", "\u00b6"}, {"\n", "\u00b6"}, {"\t", "\u00bb"}, {"\u3000", "\u00b0"}, {"\u200b", "\u2588"}, {"\u0000", "NUL"}, {"\u0001", "SOH"}, {"\u0002", "STX"}, {"\u0003", "ETX"}, {"\u0004", "EOT"}, {"\u0005", "ENQ"}, {"\u0006", "ACK"}, {"\u0007", "BEL"}, {"\b", "BS"}, {"\u000b", "VT"}, {"\f", "FF"}, {"\u000e", "SO"}, {"\u000f", "SI"}, {"\u0010", "DLE"}, {"\u0011", "DC1"}, {"\u0012", "DC2"}, {"\u0013", "DC3"}, {"\u0014", "DC4"}, {"\u0015", "NAK"}, {"\u0016", "SYN"}, {"\u0017", "ETB"}, {"\u0018", "CAN"}, {"\u0019", "EM"}, {"\u001a", "SUB"}, {"\u001b", "ESC"}, {"\u001c", "FS"}, {"\u001d", "GS"}, {"\u001e", "RS"}, {"\u001f", "US"}, {"\u007f", "DEL"}};
    protected Color colorLineFocused;

    public GridCellRenderer(LightGrid grid) {
        super(grid);
        this.colorLineFocused = grid.getDisplay().getSystemColor(24);
    }

    public void paint(GC gc, Rectangle bounds, boolean selected, boolean focus, IGridColumn col, IGridRow row) {
        int x;
        Image image;
        boolean drawBackground = true;
        IGridContentProvider.CellInformation cellInfo = this.grid.getContentProvider().getCellInfo(col, row, selected);
        if (cellInfo.background == null) {
            cellInfo.background = this.grid.getBackground();
        }
        if (cellInfo.foreground == null) {
            cellInfo.foreground = this.grid.getForeground();
        }
        if (cellInfo.background != null) {
            gc.setBackground(cellInfo.background);
        } else {
            drawBackground = false;
        }
        gc.setForeground(cellInfo.foreground);
        if (drawBackground) {
            gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        String text = this.grid.getCellText(cellInfo.text);
        int state = cellInfo.state;
        Rectangle imageBounds = null;
        DBPImage cellImage = cellInfo.image;
        if (cellImage != null) {
            image = DBeaverIcons.getImage((DBPImage)cellImage);
            imageBounds = image.getBounds();
        } else {
            image = null;
        }
        if (image == null && GridCellRenderer.isLinkState(state)) {
            image = (state & 1) != 0 ? LINK_IMAGE : LINK2_IMAGE;
            imageBounds = LINK_IMAGE_BOUNDS;
        }
        int columnAlign = cellInfo.align;
        int n = x = image == null ? 6 : 3;
        if (image != null && columnAlign != 2) {
            int y = bounds.y + (bounds.height - imageBounds.height) / 2;
            if (columnAlign == 1) {
                x += (bounds.width - imageBounds.width - 6 - 6) / 2;
            }
            gc.drawImage(image, bounds.x + x, y);
            x += imageBounds.width + 3;
        }
        int width = bounds.width - x - 6;
        String originalText = text;
        if (!text.isEmpty()) {
            text = UITextUtils.getShortString((FontMetrics)this.grid.fontMetrics, (String)text, (int)width);
            text = CommonUtils.getSingleLineString((String)text);
            Font font = cellInfo.font;
            gc.setFont(font != null ? font : this.grid.normalFont);
            switch (columnAlign) {
                case 1: {
                    Point textSize = gc.textExtent(text);
                    gc.drawString(text, bounds.x + (bounds.width - textSize.x) / 2, bounds.y + 1 + 0, isTransparent);
                    break;
                }
                case 2: {
                    Point textSize = gc.textExtent(text);
                    int valueWidth = textSize.x + 3;
                    if (imageBounds != null) {
                        valueWidth += imageBounds.width + 3;
                    }
                    boolean useClipping = (valueWidth += 6) > bounds.width;
                    int imageMargin = 0;
                    if (image != null) {
                        imageMargin = imageBounds.width + 3;
                        if (useClipping) {
                            gc.setClipping(bounds.x, bounds.y, bounds.width - imageMargin, bounds.height);
                        }
                    } else if (useClipping) {
                        gc.setClipping(bounds);
                    }
                    gc.drawString(text, bounds.x + bounds.width - (textSize.x + 6 + imageMargin), bounds.y + 1 + 0, isTransparent);
                    if (!useClipping) break;
                    gc.setClipping(null);
                    break;
                }
                default: {
                    if (CommonUtils.isBitSet((int)state, (int)16)) {
                        this.drawCellTextDecorated(gc, originalText, cellInfo, new Rectangle(bounds.x + x, bounds.y + 1 + 0, bounds.width - 6 - 6, bounds.height));
                        break;
                    }
                    gc.drawString(text, bounds.x + x, bounds.y + 1 + 0, isTransparent);
                }
            }
        }
        if (image != null && columnAlign == 2) {
            int y = bounds.y + (bounds.height - imageBounds.height) / 2;
            gc.drawImage(image, bounds.x + bounds.width - imageBounds.width - 6, y);
        }
        if (focus) {
            gc.setForeground(this.colorLineFocused);
            gc.drawRectangle(bounds.x + 1, bounds.y, bounds.width - 2, bounds.height - 1);
            if (this.grid.isFocusControl()) {
                gc.drawRectangle(bounds.x + 2, bounds.y + 1, bounds.width - 4, bounds.height - 3);
            }
        }
    }

    boolean isOverLink(GridColumn column, int row, int x, int y) {
        boolean isToggle;
        IGridContentProvider contentProvider = this.grid.getContentProvider();
        IGridRow rowElement = this.grid.getRow(row);
        IGridContentProvider.CellInformation cellInfo = this.grid.getContentProvider().getCellInfo(column, rowElement, false);
        int state = cellInfo.state;
        boolean bl = isToggle = (state & 8) != 0;
        if (isToggle && contentProvider.isElementReadOnly(column)) {
            return false;
        }
        if (GridCellRenderer.isLinkState(state) || isToggle) {
            Rectangle imageBounds;
            int columnAlign = cellInfo.align;
            Point origin = this.grid.getOrigin(column, row);
            if (isToggle) {
                String cellText = this.grid.getCellText(cellInfo.text);
                GC sizingGC = new GC((Drawable)this.grid);
                Point textSize = sizingGC.textExtent(cellText);
                sizingGC.dispose();
                imageBounds = new Rectangle(0, 0, textSize.x, textSize.y);
            } else {
                DBPImage cellImage = cellInfo.image;
                Image image = cellImage == null ? ((state & 1) != 0 ? LINK_IMAGE : LINK2_IMAGE) : DBeaverIcons.getImage((DBPImage)cellImage);
                imageBounds = image.getBounds();
            }
            int verMargin = (this.grid.getItemHeight() - imageBounds.height) / 2;
            int leftMargin = 3;
            switch (columnAlign) {
                case 0: {
                    if (x < origin.x + leftMargin || x > origin.x + leftMargin + imageBounds.width || y < origin.y + verMargin || y > origin.y + verMargin + imageBounds.height) break;
                    return true;
                }
                case 2: {
                    int width = column.getWidth();
                    if (x < origin.x + width - (leftMargin + imageBounds.width) || x > origin.x + width - 6 || y < origin.y + verMargin || y > origin.y + verMargin + imageBounds.height) break;
                    return true;
                }
                case 1: {
                    int leftIndent = (column.getWidth() - imageBounds.width - 6 - leftMargin) / 2;
                    if (x < origin.x + leftMargin + leftIndent || x > origin.x + leftMargin + leftIndent + imageBounds.width || y < origin.y + verMargin || y > origin.y + verMargin + imageBounds.height) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isLinkState(int state) {
        return (state & 1) != 0 || (state & 2) != 0;
    }

    private void drawCellTextDecorated(@NotNull GC gc, @NotNull String text, @NotNull IGridContentProvider.CellInformation cellInfo, @NotNull Rectangle bounds) {
        Color activeForeground = cellInfo.foreground;
        Color activeBackground = cellInfo.background;
        Color disabledForeground = UIUtils.getSharedColor((RGB)UIUtils.blend((RGB)activeForeground.getRGB(), (RGB)activeBackground.getRGB(), (int)50));
        int start = 0;
        int index = 0;
        while (index < text.length()) {
            boolean matched = false;
            String[][] stringArray = SPECIAL_CHARACTERS_MAP;
            int n = SPECIAL_CHARACTERS_MAP.length;
            int n2 = 0;
            while (n2 < n) {
                String[] mapping = stringArray[n2];
                String expected = mapping[0];
                String replacement = mapping[1];
                boolean regionMatches = text.regionMatches(index, expected, 0, expected.length());
                if (regionMatches) {
                    if (this.drawCellTextSegment(gc, text.substring(start, index), bounds, activeForeground, disabledForeground, false)) {
                        return;
                    }
                    if (this.drawCellTextSegment(gc, replacement, bounds, disabledForeground, disabledForeground, replacement.length() > 1)) {
                        return;
                    }
                    start = index += expected.length();
                    matched = true;
                }
                ++n2;
            }
            if (matched) continue;
            ++index;
        }
        if (start < text.length()) {
            this.drawCellTextSegment(gc, text.substring(start), bounds, activeForeground, disabledForeground, false);
        }
    }

    private boolean drawCellTextSegment(@NotNull GC gc, @NotNull String segment, @NotNull Rectangle bounds, @NotNull Color activeForeground, @NotNull Color disabledForeground, boolean highlight) {
        if (segment.isEmpty()) {
            return false;
        }
        Point extent = gc.textExtent(segment);
        if (extent.x > bounds.width) {
            int low = 0;
            int high = segment.length();
            String clipped = segment;
            while (low <= high) {
                int mid = low + high >>> 1;
                clipped = segment.substring(0, mid);
                int val = gc.textExtent((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001..."}, (String)clipped))).x;
                if (val < bounds.width) {
                    low = mid + 1;
                    continue;
                }
                if (val <= bounds.width) break;
                high = mid - 1;
            }
            this.drawTextAndAdvance(gc, clipped, activeForeground, bounds, false);
            this.drawTextAndAdvance(gc, "...", disabledForeground, bounds, false);
            return true;
        }
        this.drawTextAndAdvance(gc, segment, activeForeground, bounds, highlight);
        return false;
    }

    private void drawTextAndAdvance(@NotNull GC gc, @NotNull String text, @NotNull Color foreground, @NotNull Rectangle bounds, boolean highlight) {
        if (text.isEmpty()) {
            return;
        }
        gc.setTextAntialias(1);
        gc.setForeground(foreground);
        Point extent = gc.stringExtent(text);
        if (highlight) {
            extent.x += 2;
            gc.drawRoundRectangle(bounds.x, bounds.y, extent.x, extent.y - 1, 2, 2);
            bounds.x += 2;
            bounds.width -= 2;
        }
        gc.drawString(text, bounds.x, bounds.y, true);
        bounds.x += extent.x;
        bounds.width -= extent.x;
    }
}

