/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresql.PostgreSqlManager;
import com.azure.resourcemanager.postgresql.fluent.models.ServerSecurityAlertPolicyInner;
import com.azure.resourcemanager.postgresql.implementation.Utils;
import com.azure.resourcemanager.postgresql.models.SecurityAlertPolicyName;
import com.azure.resourcemanager.postgresql.models.ServerSecurityAlertPolicy;
import com.azure.resourcemanager.postgresql.models.ServerSecurityAlertPolicyState;
import java.util.Collections;
import java.util.List;

public final class ServerSecurityAlertPolicyImpl
implements ServerSecurityAlertPolicy,
ServerSecurityAlertPolicy.Definition,
ServerSecurityAlertPolicy.Update {
    private ServerSecurityAlertPolicyInner innerObject;
    private final PostgreSqlManager serviceManager;
    private String resourceGroupName;
    private String serverName;
    private SecurityAlertPolicyName securityAlertPolicyName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ServerSecurityAlertPolicyState state() {
        return this.innerModel().state();
    }

    @Override
    public List<String> disabledAlerts() {
        List<String> inner = this.innerModel().disabledAlerts();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> emailAddresses() {
        List<String> inner = this.innerModel().emailAddresses();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean emailAccountAdmins() {
        return this.innerModel().emailAccountAdmins();
    }

    @Override
    public String storageEndpoint() {
        return this.innerModel().storageEndpoint();
    }

    @Override
    public String storageAccountAccessKey() {
        return this.innerModel().storageAccountAccessKey();
    }

    @Override
    public Integer retentionDays() {
        return this.innerModel().retentionDays();
    }

    @Override
    public ServerSecurityAlertPolicyInner innerModel() {
        return this.innerObject;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public ServerSecurityAlertPolicyImpl withExistingServer(String resourceGroupName, String serverName) {
        this.resourceGroupName = resourceGroupName;
        this.serverName = serverName;
        return this;
    }

    @Override
    public ServerSecurityAlertPolicy create() {
        this.innerObject = this.serviceManager.serviceClient().getServerSecurityAlertPolicies().createOrUpdate(this.resourceGroupName, this.serverName, this.securityAlertPolicyName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ServerSecurityAlertPolicy create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getServerSecurityAlertPolicies().createOrUpdate(this.resourceGroupName, this.serverName, this.securityAlertPolicyName, this.innerModel(), context);
        return this;
    }

    ServerSecurityAlertPolicyImpl(SecurityAlertPolicyName name, PostgreSqlManager serviceManager) {
        this.innerObject = new ServerSecurityAlertPolicyInner();
        this.serviceManager = serviceManager;
        this.securityAlertPolicyName = name;
    }

    @Override
    public ServerSecurityAlertPolicyImpl update() {
        return this;
    }

    @Override
    public ServerSecurityAlertPolicy apply() {
        this.innerObject = this.serviceManager.serviceClient().getServerSecurityAlertPolicies().createOrUpdate(this.resourceGroupName, this.serverName, this.securityAlertPolicyName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ServerSecurityAlertPolicy apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getServerSecurityAlertPolicies().createOrUpdate(this.resourceGroupName, this.serverName, this.securityAlertPolicyName, this.innerModel(), context);
        return this;
    }

    ServerSecurityAlertPolicyImpl(ServerSecurityAlertPolicyInner innerObject, PostgreSqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serverName = Utils.getValueFromIdByName(innerObject.id(), "servers");
        this.securityAlertPolicyName = SecurityAlertPolicyName.fromString(Utils.getValueFromIdByName(innerObject.id(), "securityAlertPolicies"));
    }

    @Override
    public ServerSecurityAlertPolicy refresh() {
        this.innerObject = (ServerSecurityAlertPolicyInner)((Object)this.serviceManager.serviceClient().getServerSecurityAlertPolicies().getWithResponse(this.resourceGroupName, this.serverName, this.securityAlertPolicyName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ServerSecurityAlertPolicy refresh(Context context) {
        this.innerObject = (ServerSecurityAlertPolicyInner)((Object)this.serviceManager.serviceClient().getServerSecurityAlertPolicies().getWithResponse(this.resourceGroupName, this.serverName, this.securityAlertPolicyName, context).getValue());
        return this;
    }

    @Override
    public ServerSecurityAlertPolicyImpl withState(ServerSecurityAlertPolicyState state) {
        this.innerModel().withState(state);
        return this;
    }

    @Override
    public ServerSecurityAlertPolicyImpl withDisabledAlerts(List<String> disabledAlerts) {
        this.innerModel().withDisabledAlerts(disabledAlerts);
        return this;
    }

    @Override
    public ServerSecurityAlertPolicyImpl withEmailAddresses(List<String> emailAddresses) {
        this.innerModel().withEmailAddresses(emailAddresses);
        return this;
    }

    @Override
    public ServerSecurityAlertPolicyImpl withEmailAccountAdmins(Boolean emailAccountAdmins) {
        this.innerModel().withEmailAccountAdmins(emailAccountAdmins);
        return this;
    }

    @Override
    public ServerSecurityAlertPolicyImpl withStorageEndpoint(String storageEndpoint) {
        this.innerModel().withStorageEndpoint(storageEndpoint);
        return this;
    }

    @Override
    public ServerSecurityAlertPolicyImpl withStorageAccountAccessKey(String storageAccountAccessKey) {
        this.innerModel().withStorageAccountAccessKey(storageAccountAccessKey);
        return this;
    }

    @Override
    public ServerSecurityAlertPolicyImpl withRetentionDays(Integer retentionDays) {
        this.innerModel().withRetentionDays(retentionDays);
        return this;
    }
}

