/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model;

import com.dbeaver.db.snowflake.model.SnowflakeUtils;
import java.sql.ResultSet;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericScriptObject;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SnowflakeSequence
extends GenericSequence
implements GenericScriptObject,
DBPRefreshableObject {
    private long startValue;
    private long nextValue;
    private Date createTime;
    private Date lastAlter;
    private String source;
    private String description;

    public SnowflakeSequence(GenericStructContainer container, String name, String description, Number lastValue, Number minValue, Number maxValue, Number incrementBy, @NotNull JDBCResultSet dbResult) {
        super(container, name, description, lastValue, minValue, maxValue, incrementBy);
        this.startValue = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"START_VALUE");
        this.nextValue = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"NEXT_VALUE");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
        this.lastAlter = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_ALTERED");
        this.description = description;
    }

    public SnowflakeSequence(@NotNull GenericStructContainer container, @NotNull String name) {
        super(container, name);
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=10)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Number getLastValue() {
        return super.getLastValue();
    }

    @Property(viewable=true, order=2)
    public long getStartValue() {
        return this.startValue;
    }

    @Property(viewable=true, order=3)
    public long getNextValue() {
        return this.nextValue;
    }

    public Number getMinValue() {
        return super.getMinValue();
    }

    public Number getMaxValue() {
        return super.getMaxValue();
    }

    @Property(viewable=true, editable=true, updatable=true, order=5)
    public Long getIncrementBy() {
        return super.getIncrementBy().longValue();
    }

    @Property(viewable=true, order=6)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=true, order=7)
    public Date getLastAlter() {
        return this.lastAlter;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.source == null) {
            this.source = this.isPersisted() ? SnowflakeUtils.getObjectDDL(monitor, (DBPQualifiedObject)this, "SEQUENCE", this.description) : "CREATE SEQUENCE " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + " INCREMENT = " + String.valueOf(this.getIncrementBy());
        }
        return this.source;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        this.source = null;
        return this;
    }
}

