/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model;

import com.dbeaver.db.snowflake.model.SnowflakeMaterializedView;
import com.dbeaver.db.snowflake.model.SnowflakePipe;
import com.dbeaver.db.snowflake.model.SnowflakeStage;
import com.dbeaver.db.snowflake.model.SnowflakeStream;
import com.dbeaver.db.snowflake.model.SnowflakeTable;
import com.dbeaver.db.snowflake.model.SnowflakeTask;
import com.dbeaver.db.snowflake.model.SnowflakeUniqueKey;
import com.dbeaver.db.snowflake.model.SnowflakeView;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableConstraintColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SnowflakeSchema
extends GenericSchema
implements DBPQualifiedObject {
    private String name;
    private String owner;
    private long retentionTime;
    private Date createTime;
    private Date lastAltered;
    private boolean isTransient;
    private boolean isManagedAccess;
    private String description;
    private final UniqueConstraintCache uniqueConstraintCache;
    private final StageCache stageCache = new StageCache();
    private final PipeCache pipeCache = new PipeCache();
    private final StreamCache streamCache = new StreamCache();
    private final TaskCache taskCache = new TaskCache();

    public SnowflakeSchema(@NotNull GenericDataSource dataSource, @Nullable GenericCatalog catalog, @NotNull String schemaName, @Nullable JDBCResultSet dbResult) {
        super(dataSource, catalog, schemaName);
        this.name = schemaName;
        if (dbResult != null) {
            this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCHEMA_OWNER");
            this.retentionTime = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"RETENTION_TIME");
            this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
            this.lastAltered = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_ALTERED");
            this.isTransient = CommonUtils.notEmpty((String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"IS_TRANSIENT")).equals("YES");
            this.isManagedAccess = CommonUtils.notEmpty((String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"IS_MANAGED_ACCESS")).equals("YES");
            this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COMMENT");
        }
        this.uniqueConstraintCache = new UniqueConstraintCache();
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Property(viewable=true, order=3)
    @Nullable
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=true, updatable=true, order=4)
    public long getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(long retentionTime) {
        this.retentionTime = retentionTime;
    }

    @Property(viewable=true, order=5)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=true, order=6)
    public Date getLastAltered() {
        return this.lastAltered;
    }

    @Property(viewable=true, order=7)
    public boolean isTransient() {
        return this.isTransient;
    }

    @Property(viewable=true, updatable=true, order=8)
    public boolean isManagedAccess() {
        return this.isManagedAccess;
    }

    public void setManagedAccess(boolean managedAccess) {
        this.isManagedAccess = managedAccess;
    }

    @Property(viewable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Association
    public Collection<SnowflakeUniqueKey> getUniqueKeys(DBRProgressMonitor monitor) throws DBException {
        return this.uniqueConstraintCache.getAllObjects(monitor, (DBSObject)this);
    }

    public UniqueConstraintCache getUniqueConstraintCache() {
        return this.uniqueConstraintCache;
    }

    public StageCache getStageCache() {
        return this.stageCache;
    }

    public PipeCache getPipeCache() {
        return this.pipeCache;
    }

    public StreamCache getStreamCache() {
        return this.streamCache;
    }

    public TaskCache getTaskCache() {
        return this.taskCache;
    }

    public List<? extends GenericView> getViews(DBRProgressMonitor monitor) throws DBException {
        return this.getTableCache().getTypedObjects(monitor, (DBSObject)this, SnowflakeView.class);
    }

    @Association
    public SnowflakeView getView(@NotNull DBRProgressMonitor monitor, String stageName) throws DBException {
        return (SnowflakeView)((Object)this.getTableCache().getObject(monitor, (DBSObject)this, stageName, SnowflakeView.class));
    }

    @Association
    public Collection<SnowflakeMaterializedView> getMaterializedViews(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getTableCache().getTypedObjects(monitor, (DBSObject)this, SnowflakeMaterializedView.class);
    }

    @Association
    public SnowflakeMaterializedView getMaterializedView(@NotNull DBRProgressMonitor monitor, String stageName) throws DBException {
        return (SnowflakeMaterializedView)((Object)this.getTableCache().getObject(monitor, (DBSObject)this, stageName, SnowflakeMaterializedView.class));
    }

    @Association
    public Collection<SnowflakeStage> getStages(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.stageCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public SnowflakeStage getStage(@NotNull DBRProgressMonitor monitor, String stageName) throws DBException {
        return (SnowflakeStage)this.stageCache.getObject(monitor, (DBSObject)this, stageName);
    }

    @Association
    public Collection<SnowflakePipe> getPipes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.pipeCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public SnowflakePipe getPipe(@NotNull DBRProgressMonitor monitor, String pipeName) throws DBException {
        return (SnowflakePipe)this.pipeCache.getObject(monitor, (DBSObject)this, pipeName);
    }

    @Association
    public Collection<SnowflakeStream> getStreams(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.streamCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public SnowflakeStream getStream(@NotNull DBRProgressMonitor monitor, String streamName) throws DBException {
        return (SnowflakeStream)this.streamCache.getObject(monitor, (DBSObject)this, streamName);
    }

    @Association
    public Collection<SnowflakeTask> getTasks(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.taskCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public SnowflakeTask getTask(@NotNull DBRProgressMonitor monitor, String taskName) throws DBException {
        return (SnowflakeTask)this.taskCache.getObject(monitor, (DBSObject)this, taskName);
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.uniqueConstraintCache.clearCache();
        this.stageCache.clearCache();
        this.pipeCache.clearCache();
        this.streamCache.clearCache();
        this.taskCache.clearCache();
        return super.refreshObject(monitor);
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getCatalog(), this});
    }

    public class PipeCache
    extends JDBCObjectLookupCache<SnowflakeSchema, SnowflakePipe> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull SnowflakeSchema snowflakeSchema, @Nullable SnowflakePipe object, @Nullable String objectName) throws SQLException {
            GenericCatalog catalog = snowflakeSchema.getCatalog();
            String sql = "SELECT * FROM " + (String)(catalog != null ? DBUtils.getQuotedIdentifier((DBSObject)catalog) + "." : "") + "INFORMATION_SCHEMA.PIPES \nWHERE PIPE_SCHEMA = ?" + (object != null || objectName != null ? "\nAND PIPE_NAME = ?" : "") + "\nORDER BY PIPE_NAME";
            JDBCPreparedStatement statement = session.prepareStatement(sql);
            statement.setString(1, snowflakeSchema.getName());
            if (object != null || objectName != null) {
                statement.setString(2, object != null ? object.getName() : objectName);
            }
            return statement;
        }

        @Nullable
        protected SnowflakePipe fetchObject(@NotNull JDBCSession session, @NotNull SnowflakeSchema snowflakeSchema, @NotNull JDBCResultSet resultSet) {
            String pipeName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PIPE_NAME");
            if (CommonUtils.isNotEmpty((String)pipeName)) {
                return new SnowflakePipe(snowflakeSchema, pipeName, resultSet);
            }
            return null;
        }
    }

    public class StageCache
    extends JDBCObjectLookupCache<SnowflakeSchema, SnowflakeStage> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull SnowflakeSchema snowflakeSchema, @Nullable SnowflakeStage object, @Nullable String objectName) throws SQLException {
            GenericCatalog catalog = snowflakeSchema.getCatalog();
            String sql = "SELECT * FROM " + (String)(catalog != null ? DBUtils.getQuotedIdentifier((DBSObject)catalog) + "." : "") + "INFORMATION_SCHEMA.STAGES \nWHERE STAGE_SCHEMA = ?" + (object != null || objectName != null ? "\nAND STAGE_NAME = ?" : "") + "\nORDER BY STAGE_NAME";
            JDBCPreparedStatement statement = session.prepareStatement(sql);
            statement.setString(1, snowflakeSchema.getName());
            if (object != null || objectName != null) {
                statement.setString(2, object != null ? object.getName() : objectName);
            }
            return statement;
        }

        @Nullable
        protected SnowflakeStage fetchObject(@NotNull JDBCSession session, @NotNull SnowflakeSchema snowflakeSchema, @NotNull JDBCResultSet resultSet) {
            String stageName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"STAGE_NAME");
            if (CommonUtils.isNotEmpty((String)stageName)) {
                return new SnowflakeStage(snowflakeSchema, stageName, resultSet);
            }
            return null;
        }
    }

    public class StreamCache
    extends JDBCObjectLookupCache<SnowflakeSchema, SnowflakeStream> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull SnowflakeSchema snowflakeSchema, @Nullable SnowflakeStream object, @Nullable String objectName) throws SQLException {
            GenericCatalog catalog = snowflakeSchema.getCatalog();
            String sql = "SHOW STREAMS " + (object != null || objectName != null ? "LIKE ?" : "") + " IN " + (String)(catalog != null ? DBUtils.getQuotedIdentifier((DBSObject)catalog) + "." : "") + DBUtils.getQuotedIdentifier((DBSObject)snowflakeSchema);
            JDBCPreparedStatement statement = session.prepareStatement(sql);
            if (object != null || objectName != null) {
                statement.setString(1, object != null ? object.getName() : objectName);
            }
            return statement;
        }

        @Nullable
        protected SnowflakeStream fetchObject(@NotNull JDBCSession session, @NotNull SnowflakeSchema snowflakeSchema, @NotNull JDBCResultSet resultSet) {
            String name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"name");
            if (CommonUtils.isNotEmpty((String)name)) {
                return new SnowflakeStream(snowflakeSchema, name, resultSet);
            }
            return null;
        }
    }

    public class TaskCache
    extends JDBCObjectLookupCache<SnowflakeSchema, SnowflakeTask> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull SnowflakeSchema snowflakeSchema, @Nullable SnowflakeTask object, @Nullable String objectName) throws SQLException {
            GenericCatalog catalog = snowflakeSchema.getCatalog();
            String sql = "SHOW TASKS " + (object != null || objectName != null ? "LIKE ?" : "") + " IN " + (String)(catalog != null ? DBUtils.getQuotedIdentifier((DBSObject)catalog) + "." : "") + DBUtils.getQuotedIdentifier((DBSObject)snowflakeSchema);
            JDBCPreparedStatement statement = session.prepareStatement(sql);
            if (object != null || objectName != null) {
                statement.setString(1, object != null ? object.getName() : objectName);
            }
            return statement;
        }

        @Nullable
        protected SnowflakeTask fetchObject(@NotNull JDBCSession session, @NotNull SnowflakeSchema snowflakeSchema, @NotNull JDBCResultSet resultSet) {
            String name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"name");
            if (CommonUtils.isNotEmpty((String)name)) {
                return new SnowflakeTask(snowflakeSchema, name, resultSet);
            }
            return null;
        }
    }

    public class UniqueConstraintCache
    extends JDBCCompositeCache<GenericStructContainer, SnowflakeTable, SnowflakeUniqueKey, GenericTableConstraintColumn> {
        UniqueConstraintCache() {
            super((JDBCStructCache)SnowflakeSchema.this.getTableCache(), SnowflakeTable.class, (Object)"table_name", (Object)"constraint_name");
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(JDBCSession session, GenericStructContainer snowflakeSchema, SnowflakeTable forParent) throws SQLException {
            Object sql = "SHOW UNIQUE KEYS IN ";
            sql = forParent != null ? (String)sql + "TABLE " + forParent.getFullyQualifiedName(DBPEvaluationContext.DDL) : (String)sql + "SCHEMA " + DBUtils.getObjectFullName((DBPNamedObject)snowflakeSchema, (DBPEvaluationContext)DBPEvaluationContext.DDL);
            return session.prepareStatement((String)sql);
        }

        @Nullable
        protected SnowflakeUniqueKey fetchObject(JDBCSession session, GenericStructContainer snowflakeSchema, SnowflakeTable snowflakeTable, String childName, JDBCResultSet resultSet) throws SQLException, DBException {
            String description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"comment");
            return new SnowflakeUniqueKey((GenericTableBase)snowflakeTable, false, childName, description, true);
        }

        @Nullable
        protected GenericTableConstraintColumn[] fetchObjectRow(JDBCSession session, SnowflakeTable snowflakeTable, SnowflakeUniqueKey forObject, JDBCResultSet resultSet) throws SQLException, DBException {
            String columnName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"column_name");
            if (CommonUtils.isEmpty((String)columnName)) {
                log.debug((Object)("Can't find constraint table column name for " + forObject.getName()));
                return null;
            }
            GenericTableColumn tableColumn = snowflakeTable.getAttribute(session.getProgressMonitor(), columnName);
            if (tableColumn == null) {
                log.debug((Object)("Can't find constraint table column for " + forObject.getName()));
                return null;
            }
            int keySeq = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"key_sequence");
            return new GenericTableConstraintColumn[]{new GenericTableConstraintColumn((JDBCTableConstraint)forObject, tableColumn, keySeq)};
        }

        protected void cacheChildren(DBRProgressMonitor monitor, SnowflakeUniqueKey object, List<GenericTableConstraintColumn> children) {
            object.setAttributeReferences(children);
        }
    }
}

