/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model;

import com.dbeaver.db.snowflake.model.SnowflakeTable;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataBulkLoader;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.csv.CSVWriter;

public class SnowflakeBulkLoader
implements DBSDataBulkLoader {
    private static final Log log = Log.getLog(SnowflakeBulkLoader.class);

    @NotNull
    public DBSDataBulkLoader.BulkLoadManager createBulkLoad(@NotNull DBCSession session, @NotNull DBSDataContainer dataContainer, @NotNull DBSAttributeBase[] attributes, @NotNull DBCExecutionSource source, int batchSize, Map<String, Object> options) throws DBCException {
        try {
            return new BulkCopyLoader(session, (SnowflakeTable)dataContainer, attributes);
        }
        catch (IOException | DBException e) {
            throw new DBCException("Unable to create loader", e);
        }
    }

    private static class BulkCopyLoader
    implements DBSDataBulkLoader.BulkLoadManager {
        private final SnowflakeTable table;
        private final Path path;
        private final CSVWriter writer;
        private final AttributeMapping[] mappings;

        public BulkCopyLoader(@NotNull DBCSession session, @NotNull SnowflakeTable table, @NotNull DBSAttributeBase[] attributes) throws DBException, IOException {
            this.table = table;
            this.path = this.getTempFile(session.getProgressMonitor());
            this.writer = new CSVWriter((Writer)Files.newBufferedWriter(this.path, new OpenOption[0]));
            this.mappings = (AttributeMapping[])Arrays.stream(attributes).filter(attr -> attr.getOrdinalPosition() >= 0).map(attr -> new AttributeMapping((DBSAttributeBase)attr, DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)attr), ArrayUtils.indexOf((Object[])attributes, (Object)attr))).toArray(AttributeMapping[]::new);
        }

        public void addRow(@NotNull DBCSession session, @NotNull Object[] values) {
            String[] row = (String[])Arrays.stream(this.mappings).map(mapping -> mapping.getStringValue(values)).toArray(String[]::new);
            this.writer.writeNext(row);
        }

        public void flushRows(@NotNull DBCSession session) throws DBCException {
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                throw new DBCException("Error flushing rows", (Throwable)e);
            }
        }

        public void finishBulkLoad(@NotNull DBCSession session) throws DBCException {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new DBCException("Error closing writer", (Throwable)e);
            }
            String tableName = this.getTableName();
            String stageName = this.getStageName();
            String fileName = this.path.getFileName().toString();
            JDBCSession jdbcSession = (JDBCSession)session;
            try {
                Throwable throwable = null;
                Object var7_10 = null;
                try (JDBCStatement stmt = jdbcSession.createStatement();){
                    stmt.execute("CREATE OR REPLACE TEMPORARY STAGE " + stageName + " file_format = ( type='CSV' )");
                    Throwable throwable2 = null;
                    Object var10_15 = null;
                    try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(this.path, new OpenOption[0]));){
                        BeanUtils.invokeObjectMethod((Object)jdbcSession.getOriginal(), (String)"uploadStream", (Class[])new Class[]{String.class, String.class, InputStream.class, String.class, Boolean.TYPE}, (Object[])new Object[]{stageName, "", is, fileName, false});
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    stmt.execute("COPY INTO " + tableName + " FROM @" + stageName + "/" + fileName + " file_format = ( type='CSV', field_optionally_enclosed_by='\"' )");
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                throw new DBCException("Can't perform bulk load", e);
            }
        }

        public void close() {
            try {
                Files.delete(this.path);
            }
            catch (IOException e) {
                log.debug((Object)("Error deleting temporary file (" + String.valueOf(this.path) + ")"), (Throwable)e);
            }
        }

        @NotNull
        private String getStageName() {
            return DBUtils.getObjectFullName((DBPNamedObject)this.table.getSchema(), (DBPEvaluationContext)DBPEvaluationContext.DML) + ".COPYIN_STAGE";
        }

        @NotNull
        private String getTableName() {
            return this.table.getFullyQualifiedName(DBPEvaluationContext.DML);
        }

        @NotNull
        private Path getTempFile(@NotNull DBRProgressMonitor monitor) throws IOException {
            Path folder = DBWorkbench.getPlatform().getTempFolder(monitor, "snowflake-copy-stage");
            String name = CommonUtils.escapeFileName((String)this.getTableName()) + "-" + System.currentTimeMillis() + ".csv";
            return folder.resolve(name);
        }

        private static class AttributeMapping {
            private final DBSAttributeBase attribute;
            private final DBDValueHandler handler;
            private final int index;

            public AttributeMapping(@NotNull DBSAttributeBase attribute, @NotNull DBDValueHandler handler, int index) {
                this.attribute = attribute;
                this.handler = handler;
                this.index = index;
            }

            @Nullable
            public String getStringValue(@NotNull Object[] values) {
                Object value = values[this.index];
                if (DBUtils.isNullValue((Object)value)) {
                    return null;
                }
                return this.handler.getValueDisplayString((DBSTypedObject)this.attribute, value, DBDDisplayFormat.NATIVE);
            }
        }
    }
}

