/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.edit;

import com.dbeaver.db.snowflake.model.SnowflakeSequence;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.edit.GenericSequenceManager;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class SnowflakeSequenceManager
extends GenericSequenceManager
implements DBEObjectRenamer<GenericSequence> {
    public boolean canCreateObject(Object container) {
        return DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("metadata-editor");
    }

    protected GenericSequence createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        return new SnowflakeSequence((GenericStructContainer)container, this.getBaseObjectName().toLowerCase(Locale.ROOT));
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create sequence", ((SnowflakeSequence)command.getObject()).getObjectDefinitionText(monitor, options)));
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        GenericSequence sequence = (GenericSequence)command.getObject();
        if (command.hasProperty((Object)"incrementBy")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter sequence", "ALTER SEQUENCE " + sequence.getFullyQualifiedName(DBPEvaluationContext.DDL) + " SET INCREMENT BY = " + String.valueOf(sequence.getIncrementBy())));
        }
    }

    protected void addObjectExtraActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.NestedObjectCommand<GenericSequence, SQLObjectEditor.PropertyHandler> command, @NotNull Map<String, Object> options) {
        GenericSequence sequence = (GenericSequence)command.getObject();
        if (command.hasProperty((Object)"description")) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment sequence", "ALTER SEQUENCE " + sequence.getFullyQualifiedName(DBPEvaluationContext.DDL) + " SET COMMENT = " + SQLUtils.quoteString((DBSObject)sequence, (String)CommonUtils.notEmpty((String)sequence.getDescription()))));
        }
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericSequence object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        GenericSequence sequence = (GenericSequence)command.getObject();
        GenericDataSource dataSource = sequence.getDataSource();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename sequence", "ALTER SEQUENCE " + this.getFullSequenceName(sequence, DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getOldName())) + " RENAME TO " + this.getFullSequenceName(sequence, DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getNewName()))));
    }

    private String getFullSequenceName(@NotNull GenericSequence sequence, String sequenceName) {
        StringBuilder fullName = new StringBuilder(sequenceName);
        DBSObject schema = sequence.getParentObject();
        if (schema != null) {
            fullName.insert(0, DBUtils.getQuotedIdentifier((DBSObject)schema) + ".");
            DBSObject catalog = schema.getParentObject();
            if (catalog != null) {
                fullName.insert(0, DBUtils.getQuotedIdentifier((DBSObject)catalog) + ".");
            }
        }
        return fullName.toString();
    }
}

