/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.nio;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.nio.AzurePath;
import com.azure.storage.blob.nio.LoggingUtility;
import com.azure.storage.blob.specialized.BlobOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;

public final class NioBlobOutputStream
extends OutputStream {
    private static final ClientLogger LOGGER = new ClientLogger(NioBlobOutputStream.class);
    private final BlobOutputStream blobOutputStream;
    private final Path path;

    NioBlobOutputStream(BlobOutputStream blobOutputStream, Path path) {
        this.blobOutputStream = blobOutputStream;
        this.path = path;
    }

    @Override
    public synchronized void write(int i) throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        try {
            this.blobOutputStream.write(i);
        }
        catch (RuntimeException e) {
            throw LoggingUtility.logError(LOGGER, new IOException(e));
        }
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        try {
            this.blobOutputStream.write(b);
        }
        catch (RuntimeException e) {
            throw LoggingUtility.logError(LOGGER, new IOException(e));
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        try {
            this.blobOutputStream.write(b, off, len);
        }
        catch (RuntimeException e) {
            if (e instanceof IndexOutOfBoundsException) {
                throw LoggingUtility.logError(LOGGER, e);
            }
            throw LoggingUtility.logError(LOGGER, new IOException(e));
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        try {
            this.blobOutputStream.flush();
        }
        catch (RuntimeException e) {
            throw LoggingUtility.logError(LOGGER, new IOException(e));
        }
    }

    @Override
    public synchronized void close() throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        try {
            this.blobOutputStream.close();
        }
        catch (RuntimeException e) {
            throw LoggingUtility.logError(LOGGER, new IOException(e));
        }
    }
}

