/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.nio;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.nio.AzurePath;
import com.azure.storage.blob.nio.LoggingUtility;
import com.azure.storage.blob.nio.NioBlobInputStream;
import com.azure.storage.blob.nio.NioBlobOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;

public final class AzureSeekableByteChannel
implements SeekableByteChannel {
    private static final ClientLogger LOGGER = new ClientLogger(AzureSeekableByteChannel.class);
    private final NioBlobInputStream reader;
    private final NioBlobOutputStream writer;
    private long position;
    private boolean closed = false;
    private final Path path;

    AzureSeekableByteChannel(NioBlobInputStream inputStream, Path path) {
        this.reader = inputStream;
        inputStream.mark(Integer.MAX_VALUE);
        this.writer = null;
        this.position = 0L;
        this.path = path;
    }

    AzureSeekableByteChannel(NioBlobOutputStream outputStream, Path path) {
        this.writer = outputStream;
        this.reader = null;
        this.position = 0L;
        this.path = path;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int count;
        int byteCount;
        byte[] buf;
        int limit;
        int pos;
        AzurePath.ensureFileSystemOpen(this.path);
        this.validateOpen();
        this.validateReadMode();
        if (this.position >= this.size()) {
            return -1;
        }
        if (dst.hasArray()) {
            pos = dst.position();
            limit = pos + dst.remaining();
            buf = dst.array();
        } else {
            pos = 0;
            limit = dst.remaining();
            buf = new byte[limit];
        }
        while (pos < limit && (byteCount = this.reader.read(buf, pos, limit - pos)) != -1) {
            pos += byteCount;
        }
        if (dst.hasArray()) {
            count = pos - dst.position();
            dst.position(pos);
        } else {
            count = pos;
            dst.put(buf, 0, count);
        }
        this.position += (long)count;
        return count;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        byte[] buf;
        int pos;
        AzurePath.ensureFileSystemOpen(this.path);
        this.validateOpen();
        this.validateWriteMode();
        int length = src.remaining();
        this.position += (long)length;
        if (src.hasArray()) {
            pos = src.position();
            buf = src.array();
            src.position(pos + length);
        } else {
            pos = 0;
            buf = new byte[length];
            src.get(buf);
        }
        this.writer.write(buf, pos, length);
        return length;
    }

    @Override
    public long position() throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        this.validateOpen();
        return this.position;
    }

    @Override
    public AzureSeekableByteChannel position(long newPosition) throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        this.validateOpen();
        this.validateReadMode();
        if (newPosition < 0L) {
            throw LoggingUtility.logError(LOGGER, new IllegalArgumentException("Seek position cannot be negative"));
        }
        if (newPosition > this.size()) {
            this.position = newPosition;
            return this;
        }
        this.reader.reset();
        this.reader.mark(Integer.MAX_VALUE);
        long skipAmount = this.reader.skip(newPosition);
        if (skipAmount < newPosition) {
            throw new IOException("Could not set desired position");
        }
        this.position = newPosition;
        return this;
    }

    @Override
    public long size() throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        this.validateOpen();
        if (this.reader != null) {
            return this.reader.getBlobInputStream().getProperties().getBlobSize();
        }
        return this.position;
    }

    @Override
    public AzureSeekableByteChannel truncate(long size) throws IOException {
        throw LoggingUtility.logError(LOGGER, new UnsupportedOperationException());
    }

    @Override
    public boolean isOpen() {
        AzurePath.ensureFileSystemOpen(this.path);
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        if (this.reader != null) {
            this.reader.close();
        } else {
            this.writer.close();
        }
        this.closed = true;
    }

    Path getPath() {
        return this.path;
    }

    private void validateOpen() throws ClosedChannelException {
        if (this.closed) {
            throw LoggingUtility.logError(LOGGER, new ClosedChannelException());
        }
    }

    private void validateReadMode() {
        if (this.reader == null) {
            throw LoggingUtility.logError(LOGGER, new NonReadableChannelException());
        }
    }

    private void validateWriteMode() {
        if (this.writer == null) {
            throw LoggingUtility.logError(LOGGER, new NonWritableChannelException());
        }
    }
}

