/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.nio;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.SyncPoller;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.nio.AzureBasicFileAttributeView;
import com.azure.storage.blob.nio.AzureBasicFileAttributes;
import com.azure.storage.blob.nio.AzureBlobFileAttributeView;
import com.azure.storage.blob.nio.AzureBlobFileAttributes;
import com.azure.storage.blob.nio.AzureDirectoryStream;
import com.azure.storage.blob.nio.AzureFileSystem;
import com.azure.storage.blob.nio.AzurePath;
import com.azure.storage.blob.nio.AzureResource;
import com.azure.storage.blob.nio.AzureSeekableByteChannel;
import com.azure.storage.blob.nio.DirectoryStatus;
import com.azure.storage.blob.nio.LoggingUtility;
import com.azure.storage.blob.nio.NioBlobInputStream;
import com.azure.storage.blob.nio.NioBlobOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AzureFileSystemProvider
extends FileSystemProvider {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_MD5 = "Content-MD5";
    public static final String CACHE_CONTROL = "Cache-Control";
    private static final String ENDPOINT_QUERY_KEY = "endpoint";
    private static final int COPY_TIMEOUT_SECONDS = 30;
    private static final Set<OpenOption> OUTPUT_STREAM_DEFAULT_OPTIONS = Collections.unmodifiableSet(new HashSet<StandardOpenOption>(Arrays.asList(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING)));
    private static final Set<OpenOption> OUTPUT_STREAM_SUPPORTED_OPTIONS = Collections.unmodifiableSet(new HashSet<StandardOpenOption>(Arrays.asList(StandardOpenOption.CREATE_NEW, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING)));
    private final ConcurrentMap<String, FileSystem> openFileSystems = new ConcurrentHashMap<String, FileSystem>();

    @Override
    public String getScheme() {
        return "azb";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> config) throws IOException {
        String endpoint = this.extractAccountEndpoint(uri);
        if (this.openFileSystems.containsKey(endpoint)) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new FileSystemAlreadyExistsException("Name: " + endpoint));
        }
        AzureFileSystem afs = new AzureFileSystem(this, endpoint, config);
        this.openFileSystems.put(endpoint, afs);
        return afs;
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        String endpoint = this.extractAccountEndpoint(uri);
        if (!this.openFileSystems.containsKey(endpoint)) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new FileSystemNotFoundException("Name: " + endpoint));
        }
        return (FileSystem)this.openFileSystems.get(endpoint);
    }

    @Override
    public Path getPath(URI uri) {
        return this.getFileSystem(uri).getPath(uri.getPath(), new String[0]);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributes) throws IOException {
        if (Objects.isNull(set)) {
            set = Collections.emptySet();
        }
        if (set.contains(StandardOpenOption.WRITE)) {
            return new AzureSeekableByteChannel((NioBlobOutputStream)this.newOutputStreamInternal(path, set, fileAttributes), path);
        }
        return new AzureSeekableByteChannel((NioBlobInputStream)this.newInputStream(path, set.toArray(new OpenOption[0])), path);
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        if (options.length > 1 || options.length > 0 && !options[0].equals(StandardOpenOption.READ)) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new UnsupportedOperationException("Only the read option is supported."));
        }
        AzureResource resource = new AzureResource(path);
        AzurePath.ensureFileSystemOpen(resource.getPath());
        if (!resource.checkDirStatus().equals((Object)DirectoryStatus.NOT_A_DIRECTORY)) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IOException("Path either does not exist or points to a directory.Path must point to a file. Path: " + path.toString()));
        }
        return new NioBlobInputStream(resource.getBlobClient().openInputStream(), resource.getPath());
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        return this.newOutputStreamInternal(path, new HashSet<OpenOption>(Arrays.asList(options)), new FileAttribute[0]);
    }

    OutputStream newOutputStreamInternal(Path path, Set<? extends OpenOption> optionsSet, FileAttribute<?> ... fileAttributes) throws IOException {
        if (optionsSet == null || optionsSet.size() == 0) {
            optionsSet = OUTPUT_STREAM_DEFAULT_OPTIONS;
        }
        for (OpenOption openOption : optionsSet) {
            if (OUTPUT_STREAM_SUPPORTED_OPTIONS.contains(openOption)) continue;
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new UnsupportedOperationException("Unsupported option: " + openOption.toString()));
        }
        if (!optionsSet.contains(StandardOpenOption.WRITE) || !optionsSet.contains(StandardOpenOption.TRUNCATE_EXISTING) && !optionsSet.contains(StandardOpenOption.CREATE_NEW)) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IllegalArgumentException("Write and either CreateNew or TruncateExisting must be specified to open an OutputStream"));
        }
        AzureResource resource = new AzureResource(path);
        AzurePath.ensureFileSystemOpen(resource.getPath());
        DirectoryStatus directoryStatus = resource.checkDirStatus();
        if (DirectoryStatus.isDirectory(directoryStatus)) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IOException("Cannot open an OutputStream to a directory. Path: " + path.toString()));
        }
        if (directoryStatus.equals((Object)DirectoryStatus.DOES_NOT_EXIST) && !optionsSet.contains(StandardOpenOption.CREATE) && !optionsSet.contains(StandardOpenOption.CREATE_NEW)) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IOException("Writing to an empty location requires a create option. Path: " + path.toString()));
        }
        if (directoryStatus.equals((Object)DirectoryStatus.NOT_A_DIRECTORY) && optionsSet.contains(StandardOpenOption.CREATE_NEW)) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IOException("A file already exists at this location and CREATE_NEW was specified. Path: " + path.toString()));
        }
        AzureFileSystem fs = (AzureFileSystem)path.getFileSystem();
        Integer blockSize = fs.getBlockSize() == null ? null : Integer.valueOf(fs.getBlockSize().intValue());
        Integer putBlobThreshold = fs.getPutBlobThreshold() == null ? null : Integer.valueOf(fs.getPutBlobThreshold().intValue());
        ParallelTransferOptions pto = new ParallelTransferOptions(blockSize, fs.getMaxConcurrencyPerRequest(), null, putBlobThreshold);
        BlobRequestConditions rq = null;
        if (optionsSet.contains(StandardOpenOption.CREATE_NEW)) {
            rq = new BlobRequestConditions().setIfNoneMatch("*");
        }
        if (fileAttributes == null) {
            fileAttributes = new FileAttribute[]{};
        }
        resource.setFileAttributes(Arrays.asList(fileAttributes));
        return new NioBlobOutputStream(resource.getBlobOutputStream(pto, rq), resource.getPath());
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        if (!(path instanceof AzurePath)) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IllegalArgumentException("This provider cannot operate on subtypes of Path other than AzurePath"));
        }
        AzurePath.ensureFileSystemOpen(path);
        if (!((AzurePath)path).isRoot() && !new AzureResource(path).checkDirectoryExists()) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new NotDirectoryException(path.toString()));
        }
        return new AzureDirectoryStream((AzurePath)path, filter);
    }

    @Override
    public void createDirectory(Path path, FileAttribute<?> ... fileAttributes) throws IOException {
        fileAttributes = fileAttributes == null ? new FileAttribute[]{} : fileAttributes;
        AzureResource azureResource = new AzureResource(path);
        AzurePath.ensureFileSystemOpen(azureResource.getPath());
        if (azureResource.checkParentDirectoryExists()) {
            try {
                azureResource.setFileAttributes(Arrays.asList(fileAttributes)).putDirectoryBlob(new BlobRequestConditions().setIfNoneMatch("*"));
            }
            catch (BlobStorageException e) {
                if (e.getStatusCode() == 409 && e.getErrorCode().equals((Object)BlobErrorCode.BLOB_ALREADY_EXISTS)) {
                    throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new FileAlreadyExistsException(azureResource.getPath().toString()));
                }
                throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IOException("An error occurred when creating the directory", e));
            }
        } else {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IOException("Parent directory does not exist for path: " + azureResource.getPath()));
        }
    }

    @Override
    public void delete(Path path) throws IOException {
        AzureResource azureResource = new AzureResource(path);
        AzurePath.ensureFileSystemOpen(azureResource.getPath());
        DirectoryStatus dirStatus = azureResource.checkDirStatus();
        if (dirStatus.equals((Object)DirectoryStatus.DOES_NOT_EXIST)) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new NoSuchFileException(path.toString()));
        }
        if (dirStatus.equals((Object)DirectoryStatus.NOT_EMPTY)) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new DirectoryNotEmptyException(path.toString()));
        }
        try {
            azureResource.getBlobClient().delete();
        }
        catch (BlobStorageException e) {
            if (e.getErrorCode().equals((Object)BlobErrorCode.BLOB_NOT_FOUND)) {
                throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new NoSuchFileException(path.toString()));
            }
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IOException(e));
        }
    }

    @Override
    public void copy(Path source, Path destination, CopyOption ... copyOptions) throws IOException {
        if (source.equals(destination)) {
            return;
        }
        boolean replaceExisting = false;
        ArrayList<CopyOption> optionsList = new ArrayList<CopyOption>(Arrays.asList(copyOptions));
        if (!optionsList.contains(StandardCopyOption.COPY_ATTRIBUTES)) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new UnsupportedOperationException("StandardCopyOption.COPY_ATTRIBUTES must be specified as the service will always copy file attributes."));
        }
        optionsList.remove(StandardCopyOption.COPY_ATTRIBUTES);
        if (optionsList.contains(StandardCopyOption.REPLACE_EXISTING)) {
            replaceExisting = true;
            optionsList.remove(StandardCopyOption.REPLACE_EXISTING);
        }
        if (!optionsList.isEmpty()) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new UnsupportedOperationException("Unsupported copy option found. Only StandardCopyOption.COPY_ATTRIBUTES and StandardCopyOption.REPLACE_EXISTING are supported."));
        }
        AzureResource sourceRes = new AzureResource(source);
        AzurePath.ensureFileSystemOpen(sourceRes.getPath());
        AzureResource destinationRes = new AzureResource(destination);
        AzurePath.ensureFileSystemOpen(destinationRes.getPath());
        DirectoryStatus destinationStatus = destinationRes.checkDirStatus();
        if (destinationStatus.equals((Object)DirectoryStatus.NOT_EMPTY)) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new DirectoryNotEmptyException(destination.toString()));
        }
        BlobRequestConditions requestConditions = null;
        if (!replaceExisting) {
            if (!destinationStatus.equals((Object)DirectoryStatus.DOES_NOT_EXIST)) {
                throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new FileAlreadyExistsException(destinationRes.getPath().toString()));
            }
            requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
        }
        if (destinationStatus.equals((Object)DirectoryStatus.DOES_NOT_EXIST) && !destinationRes.checkParentDirectoryExists()) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IOException("Parent directory of destination location does not exist. The destination path is therefore invalid. Destination: " + destinationRes.getPath()));
        }
        try {
            SyncPoller pollResponse = destinationRes.getBlobClient().beginCopy(sourceRes.getBlobClient().getBlobUrl(), null, null, null, null, requestConditions, null);
            pollResponse.waitForCompletion(Duration.ofSeconds(30L));
        }
        catch (BlobStorageException e) {
            if (e.getErrorCode().equals((Object)BlobErrorCode.BLOB_NOT_FOUND) && !sourceRes.checkDirStatus().equals((Object)DirectoryStatus.DOES_NOT_EXIST)) {
                destinationRes.putDirectoryBlob(requestConditions);
            }
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IOException(e));
        }
        catch (RuntimeException e) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IOException(e));
        }
    }

    @Override
    public void move(Path path, Path path1, CopyOption ... copyOptions) throws IOException {
        throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new UnsupportedOperationException());
    }

    @Override
    public boolean isSameFile(Path path, Path path1) throws IOException {
        throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new UnsupportedOperationException());
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new UnsupportedOperationException());
    }

    @Override
    public void checkAccess(Path path, AccessMode ... accessModes) throws IOException {
        if (accessModes != null && accessModes.length != 0) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new AccessDeniedException("The access cannot be determined."));
        }
        AzurePath.ensureFileSystemOpen(path);
        if (path instanceof AzurePath && ((AzurePath)path).isRoot()) {
            return;
        }
        try {
            this.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof BlobStorageException && BlobErrorCode.BLOB_NOT_FOUND.equals((Object)((BlobStorageException)cause).getErrorCode())) {
                throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new NoSuchFileException(path.toString()));
            }
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, e);
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... linkOptions) {
        if (type == BasicFileAttributeView.class || type == AzureBasicFileAttributeView.class) {
            return (V)new AzureBasicFileAttributeView(path);
        }
        if (type == AzureBlobFileAttributeView.class) {
            return (V)new AzureBlobFileAttributeView(path);
        }
        return null;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... linkOptions) throws IOException {
        Class view;
        AzurePath.ensureFileSystemOpen(path);
        if (type == BasicFileAttributes.class || type == AzureBasicFileAttributes.class) {
            view = AzureBasicFileAttributeView.class;
        } else if (type == AzureBlobFileAttributes.class) {
            view = AzureBlobFileAttributeView.class;
        } else {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new UnsupportedOperationException());
        }
        return (A)((BasicFileAttributeView)this.getFileAttributeView(path, view, linkOptions)).readAttributes();
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... linkOptions) throws IOException {
        String attributeList;
        String viewType;
        if (attributes == null) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IllegalArgumentException("Attribute string cannot be null."));
        }
        AzurePath.ensureFileSystemOpen(path);
        HashMap<String, Object> results = new HashMap<String, Object>();
        Map<String, Supplier<Object>> attributeSuppliers = null;
        String[] parts = attributes.split(":");
        if (parts.length > 2) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IllegalArgumentException("Invalid format for attribute string: " + attributes));
        }
        if (parts.length == 1) {
            viewType = "basic";
            attributeList = attributes;
        } else {
            viewType = parts[0];
            attributeList = parts[1];
        }
        if ("basic".equals(viewType)) {
            viewType = "azureBasic";
        }
        if (!viewType.equals("azureBasic") && !viewType.equals("azureBlob")) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new UnsupportedOperationException("Invalid attribute view: " + viewType));
        }
        for (String attributeName : attributeList.split(",")) {
            if (viewType.equals("azureBasic") && !AzureBasicFileAttributes.ATTRIBUTE_STRINGS.contains(attributeName) && !"*".equals(attributeName)) {
                throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IllegalArgumentException("Invalid attribute. View: " + viewType + ". Attribute: " + attributeName));
            }
            if (attributeSuppliers == null) {
                attributeSuppliers = AzureBlobFileAttributes.getAttributeSuppliers(this.readAttributes(path, AzureBlobFileAttributes.class, linkOptions));
            }
            if ("*".equals(attributeName)) {
                if (viewType.equals("azureBasic")) {
                    for (String string : AzureBasicFileAttributes.ATTRIBUTE_STRINGS) {
                        results.put(string, attributeSuppliers.get(string).get());
                    }
                    continue;
                }
                for (Map.Entry entry : attributeSuppliers.entrySet()) {
                    results.put((String)entry.getKey(), ((Supplier)entry.getValue()).get());
                }
                continue;
            }
            if (!attributeSuppliers.containsKey(attributeName)) {
                throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IllegalArgumentException("Invalid attribute. View: " + viewType + ". Attribute: " + attributeName));
            }
            results.put(attributeName, attributeSuppliers.get(attributeName).get());
        }
        if (results.isEmpty()) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IllegalArgumentException("No attributes were specified. Attributes: " + attributes));
        }
        return results;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAttribute(Path path, String attributes, Object value, LinkOption ... linkOptions) throws IOException {
        String attributeName;
        String viewType;
        AzurePath.ensureFileSystemOpen(path);
        String[] parts = attributes.split(":");
        if (parts.length > 2) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IllegalArgumentException("Invalid format for attribute string: " + attributes));
        }
        if (parts.length == 1) {
            viewType = "basic";
            attributeName = attributes;
        } else {
            viewType = parts[0];
            attributeName = parts[1];
        }
        if ("basic".equals(viewType)) {
            viewType = "azureBasic";
        }
        if (viewType.equals("azureBasic")) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IllegalArgumentException("Invalid attribute. View: " + viewType + ". Attribute: " + attributeName));
        }
        if (!viewType.equals("azureBlob")) throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new UnsupportedOperationException("Invalid attribute view: " + viewType));
        Map<String, Consumer<Object>> attributeConsumers = AzureBlobFileAttributeView.setAttributeConsumers(this.getFileAttributeView(path, AzureBlobFileAttributeView.class, linkOptions));
        if (!attributeConsumers.containsKey(attributeName)) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IllegalArgumentException("Invalid attribute. View: " + viewType + ". Attribute: " + attributeName));
        }
        try {
            attributeConsumers.get(attributeName).accept(value);
            return;
        }
        catch (UncheckedIOException e) {
            if (!e.getMessage().equals("Exception thrown by attribute consumer")) return;
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, e.getCause());
        }
    }

    void closeFileSystem(String fileSystemName) {
        this.openFileSystems.remove(fileSystemName);
    }

    private String extractAccountEndpoint(URI uri) {
        if (!uri.getScheme().equals(this.getScheme())) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IllegalArgumentException("URI scheme does not match this provider"));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)uri.getQuery())) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IllegalArgumentException("URI does not contain a query component. FileSystems require a URI of the format \"azb://?endpoint=<account_endpoint>\"."));
        }
        String endpoint = (String)Flux.fromArray((Object[])uri.getQuery().split("&")).filter(s -> s.startsWith("endpoint=")).switchIfEmpty((Publisher)Mono.defer(() -> Mono.error((Throwable)LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IllegalArgumentException("URI does not contain an \"endpoint=\" parameter. FileSystems require a URI of the format \"azb://?endpoint=<endpoint>\""))))).map(s -> s.substring(ENDPOINT_QUERY_KEY.length() + 1)).blockLast();
        if (CoreUtils.isNullOrEmpty((CharSequence)endpoint)) {
            throw LoggingUtility.logError(ClientLoggerHolder.LOGGER, new IllegalArgumentException("No account endpoint provided in URI query."));
        }
        return endpoint;
    }

    private static final class ClientLoggerHolder {
        private static final ClientLogger LOGGER = new ClientLogger(AzureFileSystemProvider.class);

        private ClientLoggerHolder() {
        }
    }
}

