/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.nio;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobListDetails;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.nio.AzureFileStore;
import com.azure.storage.blob.nio.AzureFileSystem;
import com.azure.storage.blob.nio.AzurePath;
import com.azure.storage.blob.nio.AzureResource;
import com.azure.storage.blob.nio.LoggingUtility;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class AzureDirectoryStream
implements DirectoryStream<Path> {
    private static final ClientLogger LOGGER = new ClientLogger(AzureDirectoryStream.class);
    private final AzurePath path;
    private final DirectoryStream.Filter<? super Path> filter;
    private boolean iteratorRequested = false;
    private final AzureDirectoryIterator iterator;
    boolean closed = false;

    AzureDirectoryStream(AzurePath path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        this.path = path;
        this.filter = filter;
        this.iterator = new AzureDirectoryIterator(this, this.path, this.filter);
    }

    @Override
    public Iterator<Path> iterator() {
        if (this.iteratorRequested) {
            throw LoggingUtility.logError(LOGGER, new IllegalStateException("Only one iterator may be requested from a given directory stream"));
        }
        this.iteratorRequested = true;
        return this.iterator;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    private static class AzureDirectoryIterator
    implements Iterator<Path> {
        private static final ClientLogger LOGGER = new ClientLogger(AzureDirectoryIterator.class);
        private final AzureDirectoryStream parentStream;
        private final DirectoryStream.Filter<? super Path> filter;
        private final Iterator<BlobItem> blobIterator;
        private final AzurePath path;
        private final Path withoutRoot;
        private Path bufferedNext = null;
        private final Set<String> directoryPaths;

        AzureDirectoryIterator(AzureDirectoryStream parentStream, AzurePath path, DirectoryStream.Filter<? super Path> filter) throws IOException {
            BlobContainerClient containerClient;
            this.parentStream = parentStream;
            this.filter = filter;
            this.path = path;
            Path root = this.path.getRoot();
            this.withoutRoot = root == null ? this.path : root.relativize(this.path);
            this.directoryPaths = new HashSet<String>();
            ListBlobsOptions listOptions = new ListBlobsOptions().setDetails(new BlobListDetails().setRetrieveMetadata(true));
            if (path.isRoot()) {
                String containerName = path.toString().substring(0, path.toString().length() - 1);
                AzureFileSystem afs = (AzureFileSystem)path.getFileSystem();
                containerClient = ((AzureFileStore)afs.getFileStore(containerName)).getContainerClient();
            } else {
                AzureResource azureResource = new AzureResource(path);
                listOptions.setPrefix(azureResource.getBlobClient().getBlobName() + "/");
                containerClient = azureResource.getContainerClient();
            }
            this.blobIterator = containerClient.listBlobsByHierarchy("/", listOptions, null).iterator();
        }

        @Override
        public boolean hasNext() {
            AzurePath.ensureFileSystemOpen(this.path);
            if (this.parentStream.closed) {
                return false;
            }
            if (this.bufferedNext != null) {
                return true;
            }
            while (this.blobIterator.hasNext()) {
                BlobItem nextBlob = this.blobIterator.next();
                Path nextPath = this.getNextListResult(nextBlob);
                try {
                    if (!this.filter.accept(nextPath) || !this.isNotDuplicate(nextPath, nextBlob)) continue;
                    this.bufferedNext = nextPath;
                    return true;
                }
                catch (IOException e) {
                    throw LoggingUtility.logError(LOGGER, new DirectoryIteratorException(e));
                }
            }
            return false;
        }

        @Override
        public Path next() {
            if (this.bufferedNext == null && !this.hasNext()) {
                throw LoggingUtility.logError(LOGGER, new NoSuchElementException());
            }
            Path next = this.bufferedNext;
            this.bufferedNext = null;
            return next;
        }

        @Override
        public void remove() {
            throw LoggingUtility.logError(LOGGER, new UnsupportedOperationException());
        }

        private Path getNextListResult(BlobItem blobItem) {
            String blobName = blobItem.getName();
            Path relativeResult = this.withoutRoot.relativize(this.path.getFileSystem().getPath(blobName, new String[0]));
            return this.path.resolve(relativeResult);
        }

        private boolean isNotDuplicate(Path path, BlobItem blob) {
            if (!(blob.isPrefix() != null && blob.isPrefix().booleanValue() || blob.getMetadata() != null && blob.getMetadata().containsKey("hdi_isfolder"))) {
                return true;
            }
            if (this.directoryPaths.contains(path.toString())) {
                return false;
            }
            this.directoryPaths.add(path.toString());
            return true;
        }
    }
}

