/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.nio;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.nio.AzureBlobFileAttributes;
import com.azure.storage.blob.nio.AzurePath;
import com.azure.storage.blob.nio.AzureResource;
import com.azure.storage.blob.nio.LoggingUtility;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public final class AzureBlobFileAttributeView
implements BasicFileAttributeView {
    private static final ClientLogger LOGGER = new ClientLogger(AzureBlobFileAttributeView.class);
    static final String ATTR_CONSUMER_ERROR = "Exception thrown by attribute consumer";
    static final String NAME = "azureBlob";
    private final Path path;

    AzureBlobFileAttributeView(Path path) {
        this.path = path;
    }

    static Map<String, Consumer<Object>> setAttributeConsumers(AzureBlobFileAttributeView view) {
        HashMap<String, Consumer<Object>> map = new HashMap<String, Consumer<Object>>();
        map.put("blobHttpHeaders", obj -> {
            try {
                view.setBlobHttpHeaders((BlobHttpHeaders)obj);
            }
            catch (IOException e) {
                throw LoggingUtility.logError(LOGGER, new UncheckedIOException(ATTR_CONSUMER_ERROR, e));
            }
        });
        map.put("metadata", obj -> {
            try {
                Map m = (Map)obj;
                if (m == null) {
                    throw LoggingUtility.logError(LOGGER, new ClassCastException());
                }
                view.setMetadata(m);
            }
            catch (IOException e) {
                throw LoggingUtility.logError(LOGGER, new UncheckedIOException(ATTR_CONSUMER_ERROR, e));
            }
        });
        map.put("tier", obj -> {
            try {
                view.setTier((AccessTier)obj);
            }
            catch (IOException e) {
                throw LoggingUtility.logError(LOGGER, new UncheckedIOException(ATTR_CONSUMER_ERROR, e));
            }
        });
        return map;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public AzureBlobFileAttributes readAttributes() throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        return new AzureBlobFileAttributes(this.path);
    }

    public void setBlobHttpHeaders(BlobHttpHeaders headers) throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        try {
            new AzureResource(this.path).getBlobClient().setHttpHeaders(headers);
        }
        catch (BlobStorageException e) {
            throw LoggingUtility.logError(LOGGER, new IOException(e));
        }
    }

    public void setMetadata(Map<String, String> metadata) throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        try {
            new AzureResource(this.path).getBlobClient().setMetadata(metadata);
        }
        catch (BlobStorageException e) {
            throw LoggingUtility.logError(LOGGER, new IOException(e));
        }
    }

    public void setTier(AccessTier tier) throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        try {
            new AzureResource(this.path).getBlobClient().setAccessTier(tier);
        }
        catch (BlobStorageException e) {
            throw LoggingUtility.logError(LOGGER, new IOException(e));
        }
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        throw LoggingUtility.logError(LOGGER, new UnsupportedOperationException());
    }
}

