/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDCursor;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCResultSetImpl;
import org.jkiss.utils.CommonUtils;

public class JDBCCursor
implements DBDCursor {
    private static final Log log = Log.getLog(JDBCCursor.class);
    private JDBCSession session;
    private JDBCResultSet resultSet;
    private String cursorName;
    private boolean closeResultsOnRelease = true;

    public JDBCCursor(JDBCSession session, ResultSet resultSet, String description) throws SQLException {
        this.session = session;
        this.resultSet = JDBCResultSetImpl.makeResultSet(session, null, resultSet, description, true);
    }

    public Object getRawValue() {
        return this.resultSet;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isModified() {
        return false;
    }

    public void release() {
        if (this.resultSet != null) {
            if (this.closeResultsOnRelease) {
                try {
                    this.resultSet.close();
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
            this.resultSet = null;
        }
    }

    @NotNull
    public DBCResultSet openResultSet(@NotNull DBCSession session) throws DBCException {
        if (this.resultSet != null) {
            try {
                this.resultSet.absolute(1);
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)this.resultSet.getSession().getExecutionContext());
            }
        }
        return this.resultSet;
    }

    @Nullable
    public String getCursorName() {
        return this.cursorName;
    }

    public void setCursorName(String cursorName) {
        this.cursorName = cursorName;
    }

    public void setCloseResultsOnRelease(boolean closeResultsOnRelease) {
        this.closeResultsOnRelease = closeResultsOnRelease;
    }

    public String toString() {
        if (this.cursorName != null) {
            return this.cursorName;
        }
        if (this.resultSet == null) {
            return "[NULL]";
        }
        return CommonUtils.toString((Object)this.resultSet.getSourceStatement().getQueryString());
    }
}

