/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.cache.DBSStructCache;
import org.jkiss.dbeaver.model.struct.cache.SimpleObjectCache;

public abstract class JDBCStructCache<OWNER extends DBSObject, OBJECT extends DBSObject, CHILD extends DBSObject>
extends JDBCObjectCache<OWNER, OBJECT>
implements DBSStructCache<OWNER, OBJECT, CHILD> {
    private static final Log log = Log.getLog(JDBCStructCache.class);
    private final Object objectNameColumn;
    private volatile boolean childrenCached = false;
    private final Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> childrenCache = new IdentityHashMap<OBJECT, SimpleObjectCache<OBJECT, CHILD>>();

    protected abstract JDBCStatement prepareChildrenStatement(@NotNull JDBCSession var1, @NotNull OWNER var2, @Nullable OBJECT var3) throws SQLException;

    protected abstract CHILD fetchChild(@NotNull JDBCSession var1, @NotNull OWNER var2, @NotNull OBJECT var3, @NotNull JDBCResultSet var4) throws SQLException, DBException;

    protected JDBCStructCache(Object objectNameColumn) {
        this.objectNameColumn = objectNameColumn;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void loadChildren(DBRProgressMonitor monitor, OWNER owner, @Nullable OBJECT forObject) throws DBException {
        if (forObject == null) {
            if (this.childrenCached != false) return;
        }
        if (forObject != null) {
            if (forObject.isPersisted() == false) return;
            if (this.isChildrenCached(forObject) != false) return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (forObject == null) {
            super.loadObjects(monitor, owner);
        }
        if ((dataSource = owner.getDataSource()) == null) {
            throw new DBException(ModelMessages.error_not_connected_to_database);
        }
        try {
            var5_5 = null;
            var6_8 = null;
            try {
                block45: {
                    block44: {
                        session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, owner, (String)"Load child objects");
                        objectMap = new HashMap<OBJECT, ArrayList<CHILD>>();
                        var9_12 = null;
                        var10_14 = null;
                        try {
                            dbStat = this.prepareChildrenStatement(session, owner, forObject);
                            try {
                                dbStat.setFetchSize(1000);
                                dbStat.executeStatement();
                                dbResult = dbStat.getResultSet();
                                if (dbResult == null) return;
                                ** GOTO lbl35
                            }
                            catch (Throwable var9_13) {
                                throw var9_13;
lbl35:
                                // 1 sources

                                if (true) ** GOTO lbl61
                            }
                        }
                        catch (Throwable var10_15) {
                            if (var9_12 == null) {
                                var9_12 = var10_15;
                                throw var9_12;
                            }
                            if (var9_12 == var10_15) throw var9_12;
                            var9_12.addSuppressed(var10_15);
                            throw var9_12;
                        }
                        {
                            do {
                                if ((object /* !! */  = forObject) != null) ** GOTO lbl-1000
                                objectName = this.objectNameColumn instanceof Number != false ? JDBCUtils.safeGetString((ResultSet)dbResult, ((Number)this.objectNameColumn).intValue()) : JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, this.objectNameColumn.toString());
                                if (objectName == null) {
                                    JDBCStructCache.log.debug((Object)("NULL object name in " + String.valueOf((Object)this)));
                                } else {
                                    object /* !! */  = super.getCachedObject(objectName);
                                    if (object /* !! */  == null) {
                                        JDBCStructCache.log.debug((Object)("Object '" + objectName + "' not found in struct cache (" + this.getClass().getSimpleName() + ")"));
                                    } else if (!this.isChildrenCached(object /* !! */ ) && (child = this.fetchChild(session, owner, object /* !! */ , dbResult)) != null) {
                                        children = (ArrayList<CHILD>)objectMap.get(object /* !! */ );
                                        if (children == null) {
                                            children = new ArrayList<CHILD>();
                                            objectMap.put(object /* !! */ , children);
                                        }
                                        children.add(child);
                                    }
                                }
lbl61:
                                // 6 sources

                                if (dbResult.next()) continue;
                                if (monitor.isCanceled()) {
                                    dbResult.close();
                                    if (dbStat != null) {
                                        dbStat.close();
                                    }
                                    if (session == null) return;
                                    session.close();
                                    return;
                                }
                                break block44;
                            } while (!monitor.isCanceled());
                            dbResult.close();
                            if (dbStat != null) {
                                dbStat.close();
                            }
                            if (session == null) return;
                            session.close();
                            return;
                        }
                    }
                    ** try [egrp 12[TRYBLOCK] [2 : 440->640)] { 
lbl79:
                    // 1 sources

                    var14_19 = objectMap.entrySet().iterator();
                    while (true) {
                        if (!var14_19.hasNext()) {
                            if (forObject == null) {
                                break;
                            }
                            break block45;
                        }
                        colEntry = var14_19.next();
                        if (this.isChildrenCached((DBSObject)colEntry.getKey())) continue;
                        this.cacheChildren((DBSObject)colEntry.getKey(), (List)colEntry.getValue());
                    }
                    if (objectMap.isEmpty() != false) return;
                    var14_19 = this.getAllObjects(monitor, (DBSObject)owner).iterator();
                    while (true) {
                        if (!var14_19.hasNext()) {
                            this.childrenCached = true;
                            return;
                        }
                        tmpObject = (DBSObject)var14_19.next();
                        if (this.isChildrenCached(tmpObject) || objectMap.containsKey(tmpObject)) continue;
                        this.cacheChildren(tmpObject, new ArrayList<E>());
                    }
                }
                if (objectMap.containsKey(forObject) != false) return;
                this.cacheChildren(forObject, new ArrayList<E>());
                return;
lbl103:
                // 1 sources

                finally {
                    dbResult.close();
                }
            }
            catch (Throwable var6_9) {
                if (var5_5 == null) {
                    var5_5 = var6_9;
                    throw var5_5;
                }
                if (var5_5 == var6_9) throw var5_5;
                var5_5.addSuppressed(var6_9);
                throw var5_5;
            }
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex, dataSource);
        }
    }

    public void removeObject(@NotNull OBJECT object, boolean resetFullCache) {
        super.removeObject(object, resetFullCache);
        this.clearChildrenCache(object);
    }

    public void clearCache() {
        this.clearChildrenCache(null);
        super.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBSObjectCache<OBJECT, CHILD> getChildrenCache(OBJECT forObject) {
        Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> map = this.childrenCache;
        synchronized (map) {
            SimpleObjectCache<OBJECT, CHILD> nestedCache = this.childrenCache.get(forObject);
            if (nestedCache == null) {
                nestedCache = this.createNestedCache();
                nestedCache.setCache(new ArrayList());
                this.childrenCache.put(forObject, nestedCache);
            }
            return nestedCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<CHILD> getChildren(DBRProgressMonitor monitor, OWNER owner, OBJECT forObject) throws DBException {
        this.loadChildren(monitor, owner, forObject);
        Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> map = this.childrenCache;
        synchronized (map) {
            SimpleObjectCache<OBJECT, CHILD> nestedCache = this.childrenCache.get(forObject);
            return nestedCache == null ? null : nestedCache.getAllObjects(monitor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CHILD getChild(DBRProgressMonitor monitor, OWNER owner, OBJECT forObject, String objectName) throws DBException {
        this.loadChildren(monitor, owner, forObject);
        Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> map = this.childrenCache;
        synchronized (map) {
            SimpleObjectCache<OBJECT, CHILD> nestedCache = this.childrenCache.get(forObject);
            return (CHILD)(nestedCache == null ? null : nestedCache.getObject(monitor, forObject, objectName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChildrenCache(OBJECT forParent) {
        Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> map = this.childrenCache;
        synchronized (map) {
            if (forParent != null) {
                this.childrenCache.remove(forParent);
            } else {
                this.childrenCache.clear();
            }
            this.childrenCached = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isChildrenCached(OBJECT parent) {
        Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> map = this.childrenCache;
        synchronized (map) {
            return this.childrenCache.containsKey(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheChildren(OBJECT parent, List<CHILD> children) {
        Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> map = this.childrenCache;
        synchronized (map) {
            SimpleObjectCache<OBJECT, CHILD> nestedCache = this.childrenCache.get(parent);
            if (nestedCache == null) {
                nestedCache = this.createNestedCache();
                this.childrenCache.put(parent, nestedCache);
            }
            nestedCache.setCache(children);
        }
    }

    @NotNull
    protected SimpleObjectCache<OBJECT, CHILD> createNestedCache() {
        SimpleObjectCache nestedCache = new SimpleObjectCache();
        nestedCache.setCaseSensitive(this.caseSensitive);
        return nestedCache;
    }
}

