/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai;

import com.theokanning.openai.DeleteResult;
import com.theokanning.openai.OpenAiResponse;
import com.theokanning.openai.completion.CompletionRequest;
import com.theokanning.openai.completion.CompletionResult;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatCompletionResult;
import com.theokanning.openai.edit.EditRequest;
import com.theokanning.openai.edit.EditResult;
import com.theokanning.openai.embedding.EmbeddingRequest;
import com.theokanning.openai.embedding.EmbeddingResult;
import com.theokanning.openai.engine.Engine;
import com.theokanning.openai.file.File;
import com.theokanning.openai.finetune.FineTuneEvent;
import com.theokanning.openai.finetune.FineTuneRequest;
import com.theokanning.openai.finetune.FineTuneResult;
import com.theokanning.openai.image.CreateImageRequest;
import com.theokanning.openai.image.ImageResult;
import com.theokanning.openai.model.Model;
import com.theokanning.openai.moderation.ModerationRequest;
import com.theokanning.openai.moderation.ModerationResult;
import io.reactivex.Single;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.Path;

public interface OpenAiApi {
    @GET(value="v1/models")
    public Single<OpenAiResponse<Model>> listModels();

    @GET(value="/v1/models/{model_id}")
    public Single<Model> getModel(@Path(value="model_id") String var1);

    @POST(value="/v1/completions")
    public Single<CompletionResult> createCompletion(@Body CompletionRequest var1);

    @POST(value="/v1/chat/completions")
    public Single<ChatCompletionResult> createChatCompletion(@Body ChatCompletionRequest var1);

    @Deprecated
    @POST(value="/v1/engines/{engine_id}/completions")
    public Single<CompletionResult> createCompletion(@Path(value="engine_id") String var1, @Body CompletionRequest var2);

    @POST(value="/v1/edits")
    public Single<EditResult> createEdit(@Body EditRequest var1);

    @Deprecated
    @POST(value="/v1/engines/{engine_id}/edits")
    public Single<EditResult> createEdit(@Path(value="engine_id") String var1, @Body EditRequest var2);

    @POST(value="/v1/embeddings")
    public Single<EmbeddingResult> createEmbeddings(@Body EmbeddingRequest var1);

    @Deprecated
    @POST(value="/v1/engines/{engine_id}/embeddings")
    public Single<EmbeddingResult> createEmbeddings(@Path(value="engine_id") String var1, @Body EmbeddingRequest var2);

    @GET(value="/v1/files")
    public Single<OpenAiResponse<File>> listFiles();

    @Multipart
    @POST(value="/v1/files")
    public Single<File> uploadFile(@Part(value="purpose") RequestBody var1, @Part MultipartBody.Part var2);

    @DELETE(value="/v1/files/{file_id}")
    public Single<DeleteResult> deleteFile(@Path(value="file_id") String var1);

    @GET(value="/v1/files/{file_id}")
    public Single<File> retrieveFile(@Path(value="file_id") String var1);

    @POST(value="/v1/fine-tunes")
    public Single<FineTuneResult> createFineTune(@Body FineTuneRequest var1);

    @POST(value="/v1/completions")
    public Single<CompletionResult> createFineTuneCompletion(@Body CompletionRequest var1);

    @GET(value="/v1/fine-tunes")
    public Single<OpenAiResponse<FineTuneResult>> listFineTunes();

    @GET(value="/v1/fine-tunes/{fine_tune_id}")
    public Single<FineTuneResult> retrieveFineTune(@Path(value="fine_tune_id") String var1);

    @POST(value="/v1/fine-tunes/{fine_tune_id}/cancel")
    public Single<FineTuneResult> cancelFineTune(@Path(value="fine_tune_id") String var1);

    @GET(value="/v1/fine-tunes/{fine_tune_id}/events")
    public Single<OpenAiResponse<FineTuneEvent>> listFineTuneEvents(@Path(value="fine_tune_id") String var1);

    @DELETE(value="/v1/models/{fine_tune_id}")
    public Single<DeleteResult> deleteFineTune(@Path(value="fine_tune_id") String var1);

    @POST(value="/v1/images/generations")
    public Single<ImageResult> createImage(@Body CreateImageRequest var1);

    @POST(value="/v1/images/edits")
    public Single<ImageResult> createImageEdit(@Body RequestBody var1);

    @POST(value="/v1/images/variations")
    public Single<ImageResult> createImageVariation(@Body RequestBody var1);

    @POST(value="/v1/moderations")
    public Single<ModerationResult> createModeration(@Body ModerationRequest var1);

    @Deprecated
    @GET(value="v1/engines")
    public Single<OpenAiResponse<Engine>> getEngines();

    @Deprecated
    @GET(value="/v1/engines/{engine_id}")
    public Single<Engine> getEngine(@Path(value="engine_id") String var1);
}

