/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.fluent.models.TopQueryStatisticsInputProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class TopQueryStatisticsInput {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TopQueryStatisticsInput.class);
    @JsonProperty(value="properties", required=true)
    private TopQueryStatisticsInputProperties innerProperties = new TopQueryStatisticsInputProperties();

    private TopQueryStatisticsInputProperties innerProperties() {
        return this.innerProperties;
    }

    public int numberOfTopQueries() {
        return this.innerProperties() == null ? 0 : this.innerProperties().numberOfTopQueries();
    }

    public TopQueryStatisticsInput withNumberOfTopQueries(int numberOfTopQueries) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopQueryStatisticsInputProperties();
        }
        this.innerProperties().withNumberOfTopQueries(numberOfTopQueries);
        return this;
    }

    public String aggregationFunction() {
        return this.innerProperties() == null ? null : this.innerProperties().aggregationFunction();
    }

    public TopQueryStatisticsInput withAggregationFunction(String aggregationFunction) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopQueryStatisticsInputProperties();
        }
        this.innerProperties().withAggregationFunction(aggregationFunction);
        return this;
    }

    public String observedMetric() {
        return this.innerProperties() == null ? null : this.innerProperties().observedMetric();
    }

    public TopQueryStatisticsInput withObservedMetric(String observedMetric) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopQueryStatisticsInputProperties();
        }
        this.innerProperties().withObservedMetric(observedMetric);
        return this;
    }

    public OffsetDateTime observationStartTime() {
        return this.innerProperties() == null ? null : this.innerProperties().observationStartTime();
    }

    public TopQueryStatisticsInput withObservationStartTime(OffsetDateTime observationStartTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopQueryStatisticsInputProperties();
        }
        this.innerProperties().withObservationStartTime(observationStartTime);
        return this;
    }

    public OffsetDateTime observationEndTime() {
        return this.innerProperties() == null ? null : this.innerProperties().observationEndTime();
    }

    public TopQueryStatisticsInput withObservationEndTime(OffsetDateTime observationEndTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopQueryStatisticsInputProperties();
        }
        this.innerProperties().withObservationEndTime(observationEndTime);
        return this;
    }

    public String aggregationWindow() {
        return this.innerProperties() == null ? null : this.innerProperties().aggregationWindow();
    }

    public TopQueryStatisticsInput withAggregationWindow(String aggregationWindow) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopQueryStatisticsInputProperties();
        }
        this.innerProperties().withAggregationWindow(aggregationWindow);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model TopQueryStatisticsInput"));
        }
        this.innerProperties().validate();
    }
}

