/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.MySqlManager;
import com.azure.resourcemanager.mysql.fluent.ServerKeysClient;
import com.azure.resourcemanager.mysql.fluent.models.ServerKeyInner;
import com.azure.resourcemanager.mysql.implementation.ServerKeyImpl;
import com.azure.resourcemanager.mysql.implementation.Utils;
import com.azure.resourcemanager.mysql.models.ServerKey;
import com.azure.resourcemanager.mysql.models.ServerKeys;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class ServerKeysImpl
implements ServerKeys {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ServerKeysImpl.class);
    private final ServerKeysClient innerClient;
    private final MySqlManager serviceManager;

    public ServerKeysImpl(ServerKeysClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ServerKey> list(String resourceGroupName, String serverName) {
        PagedIterable<ServerKeyInner> inner = this.serviceClient().list(resourceGroupName, serverName);
        return Utils.mapPage(inner, inner1 -> new ServerKeyImpl((ServerKeyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ServerKey> list(String resourceGroupName, String serverName, Context context) {
        PagedIterable<ServerKeyInner> inner = this.serviceClient().list(resourceGroupName, serverName, context);
        return Utils.mapPage(inner, inner1 -> new ServerKeyImpl((ServerKeyInner)((Object)inner1), this.manager()));
    }

    @Override
    public ServerKey get(String resourceGroupName, String serverName, String keyName) {
        ServerKeyInner inner = this.serviceClient().get(resourceGroupName, serverName, keyName);
        if (inner != null) {
            return new ServerKeyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ServerKey> getWithResponse(String resourceGroupName, String serverName, String keyName, Context context) {
        Response<ServerKeyInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, keyName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ServerKeyImpl((ServerKeyInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public void delete(String serverName, String keyName, String resourceGroupName) {
        this.serviceClient().delete(serverName, keyName, resourceGroupName);
    }

    @Override
    public void delete(String serverName, String keyName, String resourceGroupName, Context context) {
        this.serviceClient().delete(serverName, keyName, resourceGroupName, context);
    }

    @Override
    public ServerKey getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String keyName = Utils.getValueFromIdByName(id, "keys");
        if (keyName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'keys'.", id)));
        }
        return (ServerKey)this.getWithResponse(resourceGroupName, serverName, keyName, Context.NONE).getValue();
    }

    @Override
    public Response<ServerKey> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String keyName = Utils.getValueFromIdByName(id, "keys");
        if (keyName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'keys'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serverName, keyName, context);
    }

    @Override
    public void deleteById(String id) {
        String serverName = Utils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String keyName = Utils.getValueFromIdByName(id, "keys");
        if (keyName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'keys'.", id)));
        }
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        this.delete(serverName, keyName, resourceGroupName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String serverName = Utils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        String keyName = Utils.getValueFromIdByName(id, "keys");
        if (keyName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'keys'.", id)));
        }
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        this.delete(serverName, keyName, resourceGroupName, context);
    }

    private ServerKeysClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public ServerKeyImpl define(String name) {
        return new ServerKeyImpl(name, this.manager());
    }
}

