/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.mysql.MySqlManager;
import com.azure.resourcemanager.mysql.fluent.models.ServerKeyInner;
import com.azure.resourcemanager.mysql.implementation.Utils;
import com.azure.resourcemanager.mysql.models.ServerKey;
import com.azure.resourcemanager.mysql.models.ServerKeyType;
import java.time.OffsetDateTime;

public final class ServerKeyImpl
implements ServerKey,
ServerKey.Definition,
ServerKey.Update {
    private ServerKeyInner innerObject;
    private final MySqlManager serviceManager;
    private String serverName;
    private String keyName;
    private String resourceGroupName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String kind() {
        return this.innerModel().kind();
    }

    @Override
    public ServerKeyType serverKeyType() {
        return this.innerModel().serverKeyType();
    }

    @Override
    public String uri() {
        return this.innerModel().uri();
    }

    @Override
    public OffsetDateTime creationDate() {
        return this.innerModel().creationDate();
    }

    @Override
    public ServerKeyInner innerModel() {
        return this.innerObject;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public ServerKeyImpl withExistingServer(String serverName, String resourceGroupName) {
        this.serverName = serverName;
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ServerKey create() {
        this.innerObject = this.serviceManager.serviceClient().getServerKeys().createOrUpdate(this.serverName, this.keyName, this.resourceGroupName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ServerKey create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getServerKeys().createOrUpdate(this.serverName, this.keyName, this.resourceGroupName, this.innerModel(), context);
        return this;
    }

    ServerKeyImpl(String name, MySqlManager serviceManager) {
        this.innerObject = new ServerKeyInner();
        this.serviceManager = serviceManager;
        this.keyName = name;
    }

    @Override
    public ServerKeyImpl update() {
        return this;
    }

    @Override
    public ServerKey apply() {
        this.innerObject = this.serviceManager.serviceClient().getServerKeys().createOrUpdate(this.serverName, this.keyName, this.resourceGroupName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ServerKey apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getServerKeys().createOrUpdate(this.serverName, this.keyName, this.resourceGroupName, this.innerModel(), context);
        return this;
    }

    ServerKeyImpl(ServerKeyInner innerObject, MySqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.serverName = Utils.getValueFromIdByName(innerObject.id(), "servers");
        this.keyName = Utils.getValueFromIdByName(innerObject.id(), "keys");
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
    }

    @Override
    public ServerKey refresh() {
        this.innerObject = (ServerKeyInner)((Object)this.serviceManager.serviceClient().getServerKeys().getWithResponse(this.resourceGroupName, this.serverName, this.keyName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ServerKey refresh(Context context) {
        this.innerObject = (ServerKeyInner)((Object)this.serviceManager.serviceClient().getServerKeys().getWithResponse(this.resourceGroupName, this.serverName, this.keyName, context).getValue());
        return this;
    }

    @Override
    public ServerKeyImpl withServerKeyType(ServerKeyType serverKeyType) {
        this.innerModel().withServerKeyType(serverKeyType);
        return this;
    }

    @Override
    public ServerKeyImpl withUri(String uri) {
        this.innerModel().withUri(uri);
        return this;
    }
}

