/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.MySqlManager;
import com.azure.resourcemanager.mysql.fluent.AdvisorsClient;
import com.azure.resourcemanager.mysql.fluent.models.AdvisorInner;
import com.azure.resourcemanager.mysql.implementation.AdvisorImpl;
import com.azure.resourcemanager.mysql.implementation.Utils;
import com.azure.resourcemanager.mysql.models.Advisor;
import com.azure.resourcemanager.mysql.models.Advisors;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class AdvisorsImpl
implements Advisors {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AdvisorsImpl.class);
    private final AdvisorsClient innerClient;
    private final MySqlManager serviceManager;

    public AdvisorsImpl(AdvisorsClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Advisor get(String resourceGroupName, String serverName, String advisorName) {
        AdvisorInner inner = this.serviceClient().get(resourceGroupName, serverName, advisorName);
        if (inner != null) {
            return new AdvisorImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Advisor> getWithResponse(String resourceGroupName, String serverName, String advisorName, Context context) {
        Response<AdvisorInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, advisorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AdvisorImpl((AdvisorInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PagedIterable<Advisor> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<AdvisorInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return Utils.mapPage(inner, inner1 -> new AdvisorImpl((AdvisorInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Advisor> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<AdvisorInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return Utils.mapPage(inner, inner1 -> new AdvisorImpl((AdvisorInner)((Object)inner1), this.manager()));
    }

    private AdvisorsClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }
}

