/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.registry;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.registry.task.TaskTypeDescriptor;
import org.jkiss.dbeaver.tools.registry.ToolGroupDescriptor;
import org.jkiss.dbeaver.tools.registry.ToolsRegistry;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.utils.CommonUtils;

public class ToolDescriptor
extends AbstractDescriptor {
    private final String id;
    private final String label;
    private final String description;
    private final DBPImage icon;
    private final boolean singleton;
    private final ToolGroupDescriptor group;
    private final Set<String> toolImplTaskIds;
    private final Set<ToolCommandRef> toolCommandRefs;

    public ToolDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.singleton = CommonUtils.toBoolean((Object)config.getAttribute("singleton"));
        String groupId = config.getAttribute("group");
        this.group = CommonUtils.isEmpty((String)groupId) ? null : ToolsRegistry.getInstance().getToolGroup(groupId);
        this.toolImplTaskIds = Stream.of(config.getChildren("task")).map(e -> e.getAttribute("id")).collect(Collectors.toSet());
        this.toolCommandRefs = Stream.of(config.getChildren("command")).map(e -> new ToolCommandRef((IConfigurationElement)e)).collect(Collectors.toSet());
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public ToolGroupDescriptor getGroup() {
        return this.group;
    }

    public String toString() {
        return this.id + " (" + this.label + ")";
    }

    @Nullable
    public TaskTypeDescriptor getTaskForObjects(@NotNull Collection<DBSObject> objects) {
        for (String taskId : this.toolImplTaskIds) {
            TaskTypeDescriptor task = TaskRegistry.getInstance().getTaskType(taskId);
            if (task == null) continue;
            if (!objects.stream().allMatch(arg_0 -> ((TaskTypeDescriptor)task).appliesTo(arg_0))) continue;
            return task;
        }
        return null;
    }

    @Nullable
    public Command getCommandForObjects(@NotNull Collection<DBSObject> objects) {
        for (ToolCommandRef cmdRef : this.toolCommandRefs) {
            if (!objects.stream().allMatch(arg_0 -> ((ToolCommandRef)cmdRef).appliesTo(arg_0))) continue;
            return cmdRef.getCommand();
        }
        return null;
    }

    public boolean appliesTo(@NotNull DBPObject item) {
        for (String taskId : this.toolImplTaskIds) {
            TaskTypeDescriptor task = TaskRegistry.getInstance().getTaskType(taskId);
            if (task == null || !task.appliesTo(item)) continue;
            return true;
        }
        for (ToolCommandRef cmdRef : this.toolCommandRefs) {
            if (!cmdRef.appliesTo(item)) continue;
            return true;
        }
        return false;
    }

    private static class ToolCommandRef
    extends AbstractContextDescriptor {
        public final String commandId;
        private Command command = null;

        public ToolCommandRef(@NotNull IConfigurationElement e) {
            super(e);
            this.commandId = e.getAttribute("id");
        }

        @Nullable
        public Command getCommand() {
            return this.command != null ? this.command : (this.command = ActionUtils.findCommand((String)this.commandId));
        }

        protected Object adaptType(DBPObject object) {
            if (object instanceof DBSObject) {
                return ((DBSObject)object).getDataSource();
            }
            return super.adaptType(object);
        }
    }
}

