/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.wizard;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.commands.SQLCommandSet;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIMessages;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.AdvancedTextCellEditor;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.utils.CommonUtils;

public class EditTaskVariablesDialog
extends StatusDialog {
    private static final String DIALOG_ID = "DBeaver.SQLQueryParameterBindDialog";
    private final List<TaskVariableList> variables;
    private TreeViewer viewer;

    public EditTaskVariablesDialog(@NotNull Shell shell, @NotNull Map<DBTTask, Map<String, Object>> variables) {
        super(shell);
        this.setTitle(TaskUIMessages.edit_task_variabl_dialog_title_task_variables);
        this.variables = variables.entrySet().stream().map(entry -> {
            DBTTask key = (DBTTask)entry.getKey();
            ArrayList vars = ((Map)entry.getValue()).entrySet().stream().map(variable -> new TaskVariable((String)variable.getKey(), CommonUtils.toString(variable.getValue()))).collect(Collectors.toCollection(ArrayList::new));
            return new TaskVariableList(key, vars);
        }).toList();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite paramsComposite = UIUtils.createComposite((Composite)composite, (int)1);
        paramsComposite.setLayoutData((Object)new GridData(1808));
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 200;
        this.viewer = new TreeViewer(paramsComposite, 67586);
        this.viewer.getTree().setLayoutData((Object)gd);
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(!UIStyles.isDarkTheme());
        this.viewer.setContentProvider((IContentProvider)new TreeContentProvider(){

            /*
             * WARNING - void declaration
             */
            public Object[] getChildren(Object parent) {
                Object object = parent;
                if (object instanceof TaskVariableList) {
                    void list;
                    TaskVariableList taskVariableList = (TaskVariableList)object;
                    TaskVariableList cfr_ignored_0 = (TaskVariableList)object;
                    return list.variables().toArray();
                }
                return new Object[0];
            }

            public boolean hasChildren(Object element) {
                return element instanceof TaskVariableList;
            }
        });
        TreeViewerColumn taskColumn = new TreeViewerColumn(this.viewer, 16384);
        taskColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            /*
             * WARNING - void declaration
             */
            public String getText(Object element) {
                Object object = element;
                if (object instanceof TaskVariableList) {
                    void list;
                    TaskVariableList taskVariableList = (TaskVariableList)object;
                    TaskVariableList cfr_ignored_0 = (TaskVariableList)object;
                    return list.task.getName();
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            public Image getImage(Object element) {
                Object object = element;
                if (object instanceof TaskVariableList) {
                    void list;
                    TaskVariableList taskVariableList = (TaskVariableList)object;
                    TaskVariableList cfr_ignored_0 = (TaskVariableList)object;
                    if (list.task.getType().getIcon() != null) {
                        return DBeaverIcons.getImage((DBPImage)list.task.getType().getIcon());
                    }
                }
                return null;
            }
        });
        taskColumn.getColumn().setText(TaskUIMessages.edit_task_variabl_dialog_column_task);
        TreeViewerColumn nameColumn = new TreeViewerColumn(this.viewer, 16384);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            /*
             * WARNING - void declaration
             */
            public String getText(Object element) {
                Object object = element;
                if (object instanceof TaskVariable) {
                    void variable;
                    TaskVariable taskVariable = (TaskVariable)object;
                    TaskVariable cfr_ignored_0 = (TaskVariable)object;
                    return variable.name;
                }
                return null;
            }
        });
        nameColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)EditTaskVariablesDialog.this.viewer.getTree());
            }

            protected boolean canEdit(Object element) {
                return element instanceof TaskVariable;
            }

            protected Object getValue(Object element) {
                String value = ((TaskVariable)element).name;
                if (value.chars().anyMatch(Character::isLowerCase)) {
                    return BasicSQLDialect.INSTANCE.getQuotedIdentifier(value, true, false);
                }
                return value;
            }

            protected void setValue(Object element, Object value) {
                ((TaskVariable)element).name = SQLCommandSet.prepareVarName((SQLDialect)BasicSQLDialect.INSTANCE, (String)((String)value));
                EditTaskVariablesDialog.this.viewer.update(element, null);
            }
        });
        nameColumn.getColumn().setText(TaskUIMessages.edit_task_variabl_dialog_column_variable);
        TreeViewerColumn valueColumn = new TreeViewerColumn(this.viewer, 16384);
        valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            /*
             * WARNING - void declaration
             */
            public String getText(Object element) {
                Object object = element;
                if (object instanceof TaskVariable) {
                    void variable;
                    TaskVariable taskVariable = (TaskVariable)object;
                    TaskVariable cfr_ignored_0 = (TaskVariable)object;
                    return variable.value;
                }
                return null;
            }
        });
        valueColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){

            protected CellEditor getCellEditor(Object element) {
                return new AdvancedTextCellEditor((Composite)EditTaskVariablesDialog.this.viewer.getTree());
            }

            protected boolean canEdit(Object element) {
                return element instanceof TaskVariable;
            }

            protected Object getValue(Object element) {
                return ((TaskVariable)element).value;
            }

            protected void setValue(Object element, Object value) {
                ((TaskVariable)element).value = (String)value;
                EditTaskVariablesDialog.this.viewer.update(element, null);
            }
        });
        valueColumn.getColumn().setText(TaskUIMessages.edit_task_variabl_dialog_column_value);
        ToolBar toolbar = new ToolBar(composite, 0x800100);
        ToolItem newButton = UIUtils.createToolItem((ToolBar)toolbar, null, (DBPImage)UIIcon.ROW_ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreePath path = EditTaskVariablesDialog.this.viewer.getStructuredSelection().getPaths()[0];
                TaskVariableList list = (TaskVariableList)path.getFirstSegment();
                TaskVariable variable = new TaskVariable("var", "value");
                list.variables.add(variable);
                EditTaskVariablesDialog.this.viewer.refresh((Object)list);
                EditTaskVariablesDialog.this.viewer.setSelection((ISelection)new StructuredSelection((Object)variable), true);
                EditTaskVariablesDialog.this.viewer.editElement((Object)variable, 1);
            }
        });
        ToolItem deleteButton = UIUtils.createToolItem((ToolBar)toolbar, null, (DBPImage)UIIcon.ROW_DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreePath path = EditTaskVariablesDialog.this.viewer.getStructuredSelection().getPaths()[0];
                TaskVariableList list = (TaskVariableList)path.getFirstSegment();
                TaskVariable variable = (TaskVariable)path.getLastSegment();
                List<TaskVariable> variables = list.variables;
                int index = variables.indexOf(variable);
                variables.remove(index);
                EditTaskVariablesDialog.this.viewer.refresh((Object)list);
                if (!variables.isEmpty()) {
                    EditTaskVariablesDialog.this.viewer.setSelection((ISelection)new StructuredSelection((Object)variables.get(CommonUtils.clamp((int)index, (int)0, (int)(variables.size() - 1)))));
                }
            }
        });
        newButton.setEnabled(false);
        deleteButton.setEnabled(false);
        this.viewer.addSelectionChangedListener(event -> {
            Object element = this.viewer.getStructuredSelection().getFirstElement();
            newButton.setEnabled(element instanceof TaskVariableList || element instanceof TaskVariable);
            deleteButton.setEnabled(element instanceof TaskVariable);
        });
        UIUtils.asyncExec(() -> {
            this.viewer.setInput(this.variables);
            this.viewer.expandAll(true);
            UIUtils.packColumns((Tree)this.viewer.getTree(), (boolean)true, (float[])new float[]{0.1f, 0.2f, 0.7f});
        });
        return composite;
    }

    @NotNull
    public Map<String, Object> getVariables(@NotNull DBTTask task) {
        return this.variables.stream().filter(l -> l.task == task).flatMap(l -> l.variables.stream()).collect(Collectors.toMap(v -> v.name, v -> v.value));
    }

    private static class TaskVariable {
        private String name;
        private String value;

        private TaskVariable(@NotNull String name, @NotNull String value) {
            this.name = name;
            this.value = value;
        }
    }

    private record TaskVariableList(@NotNull DBTTask task, @NotNull List<TaskVariable> variables) {
    }
}

