/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.chart.model;

import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ChartSampleFunction {
    AVG{

        @Override
        public Number execute(List<Number> values) {
            return values.isEmpty() ? 0.0 : SUM.execute(values).doubleValue() / (double)values.size();
        }
    }
    ,
    SUM{

        @Override
        public Number execute(List<Number> values) {
            double sum = 0.0;
            for (Number n : values) {
                sum += n.doubleValue();
            }
            return sum;
        }
    }
    ,
    FIRST{

        @Override
        public Number execute(List<Number> values) {
            return values.isEmpty() ? (Number)0.0 : (Number)values.get(0);
        }
    }
    ,
    LAST{

        @Override
        public Number execute(List<Number> values) {
            return values.isEmpty() ? (Number)0.0 : (Number)values.get(values.size() - 1);
        }
    }
    ,
    MIN{

        @Override
        public Number execute(List<Number> values) {
            double min = Double.NaN;
            for (Number n : values) {
                double d = min = Double.isNaN(min) ? n.doubleValue() : Math.min(min, n.doubleValue());
            }
            return min;
        }
    }
    ,
    MAX{

        @Override
        public Number execute(List<Number> values) {
            double max = Double.NaN;
            for (Number n : values) {
                double d = max = Double.isNaN(max) ? n.doubleValue() : Math.max(max, n.doubleValue());
            }
            return max;
        }
    }
    ,
    COUNT{

        @Override
        public Number execute(List<Number> values) {
            return values.size();
        }
    };


    public abstract Number execute(List<Number> var1);
}

