/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.odbc.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.CommonUtils;

public class OdbcDataSource
extends GenericDataSource {
    public OdbcDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull GenericMetaModel metaModel, @NotNull SQLDialect dialect) throws DBException {
        super(monitor, container, metaModel, dialect);
    }

    @NotNull
    public static String getConnectionURL(@NotNull DBPDataSourceContainer container, @NotNull DBPConnectionConfiguration configuration) {
        String mode;
        StringBuilder buffer = new StringBuilder("jdbc:dbodbc:");
        switch (mode = Objects.requireNonNullElse(configuration.getProviderProperty("odbc-connection-mode"), "dsn")) {
            case "dsn": {
                buffer.append("DSN=").append(configuration.getDatabaseName()).append(';');
                break;
            }
            case "manual": {
                buffer.append("DRIVER=").append(configuration.getServerName()).append(';');
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported connection mode: " + mode);
            }
        }
        return buffer.toString();
    }

    @NotNull
    public static Map<String, String> getConnectionProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull DBPConnectionConfiguration configuration) {
        String mode = configuration.getProviderProperty("odbc-connection-mode");
        HashMap<String, String> props = new HashMap<String, String>();
        if ("manual".equals(mode)) {
            props.put("Server", configuration.getHostName());
            props.put("Port", configuration.getHostPort());
            if (CommonUtils.isNotEmpty((String)configuration.getDatabaseName())) {
                props.put("Database", configuration.getDatabaseName());
            }
        }
        if (container.getNavigatorSettings().isShowSystemObjects()) {
            props.putIfAbsent("ShowSystemTables", "1");
        }
        if (container.isConnectionReadOnly()) {
            props.putIfAbsent("ReadOnly", "1");
        }
        return props;
    }

    protected String getConnectionURL(DBPConnectionConfiguration configuration) {
        return OdbcDataSource.getConnectionURL(this.container, configuration);
    }

    protected boolean isPopulateClientAppName() {
        return false;
    }

    @Nullable
    protected Map<String, String> getInternalConnectionProperties(DBRProgressMonitor monitor, DBPDriver driver, JDBCExecutionContext context, String purpose, DBPConnectionConfiguration configuration) {
        return OdbcDataSource.getConnectionProperties(monitor, this.container, configuration);
    }
}

