/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;
import org.lightcouch.Attachment;

public class Document {
    @SerializedName(value="_id")
    private String id;
    @SerializedName(value="_rev")
    private String revision;
    @SerializedName(value="_attachments")
    private Map<String, Attachment> attachments;

    public String getId() {
        return this.id;
    }

    public String getRevision() {
        return this.revision;
    }

    public Map<String, Attachment> getAttachments() {
        return this.attachments;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setAttachments(Map<String, Attachment> attachments) {
        this.attachments = attachments;
    }

    public Document() {
    }

    public Document(Document other) {
        this.setId(other.getId());
        this.setRevision(other.getRevision());
        if (other.getAttachments() != null) {
            for (Map.Entry<String, Attachment> entry : other.getAttachments().entrySet()) {
                Attachment attachment = entry.getValue();
                Attachment copy = new Attachment(attachment.getData(), attachment.getContentType());
                this.addAttachment(entry.getKey(), copy);
            }
        }
    }

    public void addAttachment(String name, Attachment attachment) {
        if (this.attachments == null) {
            this.attachments = new HashMap<String, Attachment>();
        }
        this.attachments.put(name, attachment);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Document other = (Document)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

