/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.sql.plan.diagram.util;

import com.dbeaver.model.sql.plan.emf.SQLPlanNode;
import com.dbeaver.ui.editors.sql.plan.diagram.util.PlanLook;
import java.lang.reflect.Field;
import org.eclipse.graphiti.internal.util.LookManager;
import org.eclipse.graphiti.mm.StyleContainer;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.swt.graphics.Color;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ui.UIUtils;

public class StyleUtil {
    public static final ColorConstant LINE_FOREGROUND = StyleUtil.convertToGraphitiColorConstant(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.lines.foreground"));
    public static final ColorConstant NODE_TEXT_FOREGROUND = StyleUtil.convertToGraphitiColorConstant(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.attributes.foreground"));
    public static final IColorConstant NODE_FOREGROUND = StyleUtil.convertToGraphitiColorConstant(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.entity.name.foreground"));
    public static final IColorConstant NODE_HEAVY_COLOR_START = new ColorConstant(254, 227, 184);
    public static final IColorConstant NODE_HEAVY_COLOR_END = new ColorConstant(206, 63, 34);
    public static final IColorConstant NODE_BACKGROUND = StyleUtil.convertToGraphitiColorConstant(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.attributes.background"));

    public static ColorConstant convertToGraphitiColorConstant(Color color) {
        return new ColorConstant(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Style getStyleForCommonValues(Diagram diagram, SQLPlanNode node) {
        IGaService gaService = Graphiti.getGaService();
        Style style = gaService.findStyle((StyleContainer)diagram, "COMMON-VALUES");
        if (style == null) {
            style = gaService.createPlainStyle((StyleContainer)diagram, "COMMON-VALUES");
            StyleUtil.setCommonValues(style, node);
        }
        return style;
    }

    public static void injectColorsToGrid() throws DBException {
        try {
            Class<LookManager> lookManagerClass = LookManager.class;
            Field defaultLook = lookManagerClass.getDeclaredField("defaultLook");
            defaultLook.setAccessible(true);
            defaultLook.set(LookManager.class, new PlanLook());
        }
        catch (Exception exception) {
            throw new DBException("Error changing grid colors", (Throwable)exception);
        }
    }

    public static Style getStyleForNode(Diagram diagram, SQLPlanNode node) {
        Style parentStyle;
        IGaService gaService = Graphiti.getGaService();
        Style style = gaService.findStyle((StyleContainer)(parentStyle = StyleUtil.getStyleForCommonValues(diagram, node)), "PLANNODE");
        if (style == null) {
            style = gaService.createPlainStyle((StyleContainer)parentStyle, "PLANNODE");
            style.setFilled(Boolean.valueOf(true));
            style.setForeground(gaService.manageColor(diagram, NODE_FOREGROUND));
            style.setBackground(gaService.manageColor(diagram, NODE_BACKGROUND));
        }
        return style;
    }

    private static org.eclipse.graphiti.mm.algorithms.styles.Color prepareGradient(Diagram diagram, SQLPlanNode node) {
        IGaService gaService = Graphiti.getGaService();
        if (node.getPercent() <= 0.0) {
            return gaService.manageColor(diagram, NODE_HEAVY_COLOR_START);
        }
        if (node.getPercent() >= 1.0) {
            return gaService.manageColor(diagram, NODE_HEAVY_COLOR_END);
        }
        return gaService.manageColor(diagram, (IColorConstant)new ColorConstant((int)((double)NODE_HEAVY_COLOR_END.getRed() * node.getPercent() + (double)NODE_HEAVY_COLOR_START.getRed() * (1.0 - node.getPercent())), (int)((double)NODE_HEAVY_COLOR_END.getGreen() * node.getPercent() + (double)NODE_HEAVY_COLOR_START.getGreen() * (1.0 - node.getPercent())), (int)((double)NODE_HEAVY_COLOR_END.getBlue() * node.getPercent() + (double)NODE_HEAVY_COLOR_START.getBlue() * (1.0 - node.getPercent()))));
    }

    public static Style getStyleForHeavyNode(Diagram diagram, SQLPlanNode node) {
        Style parentStyle;
        IGaService gaService = Graphiti.getGaService();
        Style style = gaService.findStyle((StyleContainer)(parentStyle = StyleUtil.getStyleForCommonValues(diagram, node)), "PLANHEAVYNODE");
        if (style == null) {
            style = gaService.createPlainStyle((StyleContainer)parentStyle, "PLANHEAVYNODE");
            style.setFilled(Boolean.valueOf(true));
            style.setLineWidth(Integer.valueOf(2));
        }
        return style;
    }

    public static Style getStyleForNodeText(Diagram diagram, SQLPlanNode node) {
        Style parentStyle;
        IGaService gaService = Graphiti.getGaService();
        Style style = gaService.findStyle((StyleContainer)(parentStyle = StyleUtil.getStyleForCommonValues(diagram, node)), "ECLASS-TEXT");
        if (style == null) {
            style = gaService.createPlainStyle((StyleContainer)parentStyle, "ECLASS-TEXT");
            StyleUtil.setCommonTextValues(diagram, gaService, style);
            style.setFont(gaService.manageDefaultFont(diagram, false, true));
        }
        return style;
    }

    public static org.eclipse.graphiti.mm.algorithms.styles.Color getColorForHeavyText(Diagram diagram, SQLPlanNode node) {
        return StyleUtil.prepareGradient(diagram, node);
    }

    public static Style getStyleForHeavyDecorator(Diagram diagram, SQLPlanNode node) {
        Style parentStyle;
        IGaService gaService = Graphiti.getGaService();
        Style style = gaService.findStyle((StyleContainer)(parentStyle = StyleUtil.getStyleForCommonValues(diagram, node)), "TEXT-DECORATOR-TEXT");
        if (style == null) {
            style = gaService.createPlainStyle((StyleContainer)parentStyle, "TEXT-DECORATOR-TEXT");
            StyleUtil.setCommonTextValues(diagram, gaService, style);
            style.setBackground(gaService.manageColor(diagram, IColorConstant.DARK_GRAY));
        }
        return style;
    }

    public static Style getStyleForTextDecorator(Diagram diagram, SQLPlanNode node) {
        Style parentStyle;
        IGaService gaService = Graphiti.getGaService();
        Style style = gaService.findStyle((StyleContainer)(parentStyle = StyleUtil.getStyleForCommonValues(diagram, node)), "TEXT-DECORATOR-TEXT");
        if (style == null) {
            style = gaService.createPlainStyle((StyleContainer)parentStyle, "TEXT-DECORATOR-TEXT");
            StyleUtil.setCommonTextValues(diagram, gaService, style);
            style.setFont(gaService.manageDefaultFont(diagram, true, false));
        }
        return style;
    }

    private static void setCommonTextValues(Diagram diagram, IGaService gaService, Style style) {
        style.setFilled(Boolean.valueOf(false));
        style.setRotation(Double.valueOf(0.0));
        style.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        style.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        style.setForeground(gaService.manageColor(diagram, (IColorConstant)NODE_TEXT_FOREGROUND));
    }

    private static void setCommonValues(Style style, SQLPlanNode node) {
        style.setLineStyle(node.isCollapsed() ? LineStyle.DASH : LineStyle.SOLID);
        style.setLineVisible(Boolean.valueOf(true));
        style.setLineWidth(Integer.valueOf(2));
        style.setTransparency(Double.valueOf(0.0));
    }
}

