/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.wsdl.Binding;
import com.sforce.ws.wsdl.ComplexType;
import com.sforce.ws.wsdl.Documentation;
import com.sforce.ws.wsdl.Element;
import com.sforce.ws.wsdl.Message;
import com.sforce.ws.wsdl.Part;
import com.sforce.ws.wsdl.PortType;
import com.sforce.ws.wsdl.Service;
import com.sforce.ws.wsdl.SfdcApiType;
import com.sforce.ws.wsdl.Types;
import com.sforce.ws.wsdl.WsdlNode;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class Definitions
extends WsdlNode {
    private Types types;
    private HashMap<QName, Message> messages = new HashMap();
    private String targetNamespace;
    private SfdcApiType apiType;
    private PortType portType;
    private Service service;
    private Binding binding;

    public Types getTypes() {
        return this.types;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public SfdcApiType getApiType() {
        return this.apiType;
    }

    public PortType getPortType() {
        return this.portType;
    }

    public Binding getBinding() throws ConnectionException {
        QName name = this.service.getPort().getBinding();
        if (this.binding.getName().equals(name.getLocalPart()) && this.targetNamespace.equals(name.getNamespaceURI())) {
            return this.binding;
        }
        throw new ConnectionException("Unable to find binding " + name + ". Found " + this.binding.getName() + " instead.");
    }

    public Service getService() {
        return this.service;
    }

    public Message getMessage(QName name) throws ConnectionException {
        Message message = this.messages.get(name);
        if (message == null) {
            throw new ConnectionException("No message found for:" + name);
        }
        return message;
    }

    void read(WsdlParser parser) throws WsdlParseException {
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType != 0) {
                if (eventType == 2) {
                    String name = parser.getName();
                    String namespace = parser.getNamespace();
                    if (name != null && namespace != null) {
                        this.parse(name, namespace, parser);
                    }
                } else if (eventType != 3) {
                    // empty if block
                }
            }
            eventType = parser.next();
        }
        if (this.targetNamespace == null) {
            throw new WsdlParseException("targetNamespace not specified in wsdl:definitions ");
        }
        if (this.binding == null) {
            throw new WsdlParseException("Unable to find wsdl:binding in the specified wsdl");
        }
        if (this.portType == null) {
            throw new WsdlParseException("Unable to find wsdl:portType in the specified wsdl");
        }
        if (this.service == null) {
            throw new WsdlParseException("Unable to find wsdl:service in the specified wsdl");
        }
        try {
            this.updateHeaderTypes();
        }
        catch (ConnectionException e) {
            throw new WsdlParseException("Failed to parse WSDL: " + e.getMessage(), e);
        }
    }

    private void updateHeaderTypes() throws ConnectionException {
        Iterator<Part> headers = this.getBinding().getAllHeaders();
        while (headers.hasNext()) {
            Element element;
            Part part = headers.next();
            QName el = part.getElement();
            if (this.getTypes() == null || !(element = this.getTypes().getElement(el)).isComplexType()) continue;
            ComplexType ct = this.getTypes().getComplexType(element.getType());
            ct.setHeader(true);
        }
    }

    private void parse(String name, String namespace, WsdlParser parser) throws WsdlParseException {
        if ("http://schemas.xmlsoap.org/wsdl/".equals(namespace)) {
            if ("definitions".equals(name)) {
                this.targetNamespace = parser.getAttributeValue(null, "targetNamespace");
                this.apiType = SfdcApiType.getFromNamespace(this.targetNamespace);
            } else if ("types".equals(name)) {
                this.types = new Types();
                this.types.read(parser);
            } else if ("message".equals(name)) {
                Message message = new Message(this.targetNamespace);
                message.read(parser);
                this.messages.put(message.getName(), message);
            } else if ("portType".equals(name)) {
                if (this.portType != null) {
                    throw new WsdlParseException("Found more than one wsdl:portType. WSDL with multiple portType not supported");
                }
                this.portType = new PortType(this);
                this.portType.read(parser);
            } else if ("binding".equals(name)) {
                if (this.binding != null) {
                    throw new WsdlParseException("Found more than one wsdl:binding. WSDL with multiple binding not supported");
                }
                this.binding = new Binding(this);
                this.binding.read(parser);
            } else if ("service".equals(name)) {
                if (this.service != null) {
                    throw new WsdlParseException("Found more than one wsdl:service. WSDL with multiple service not supported");
                }
                this.service = new Service();
                this.service.read(parser);
            } else if ("documentation".equals(name)) {
                new Documentation().read(parser);
            } else {
                throw new WsdlParseException("Unknown element: " + name);
            }
        }
    }

    public String toString() {
        return "Definitions{types=" + this.types + ", messages=" + this.messages + ", targetNamespace='" + this.targetNamespace + '\'' + ", portType=" + this.portType + ", service=" + this.service + '}';
    }
}

