/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.CheckNameAvailabilityWithoutLocationsClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.NameAvailabilityInner;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.MySqlManagementClientImpl;
import com.azure.resourcemanager.mysqlflexibleserver.models.NameAvailabilityRequest;
import reactor.core.publisher.Mono;

public final class CheckNameAvailabilityWithoutLocationsClientImpl
implements CheckNameAvailabilityWithoutLocationsClient {
    private final CheckNameAvailabilityWithoutLocationsService service;
    private final MySqlManagementClientImpl client;

    CheckNameAvailabilityWithoutLocationsClientImpl(MySqlManagementClientImpl client) {
        this.service = (CheckNameAvailabilityWithoutLocationsService)RestProxy.create(CheckNameAvailabilityWithoutLocationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NameAvailabilityInner>> executeWithResponseAsync(NameAvailabilityRequest nameAvailabilityRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (nameAvailabilityRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nameAvailabilityRequest is required and cannot be null."));
        }
        nameAvailabilityRequest.validate();
        String apiVersion = "2021-12-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.execute(this.client.getEndpoint(), "2021-12-01-preview", this.client.getSubscriptionId(), nameAvailabilityRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NameAvailabilityInner>> executeWithResponseAsync(NameAvailabilityRequest nameAvailabilityRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (nameAvailabilityRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nameAvailabilityRequest is required and cannot be null."));
        }
        nameAvailabilityRequest.validate();
        String apiVersion = "2021-12-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.execute(this.client.getEndpoint(), "2021-12-01-preview", this.client.getSubscriptionId(), nameAvailabilityRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NameAvailabilityInner> executeAsync(NameAvailabilityRequest nameAvailabilityRequest) {
        return this.executeWithResponseAsync(nameAvailabilityRequest).flatMap(res -> Mono.justOrEmpty((Object)((NameAvailabilityInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NameAvailabilityInner> executeWithResponse(NameAvailabilityRequest nameAvailabilityRequest, Context context) {
        return (Response)this.executeWithResponseAsync(nameAvailabilityRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NameAvailabilityInner execute(NameAvailabilityRequest nameAvailabilityRequest) {
        return (NameAvailabilityInner)this.executeWithResponse(nameAvailabilityRequest, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MySqlManagementClien")
    public static interface CheckNameAvailabilityWithoutLocationsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.DBforMySQL/checkNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NameAvailabilityInner>> execute(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @BodyParam(value="application/json") NameAvailabilityRequest var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

