/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysqlflexibleserver.MySqlManager;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.AzureADAdministratorsClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.AzureADAdministratorInner;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.AzureADAdministratorImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.Utils;
import com.azure.resourcemanager.mysqlflexibleserver.models.AdministratorName;
import com.azure.resourcemanager.mysqlflexibleserver.models.AzureADAdministrator;
import com.azure.resourcemanager.mysqlflexibleserver.models.AzureADAdministrators;

public final class AzureADAdministratorsImpl
implements AzureADAdministrators {
    private static final ClientLogger LOGGER = new ClientLogger(AzureADAdministratorsImpl.class);
    private final AzureADAdministratorsClient innerClient;
    private final MySqlManager serviceManager;

    public AzureADAdministratorsImpl(AzureADAdministratorsClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void delete(String resourceGroupName, String serverName, AdministratorName administratorName) {
        this.serviceClient().delete(resourceGroupName, serverName, administratorName);
    }

    @Override
    public void delete(String resourceGroupName, String serverName, AdministratorName administratorName, Context context) {
        this.serviceClient().delete(resourceGroupName, serverName, administratorName, context);
    }

    @Override
    public Response<AzureADAdministrator> getWithResponse(String resourceGroupName, String serverName, AdministratorName administratorName, Context context) {
        Response<AzureADAdministratorInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, administratorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AzureADAdministratorImpl((AzureADAdministratorInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AzureADAdministrator get(String resourceGroupName, String serverName, AdministratorName administratorName) {
        AzureADAdministratorInner inner = this.serviceClient().get(resourceGroupName, serverName, administratorName);
        if (inner != null) {
            return new AzureADAdministratorImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<AzureADAdministrator> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<AzureADAdministratorInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return Utils.mapPage(inner, inner1 -> new AzureADAdministratorImpl((AzureADAdministratorInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AzureADAdministrator> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<AzureADAdministratorInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return Utils.mapPage(inner, inner1 -> new AzureADAdministratorImpl((AzureADAdministratorInner)((Object)inner1), this.manager()));
    }

    @Override
    public AzureADAdministrator getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String administratorNameLocal = Utils.getValueFromIdByName(id, "administrators");
        if (administratorNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'administrators'.", id)));
        }
        AdministratorName administratorName = AdministratorName.fromString(administratorNameLocal);
        return (AzureADAdministrator)this.getWithResponse(resourceGroupName, serverName, administratorName, Context.NONE).getValue();
    }

    @Override
    public Response<AzureADAdministrator> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String administratorNameLocal = Utils.getValueFromIdByName(id, "administrators");
        if (administratorNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'administrators'.", id)));
        }
        AdministratorName administratorName = AdministratorName.fromString(administratorNameLocal);
        return this.getWithResponse(resourceGroupName, serverName, administratorName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String administratorNameLocal = Utils.getValueFromIdByName(id, "administrators");
        if (administratorNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'administrators'.", id)));
        }
        AdministratorName administratorName = AdministratorName.fromString(administratorNameLocal);
        this.delete(resourceGroupName, serverName, administratorName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String administratorNameLocal = Utils.getValueFromIdByName(id, "administrators");
        if (administratorNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'administrators'.", id)));
        }
        AdministratorName administratorName = AdministratorName.fromString(administratorNameLocal);
        this.delete(resourceGroupName, serverName, administratorName, context);
    }

    private AzureADAdministratorsClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public AzureADAdministratorImpl define(AdministratorName name) {
        return new AzureADAdministratorImpl(name, this.manager());
    }
}

