/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.mysqlflexibleserver.MySqlManager;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.AzureADAdministratorInner;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.Utils;
import com.azure.resourcemanager.mysqlflexibleserver.models.AdministratorName;
import com.azure.resourcemanager.mysqlflexibleserver.models.AdministratorType;
import com.azure.resourcemanager.mysqlflexibleserver.models.AzureADAdministrator;

public final class AzureADAdministratorImpl
implements AzureADAdministrator,
AzureADAdministrator.Definition,
AzureADAdministrator.Update {
    private AzureADAdministratorInner innerObject;
    private final MySqlManager serviceManager;
    private String resourceGroupName;
    private String serverName;
    private AdministratorName administratorName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public AdministratorType administratorType() {
        return this.innerModel().administratorType();
    }

    @Override
    public String login() {
        return this.innerModel().login();
    }

    @Override
    public String sid() {
        return this.innerModel().sid();
    }

    @Override
    public String tenantId() {
        return this.innerModel().tenantId();
    }

    @Override
    public String identityResourceId() {
        return this.innerModel().identityResourceId();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AzureADAdministratorInner innerModel() {
        return this.innerObject;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public AzureADAdministratorImpl withExistingFlexibleServer(String resourceGroupName, String serverName) {
        this.resourceGroupName = resourceGroupName;
        this.serverName = serverName;
        return this;
    }

    @Override
    public AzureADAdministrator create() {
        this.innerObject = this.serviceManager.serviceClient().getAzureADAdministrators().createOrUpdate(this.resourceGroupName, this.serverName, this.administratorName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public AzureADAdministrator create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAzureADAdministrators().createOrUpdate(this.resourceGroupName, this.serverName, this.administratorName, this.innerModel(), context);
        return this;
    }

    AzureADAdministratorImpl(AdministratorName name, MySqlManager serviceManager) {
        this.innerObject = new AzureADAdministratorInner();
        this.serviceManager = serviceManager;
        this.administratorName = name;
    }

    @Override
    public AzureADAdministratorImpl update() {
        return this;
    }

    @Override
    public AzureADAdministrator apply() {
        this.innerObject = this.serviceManager.serviceClient().getAzureADAdministrators().createOrUpdate(this.resourceGroupName, this.serverName, this.administratorName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public AzureADAdministrator apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAzureADAdministrators().createOrUpdate(this.resourceGroupName, this.serverName, this.administratorName, this.innerModel(), context);
        return this;
    }

    AzureADAdministratorImpl(AzureADAdministratorInner innerObject, MySqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serverName = Utils.getValueFromIdByName(innerObject.id(), "flexibleServers");
        this.administratorName = AdministratorName.fromString(Utils.getValueFromIdByName(innerObject.id(), "administrators"));
    }

    @Override
    public AzureADAdministrator refresh() {
        this.innerObject = (AzureADAdministratorInner)((Object)this.serviceManager.serviceClient().getAzureADAdministrators().getWithResponse(this.resourceGroupName, this.serverName, this.administratorName, Context.NONE).getValue());
        return this;
    }

    @Override
    public AzureADAdministrator refresh(Context context) {
        this.innerObject = (AzureADAdministratorInner)((Object)this.serviceManager.serviceClient().getAzureADAdministrators().getWithResponse(this.resourceGroupName, this.serverName, this.administratorName, context).getValue());
        return this;
    }

    @Override
    public AzureADAdministratorImpl withAdministratorType(AdministratorType administratorType) {
        this.innerModel().withAdministratorType(administratorType);
        return this;
    }

    @Override
    public AzureADAdministratorImpl withLogin(String login) {
        this.innerModel().withLogin(login);
        return this;
    }

    @Override
    public AzureADAdministratorImpl withSid(String sid) {
        this.innerModel().withSid(sid);
        return this;
    }

    @Override
    public AzureADAdministratorImpl withTenantId(String tenantId) {
        this.innerModel().withTenantId(tenantId);
        return this;
    }

    @Override
    public AzureADAdministratorImpl withIdentityResourceId(String identityResourceId) {
        this.innerModel().withIdentityResourceId(identityResourceId);
        return this;
    }
}

