/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.fluent.models;

import com.azure.resourcemanager.mysqlflexibleserver.models.Backup;
import com.azure.resourcemanager.mysqlflexibleserver.models.CreateMode;
import com.azure.resourcemanager.mysqlflexibleserver.models.DataEncryption;
import com.azure.resourcemanager.mysqlflexibleserver.models.HighAvailability;
import com.azure.resourcemanager.mysqlflexibleserver.models.MaintenanceWindow;
import com.azure.resourcemanager.mysqlflexibleserver.models.Network;
import com.azure.resourcemanager.mysqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.mysqlflexibleserver.models.ServerState;
import com.azure.resourcemanager.mysqlflexibleserver.models.ServerVersion;
import com.azure.resourcemanager.mysqlflexibleserver.models.Storage;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class ServerProperties {
    @JsonProperty(value="administratorLogin")
    private String administratorLogin;
    @JsonProperty(value="administratorLoginPassword")
    private String administratorLoginPassword;
    @JsonProperty(value="version")
    private ServerVersion version;
    @JsonProperty(value="availabilityZone")
    private String availabilityZone;
    @JsonProperty(value="createMode")
    private CreateMode createMode;
    @JsonProperty(value="sourceServerResourceId")
    private String sourceServerResourceId;
    @JsonProperty(value="restorePointInTime")
    private OffsetDateTime restorePointInTime;
    @JsonProperty(value="replicationRole")
    private ReplicationRole replicationRole;
    @JsonProperty(value="replicaCapacity", access=JsonProperty.Access.WRITE_ONLY)
    private Integer replicaCapacity;
    @JsonProperty(value="dataEncryption")
    private DataEncryption dataEncryption;
    @JsonProperty(value="state", access=JsonProperty.Access.WRITE_ONLY)
    private ServerState state;
    @JsonProperty(value="fullyQualifiedDomainName", access=JsonProperty.Access.WRITE_ONLY)
    private String fullyQualifiedDomainName;
    @JsonProperty(value="storage")
    private Storage storage;
    @JsonProperty(value="backup")
    private Backup backup;
    @JsonProperty(value="highAvailability")
    private HighAvailability highAvailability;
    @JsonProperty(value="network")
    private Network network;
    @JsonProperty(value="maintenanceWindow")
    private MaintenanceWindow maintenanceWindow;

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ServerProperties withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ServerProperties withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public ServerVersion version() {
        return this.version;
    }

    public ServerProperties withVersion(ServerVersion version) {
        this.version = version;
        return this;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public ServerProperties withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public ServerProperties withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public String sourceServerResourceId() {
        return this.sourceServerResourceId;
    }

    public ServerProperties withSourceServerResourceId(String sourceServerResourceId) {
        this.sourceServerResourceId = sourceServerResourceId;
        return this;
    }

    public OffsetDateTime restorePointInTime() {
        return this.restorePointInTime;
    }

    public ServerProperties withRestorePointInTime(OffsetDateTime restorePointInTime) {
        this.restorePointInTime = restorePointInTime;
        return this;
    }

    public ReplicationRole replicationRole() {
        return this.replicationRole;
    }

    public ServerProperties withReplicationRole(ReplicationRole replicationRole) {
        this.replicationRole = replicationRole;
        return this;
    }

    public Integer replicaCapacity() {
        return this.replicaCapacity;
    }

    public DataEncryption dataEncryption() {
        return this.dataEncryption;
    }

    public ServerProperties withDataEncryption(DataEncryption dataEncryption) {
        this.dataEncryption = dataEncryption;
        return this;
    }

    public ServerState state() {
        return this.state;
    }

    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public Storage storage() {
        return this.storage;
    }

    public ServerProperties withStorage(Storage storage) {
        this.storage = storage;
        return this;
    }

    public Backup backup() {
        return this.backup;
    }

    public ServerProperties withBackup(Backup backup) {
        this.backup = backup;
        return this;
    }

    public HighAvailability highAvailability() {
        return this.highAvailability;
    }

    public ServerProperties withHighAvailability(HighAvailability highAvailability) {
        this.highAvailability = highAvailability;
        return this;
    }

    public Network network() {
        return this.network;
    }

    public ServerProperties withNetwork(Network network) {
        this.network = network;
        return this;
    }

    public MaintenanceWindow maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public ServerProperties withMaintenanceWindow(MaintenanceWindow maintenanceWindow) {
        this.maintenanceWindow = maintenanceWindow;
        return this;
    }

    public void validate() {
        if (this.dataEncryption() != null) {
            this.dataEncryption().validate();
        }
        if (this.storage() != null) {
            this.storage().validate();
        }
        if (this.backup() != null) {
            this.backup().validate();
        }
        if (this.highAvailability() != null) {
            this.highAvailability().validate();
        }
        if (this.network() != null) {
            this.network().validate();
        }
        if (this.maintenanceWindow() != null) {
            this.maintenanceWindow().validate();
        }
    }
}

