/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericPackage;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.hana.model.HANADependency;
import org.jkiss.dbeaver.ext.hana.model.HANAInplaceTableTypeColumn;
import org.jkiss.dbeaver.ext.hana.model.HANAProcedureParameter;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;

public class HANAProcedure
extends GenericProcedure {
    static final String DATA_TYPE_NAME_TABLE_TYPE = "TABLE_TYPE";
    static final String DATA_TYPE_NAME_ANY_TABLE_TYPE = "ANY_TABLE_TYPE";
    private static final String PARAMETER_TYPE_IN = "IN";
    private static final String PARAMETER_TYPE_INOUT = "INOUT";
    private static final String PARAMETER_TYPE_OUT = "OUT";
    private static final String PARAMETER_TYPE_RETURN = "RETURN";
    Map<String, List<HANAInplaceTableTypeColumn>> inplaceTableTypes;

    public HANAProcedure(GenericStructContainer container, String procedureName, String specificName, String description, DBSProcedureType procedureType, GenericFunctionResultType functionResultType) {
        super(container, procedureName, specificName, description, procedureType, functionResultType);
    }

    private void loadInplaceTableTypes(DBRProgressMonitor monitor) throws DBException {
        this.inplaceTableTypes = new HashMap<String, List<HANAInplaceTableTypeColumn>>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.getDataSource(), (String)"Read procedure parameter columns");){
                Object stmt = "SELECT PARAMETER_NAME, COLUMN_NAME, DATA_TYPE_NAME, LENGTH, SCALE";
                stmt = DBSProcedureType.PROCEDURE == this.getProcedureType() ? (String)stmt + " FROM SYS.PROCEDURE_PARAMETER_COLUMNS WHERE SCHEMA_NAME=? AND PROCEDURE_NAME=? ORDER BY PARAMETER_NAME, POSITION" : (String)stmt + " FROM SYS.FUNCTION_PARAMETER_COLUMNS WHERE SCHEMA_NAME=? AND FUNCTION_NAME=? ORDER BY PARAMETER_NAME, POSITION";
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement((String)stmt);){
                    dbStat.setString(1, this.getParentObject().getName());
                    dbStat.setString(2, this.getName());
                    Throwable throwable3 = null;
                    Object var10_16 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String parameterName = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
                            String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (int)2);
                            String typeName = JDBCUtils.safeGetString((ResultSet)dbResult, (int)3);
                            int length = JDBCUtils.safeGetInt((ResultSet)dbResult, (int)4);
                            int scale = JDBCUtils.safeGetInt((ResultSet)dbResult, (int)5);
                            List<HANAInplaceTableTypeColumn> inplaceTableType = this.inplaceTableTypes.get(parameterName);
                            if (inplaceTableType == null) {
                                inplaceTableType = new LinkedList<HANAInplaceTableTypeColumn>();
                                this.inplaceTableTypes.put(parameterName, inplaceTableType);
                            }
                            inplaceTableType.add(new HANAInplaceTableTypeColumn((DBSObject)this, columnName, typeName, inplaceTableType.size() + 1, length, scale));
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, this.getDataSource());
        }
    }

    public void loadProcedureColumns(DBRProgressMonitor monitor) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.getDataSource(), (String)"Read procedure parameter");){
                Object stmt = "SELECT PARAMETER_NAME, DATA_TYPE_NAME, DATA_TYPE_ID, LENGTH, SCALE, POSITION, TABLE_TYPE_SCHEMA, TABLE_TYPE_NAME, IS_INPLACE_TYPE, PARAMETER_TYPE, HAS_DEFAULT_VALUE";
                stmt = DBSProcedureType.PROCEDURE == this.getProcedureType() ? (String)stmt + " FROM SYS.PROCEDURE_PARAMETERS WHERE SCHEMA_NAME=? AND PROCEDURE_NAME=? ORDER BY POSITION" : (String)stmt + " FROM SYS.FUNCTION_PARAMETERS WHERE SCHEMA_NAME=? AND FUNCTION_NAME=? ORDER BY POSITION";
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement((String)stmt);){
                    dbStat.setString(1, this.getParentObject().getName());
                    dbStat.setString(2, this.getName());
                    Throwable throwable3 = null;
                    Object var10_16 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARAMETER_NAME");
                            String typeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATA_TYPE_NAME");
                            int typeId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"DATA_TYPE_ID");
                            int columnSize = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"LENGTH");
                            int scale = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"SCALE");
                            int position = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"POSITION");
                            String parameterTypeStr = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARAMETER_TYPE");
                            boolean hasInplaceTableType = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"IS_INPLACE_TYPE", (String)"TRUE");
                            boolean hasDefaultValue = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"HAS_DEFAULT_VALUE", (String)"TRUE");
                            DBSProcedureParameterKind parameterType = switch (parameterTypeStr) {
                                case PARAMETER_TYPE_IN -> DBSProcedureParameterKind.IN;
                                case PARAMETER_TYPE_INOUT -> DBSProcedureParameterKind.INOUT;
                                case PARAMETER_TYPE_OUT -> DBSProcedureParameterKind.OUT;
                                case PARAMETER_TYPE_RETURN -> DBSProcedureParameterKind.RETURN;
                                default -> DBSProcedureParameterKind.UNKNOWN;
                            };
                            GenericTableBase tableType = null;
                            List<HANAInplaceTableTypeColumn> inplaceTableType = null;
                            if (DATA_TYPE_NAME_TABLE_TYPE.equals(typeName)) {
                                if (hasInplaceTableType) {
                                    if (this.inplaceTableTypes == null) {
                                        this.loadInplaceTableTypes(monitor);
                                    }
                                    inplaceTableType = this.inplaceTableTypes.get(columnName);
                                } else {
                                    String tableTypeSchema = dbResult.getString("TABLE_TYPE_SCHEMA");
                                    String tableTypeName = dbResult.getString("TABLE_TYPE_NAME");
                                    GenericSchema schema = ((GenericDataSource)this.getDataSource()).getSchema(tableTypeSchema);
                                    if (schema != null) {
                                        tableType = schema.getTable(monitor, tableTypeName);
                                    }
                                }
                            }
                            this.addColumn(new HANAProcedureParameter(this, columnName, typeName, typeId, position, columnSize, scale, parameterType, (DBSObject)tableType, inplaceTableType, hasDefaultValue));
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, this.getDataSource());
        }
    }

    @Association
    public List<HANADependency> getDependencies(DBRProgressMonitor monitor) throws DBException {
        return HANADependency.readDependencies(monitor, (DBSObject)this);
    }

    @Property(hidden=true)
    public GenericCatalog getCatalog() {
        return super.getCatalog();
    }

    @Property(hidden=true)
    public GenericPackage getPackage() {
        return super.getPackage();
    }

    @Property(hidden=true)
    public GenericFunctionResultType getFunctionResultType() {
        return super.getFunctionResultType();
    }
}

