/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.impl.struct.DirectObjectReference;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.ui.editors.entity.EntityHyperlink;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLContextInformer;

public class SQLHyperlinkDetector
extends AbstractHyperlinkDetector {
    protected static final Log log = Log.getLog(SQLHyperlinkDetector.class);
    private SQLContextInformer contextInformer;

    public SQLHyperlinkDetector(SQLEditorBase editor, SQLContextInformer contextInformer) {
        this.contextInformer = contextInformer;
    }

    @Nullable
    public synchronized IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IHyperlink[] localScopeRefs = this.findLocalScopeReference(region.getOffset());
        if (localScopeRefs != null) {
            return localScopeRefs;
        }
        this.contextInformer.searchInformation(region);
        if (!this.contextInformer.hasObjects() || this.contextInformer.getKeywordType() == DBPKeywordType.KEYWORD) {
            return null;
        }
        SQLIdentifierDetector.WordRegion wordRegion = this.contextInformer.getWordRegion();
        Region hlRegion = new Region(wordRegion.identStart, wordRegion.identEnd - wordRegion.identStart);
        List<DBSObjectReference> references = this.contextInformer.getObjectReferences();
        IHyperlink[] links = new IHyperlink[references.size()];
        int i = 0;
        int objectsSize = references.size();
        while (i < objectsSize) {
            links[i] = new EntityHyperlink((IWorkbenchSite)this.contextInformer.getEditor().getSite(), references.get(i), (IRegion)hlRegion);
            ++i;
        }
        return links;
    }

    /*
     * Unable to fully structure code
     */
    private IHyperlink[] findLocalScopeReference(int offset) {
        block5: {
            block7: {
                block6: {
                    editor = this.contextInformer.getEditor();
                    context = editor.getSyntaxContext();
                    if (context == null || (token = context.findToken(offset)) == null) break block5;
                    refRegion = new Region(context.getLastAccessedTokenOffset(), token.getInterval().length());
                    var11_6 = token.getDefinition();
                    if (!(var11_6 instanceof SQLQuerySymbolEntry)) break block6;
                    var7_7 = (SQLQuerySymbolEntry)var11_6;
                    (SQLQuerySymbolEntry)var11_6;
                    v0 = def;
                    break block7;
                }
                var12_8 = token.getDefinition();
                if (!(var12_8 instanceof SQLQueryRowsTableDataModel)) ** GOTO lbl-1000
                var9_9 = (SQLQueryRowsTableDataModel)var12_8;
                (SQLQueryRowsTableDataModel)var12_8;
                if (tab.getTable() != null) {
                    v0 = tab.getName().entityName;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = symbolEntry = null;
                }
            }
            if (symbolEntry != null) {
                interval = symbolEntry.getInterval();
                defRegion = new Region(interval.a + context.getLastAccessedScriptElementOffset(), interval.length());
                return new IHyperlink[]{new IHyperlink((IRegion)refRegion, symbolEntry, editor, (IRegion)defRegion){
                    private final /* synthetic */ IRegion val$refRegion;
                    private final /* synthetic */ SQLQuerySymbolEntry val$symbolEntry;
                    private final /* synthetic */ SQLEditorBase val$editor;
                    private final /* synthetic */ IRegion val$defRegion;
                    {
                        this.val$refRegion = iRegion;
                        this.val$symbolEntry = sQLQuerySymbolEntry;
                        this.val$editor = sQLEditorBase;
                        this.val$defRegion = iRegion2;
                    }

                    public IRegion getHyperlinkRegion() {
                        return this.val$refRegion;
                    }

                    public String getTypeLabel() {
                        return null;
                    }

                    public String getHyperlinkText() {
                        return this.val$symbolEntry.getName();
                    }

                    public void open() {
                        TextViewer textViewer = this.val$editor.getTextViewer();
                        if (textViewer != null) {
                            textViewer.setSelectedRange(this.val$defRegion.getOffset(), this.val$defRegion.getLength());
                            textViewer.revealRange(this.val$defRegion.getOffset(), this.val$defRegion.getLength());
                        }
                    }
                }};
            }
            var15_14 = token.getDefinition();
            if (var15_14 instanceof SQLQuerySymbolByDbObjectDefinition) {
                interval = (SQLQuerySymbolByDbObjectDefinition)var15_14;
                (SQLQuerySymbolByDbObjectDefinition)var15_14;
                if (def.getDbObject().getDataSource().getContainer() != null) {
                    return new IHyperlink[]{new EntityHyperlink((IWorkbenchSite)editor.getSite(), (DBSObjectReference)new DirectObjectReference(def.getDbObject().getParentObject(), null, def.getDbObject()), (IRegion)refRegion)};
                }
            }
        }
        return null;
    }

    public String getLastKeyword() {
        SQLIdentifierDetector.WordRegion wordRegion = this.contextInformer.getWordRegion();
        if (wordRegion != null) {
            Region hlRegion = new Region(wordRegion.identStart, wordRegion.identEnd - wordRegion.identStart);
            try {
                IDocument document = this.contextInformer.getEditor().getDocument();
                if (document != null) {
                    return this.contextInformer.getEditor().getDocument().get(hlRegion.getOffset(), hlRegion.getLength());
                }
            }
            catch (BadLocationException e) {
                log.error((Object)e);
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
    }
}

